/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.common;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import javax.xml.namespace.QName;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.api.marshalling.DMNMarshaller;
import org.kie.dmn.model.api.DRGElement;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.Import;
import org.kie.dmn.model.api.ItemDefinition;
import org.kie.dmn.model.v1_2.TDecision;
import org.kie.dmn.model.v1_2.TDecisionService;
import org.kie.dmn.model.v1_2.TInputData;
import org.kie.dmn.model.v1_2.TItemDefinition;
import org.kie.workbench.common.dmn.backend.common.DMNMarshallerImportsHelperImpl;
import org.kie.workbench.common.dmn.backend.common.DMNPathsHelperImpl;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNMarshallerImportsHelperImplTest {
    @Mock
    private DMNPathsHelperImpl pathsHelper;
    @Mock
    private WorkspaceProjectService projectService;
    @Mock
    private IOService ioService;
    @Mock
    private DMNMarshaller marshaller;
    private DMNMarshallerImportsHelperImpl helper;

    @Before
    public void setup() {
        this.helper = (DMNMarshallerImportsHelperImpl)Mockito.spy((Object)new DMNMarshallerImportsHelperImpl(this.pathsHelper, this.projectService, this.ioService));
        this.helper.init(this.marshaller);
    }

    @Test
    public void testGetImportDefinitions() {
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        Import import1 = (Import)Mockito.mock(Import.class);
        Import import2 = (Import)Mockito.mock(Import.class);
        Import import3 = (Import)Mockito.mock(Import.class);
        List<Import> imports = Arrays.asList(import1, import2, import3);
        Definitions definitions1 = (Definitions)Mockito.mock(Definitions.class);
        Definitions definitions2 = (Definitions)Mockito.mock(Definitions.class);
        Definitions definitions3 = (Definitions)Mockito.mock(Definitions.class);
        List<Definitions> definitions = Arrays.asList(definitions1, definitions2, definitions3);
        Mockito.when((Object)definitions1.getNamespace()).thenReturn((Object)"://namespace1");
        Mockito.when((Object)definitions2.getNamespace()).thenReturn((Object)"://namespace2");
        Mockito.when((Object)definitions3.getNamespace()).thenReturn((Object)"://namespace3");
        Mockito.when((Object)import1.getNamespace()).thenReturn((Object)"://namespace1");
        Mockito.when((Object)import2.getNamespace()).thenReturn((Object)"://namespace2-diff");
        Mockito.when((Object)import3.getNamespace()).thenReturn((Object)"://namespace3");
        ((DMNMarshallerImportsHelperImpl)Mockito.doReturn(definitions).when((Object)this.helper)).getOtherDMNDiagramsDefinitions(metadata);
        Map importDefinitions = this.helper.getImportDefinitions(metadata, imports);
        Assert.assertEquals((long)2L, (long)importDefinitions.size());
        Assert.assertEquals((Object)definitions1, importDefinitions.get(import1));
        Assert.assertEquals((Object)definitions3, importDefinitions.get(import3));
    }

    @Test
    public void testGetImportedDRGElements() {
        HashMap<Import, Definitions> importDefinitions = new HashMap<Import, Definitions>();
        Import anImport = (Import)Mockito.mock(Import.class);
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        DRGElement drgElement1 = (DRGElement)Mockito.mock(DRGElement.class);
        DRGElement drgElement2 = (DRGElement)Mockito.mock(DRGElement.class);
        DRGElement drgElement3 = (DRGElement)Mockito.mock(DRGElement.class);
        List<DRGElement> expectedDRGElements = Arrays.asList(drgElement1, drgElement2, drgElement3);
        ((DMNMarshallerImportsHelperImpl)Mockito.doReturn(expectedDRGElements).when((Object)this.helper)).getDrgElementsWithNamespace(definitions, anImport);
        importDefinitions.put(anImport, definitions);
        List actualDRGElements = this.helper.getImportedDRGElements(importDefinitions);
        Assert.assertEquals(expectedDRGElements, (Object)actualDRGElements);
    }

    @Test
    public void testGetImportedItemDefinitions() {
        HashMap<Import, Definitions> importDefinitions = new HashMap<Import, Definitions>();
        Import anImport = (Import)Mockito.mock(Import.class);
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        ItemDefinition itemDefinition1 = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ItemDefinition itemDefinition2 = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ItemDefinition itemDefinition3 = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        List<ItemDefinition> expectedItemDefinitions = Arrays.asList(itemDefinition1, itemDefinition2, itemDefinition3);
        ((DMNMarshallerImportsHelperImpl)Mockito.doReturn(expectedItemDefinitions).when((Object)this.helper)).getItemDefinitionsWithNamespace(definitions, anImport);
        importDefinitions.put(anImport, definitions);
        List actualItemDefinitions = this.helper.getImportedItemDefinitions(importDefinitions);
        Assert.assertEquals(expectedItemDefinitions, (Object)actualItemDefinitions);
    }

    @Test
    public void testGetDrgElementsWithNamespace() {
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        Import anImport = (Import)Mockito.mock(Import.class);
        TDecision drgElement1 = new TDecision();
        TInputData drgElement2 = new TInputData();
        TDecisionService drgElement3 = new TDecisionService();
        List<DRGElement> drgElements = Arrays.asList(drgElement1, drgElement2, drgElement3);
        Mockito.when((Object)anImport.getName()).thenReturn((Object)"model");
        drgElement1.setId("0000-1111");
        drgElement2.setId("2222-3333");
        drgElement3.setId("4444-5555");
        drgElement1.setName("Decision");
        drgElement2.setName("Input Data");
        drgElement3.setName("Decision Service");
        Mockito.when((Object)definitions.getDrgElement()).thenReturn(drgElements);
        List elements = this.helper.getDrgElementsWithNamespace(definitions, anImport);
        Assert.assertEquals((long)3L, (long)elements.size());
        Assert.assertEquals((Object)"model:0000-1111", (Object)((DRGElement)elements.get(0)).getId());
        Assert.assertEquals((Object)"model.Decision", (Object)((DRGElement)elements.get(0)).getName());
        Assert.assertEquals((Object)"model:2222-3333", (Object)((DRGElement)elements.get(1)).getId());
        Assert.assertEquals((Object)"model.Input Data", (Object)((DRGElement)elements.get(1)).getName());
        Assert.assertEquals((Object)"model:4444-5555", (Object)((DRGElement)elements.get(2)).getId());
        Assert.assertEquals((Object)"model.Decision Service", (Object)((DRGElement)elements.get(2)).getName());
    }

    @Test
    public void testGetItemDefinitionsWithNamespace() {
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        Import anImport = (Import)Mockito.mock(Import.class);
        TItemDefinition itemDefinition1 = new TItemDefinition();
        TItemDefinition itemDefinition2 = new TItemDefinition();
        TItemDefinition itemDefinition3 = new TItemDefinition();
        TItemDefinition itemDefinition4 = new TItemDefinition();
        TItemDefinition itemDefinition5 = new TItemDefinition();
        List<ItemDefinition> itemDefinitions = Arrays.asList(itemDefinition1, itemDefinition2, itemDefinition3, itemDefinition4, itemDefinition5);
        itemDefinition1.setName("tUUID");
        itemDefinition2.setName("tPerson");
        itemDefinition3.setName("id");
        itemDefinition4.setName("name");
        itemDefinition5.setName("age");
        itemDefinition1.setTypeRef(new QName("string"));
        itemDefinition2.setTypeRef(null);
        itemDefinition3.setTypeRef(new QName("tUUID"));
        itemDefinition4.setTypeRef(new QName("string"));
        itemDefinition5.setTypeRef(new QName("number"));
        Mockito.when((Object)anImport.getName()).thenReturn((Object)"model");
        Mockito.when((Object)definitions.getItemDefinition()).thenReturn(itemDefinitions);
        List actualItemDefinitions = this.helper.getItemDefinitionsWithNamespace(definitions, anImport);
        Assert.assertEquals((long)5L, (long)actualItemDefinitions.size());
        ItemDefinition actualItemDefinition1 = (ItemDefinition)actualItemDefinitions.get(0);
        Assert.assertEquals((Object)"model.tUUID", (Object)actualItemDefinition1.getName());
        Assert.assertEquals((Object)"string", (Object)actualItemDefinition1.getTypeRef().getLocalPart());
        ItemDefinition actualItemDefinition2 = (ItemDefinition)actualItemDefinitions.get(1);
        Assert.assertEquals((Object)"model.tPerson", (Object)actualItemDefinition2.getName());
        Assert.assertNull((Object)actualItemDefinition2.getTypeRef());
        ItemDefinition actualItemDefinition3 = (ItemDefinition)actualItemDefinitions.get(2);
        Assert.assertEquals((Object)"model.id", (Object)actualItemDefinition3.getName());
        Assert.assertEquals((Object)"model.tUUID", (Object)actualItemDefinition3.getTypeRef().getLocalPart());
        ItemDefinition actualItemDefinition4 = (ItemDefinition)actualItemDefinitions.get(3);
        Assert.assertEquals((Object)"model.name", (Object)actualItemDefinition4.getName());
        Assert.assertEquals((Object)"string", (Object)actualItemDefinition4.getTypeRef().getLocalPart());
        ItemDefinition actualItemDefinition5 = (ItemDefinition)actualItemDefinitions.get(4);
        Assert.assertEquals((Object)"model.age", (Object)actualItemDefinition5.getName());
        Assert.assertEquals((Object)"number", (Object)actualItemDefinition5.getTypeRef().getLocalPart());
    }

    @Test
    public void testGetOtherDMNDiagramsDefinitions() {
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        org.uberfire.backend.vfs.Path path1 = this.makePath("../file1.dmn");
        org.uberfire.backend.vfs.Path path2 = this.makePath("../file2.dmn");
        org.uberfire.backend.vfs.Path path3 = this.makePath("../file3.dmn");
        org.uberfire.backend.vfs.Path path4 = this.makePath("../file4.dmn");
        InputStreamReader inputStreamReader1 = (InputStreamReader)Mockito.mock(InputStreamReader.class);
        InputStreamReader inputStreamReader2 = (InputStreamReader)Mockito.mock(InputStreamReader.class);
        InputStreamReader inputStreamReader3 = (InputStreamReader)Mockito.mock(InputStreamReader.class);
        Definitions definitions1 = (Definitions)Mockito.mock(Definitions.class);
        Definitions definitions2 = (Definitions)Mockito.mock(Definitions.class);
        Definitions definitions3 = (Definitions)Mockito.mock(Definitions.class);
        List<org.uberfire.backend.vfs.Path> paths = Arrays.asList(path1, path2, path3, path4);
        Mockito.when((Object)this.pathsHelper.getDiagramsPaths((WorkspaceProject)Matchers.any())).thenReturn(paths);
        Mockito.when((Object)metadata.getPath()).thenReturn((Object)path2);
        ((DMNMarshallerImportsHelperImpl)Mockito.doReturn(Optional.of(inputStreamReader1)).when((Object)this.helper)).loadPath(path1);
        ((DMNMarshallerImportsHelperImpl)Mockito.doReturn(Optional.of(inputStreamReader2)).when((Object)this.helper)).loadPath(path2);
        ((DMNMarshallerImportsHelperImpl)Mockito.doReturn(Optional.of(inputStreamReader3)).when((Object)this.helper)).loadPath(path3);
        ((DMNMarshallerImportsHelperImpl)Mockito.doReturn(Optional.empty()).when((Object)this.helper)).loadPath(path4);
        Mockito.when((Object)this.marshaller.unmarshal((Reader)inputStreamReader1)).thenReturn((Object)definitions1);
        Mockito.when((Object)this.marshaller.unmarshal((Reader)inputStreamReader2)).thenReturn((Object)definitions2);
        Mockito.when((Object)this.marshaller.unmarshal((Reader)inputStreamReader3)).thenReturn((Object)definitions3);
        List actualDefinitions = this.helper.getOtherDMNDiagramsDefinitions(metadata);
        List<Definitions> expectedDefinitions = Arrays.asList(definitions1, definitions3);
        Assert.assertEquals(expectedDefinitions, (Object)actualDefinitions);
    }

    @Test
    public void testGetOtherDMNDiagramsDefinitionsWhenProjectCannotBeFound() {
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        org.uberfire.backend.vfs.Path path1 = this.makePath("../file1.dmn");
        org.uberfire.backend.vfs.Path path2 = this.makePath("../file2.dmn");
        org.uberfire.backend.vfs.Path path3 = this.makePath("../file3.dmn");
        InputStreamReader inputStreamReader1 = (InputStreamReader)Mockito.mock(InputStreamReader.class);
        InputStreamReader inputStreamReader2 = (InputStreamReader)Mockito.mock(InputStreamReader.class);
        InputStreamReader inputStreamReader3 = (InputStreamReader)Mockito.mock(InputStreamReader.class);
        Definitions definitions1 = (Definitions)Mockito.mock(Definitions.class);
        Definitions definitions2 = (Definitions)Mockito.mock(Definitions.class);
        Definitions definitions3 = (Definitions)Mockito.mock(Definitions.class);
        List<org.uberfire.backend.vfs.Path> paths = Arrays.asList(path1, path2, path3);
        Mockito.when((Object)this.projectService.resolveProject((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class))).thenThrow(new Throwable[]{new NullPointerException()});
        Mockito.when((Object)this.pathsHelper.getDiagramsPaths((WorkspaceProject)Matchers.any())).thenReturn(paths);
        Mockito.when((Object)metadata.getPath()).thenReturn((Object)path2);
        ((DMNMarshallerImportsHelperImpl)Mockito.doReturn(Optional.of(inputStreamReader1)).when((Object)this.helper)).loadPath(path1);
        ((DMNMarshallerImportsHelperImpl)Mockito.doReturn(Optional.of(inputStreamReader2)).when((Object)this.helper)).loadPath(path2);
        ((DMNMarshallerImportsHelperImpl)Mockito.doReturn(Optional.of(inputStreamReader3)).when((Object)this.helper)).loadPath(path3);
        Mockito.when((Object)this.marshaller.unmarshal((Reader)inputStreamReader1)).thenReturn((Object)definitions1);
        Mockito.when((Object)this.marshaller.unmarshal((Reader)inputStreamReader2)).thenReturn((Object)definitions2);
        Mockito.when((Object)this.marshaller.unmarshal((Reader)inputStreamReader3)).thenReturn((Object)definitions3);
        List actualDefinitions = this.helper.getOtherDMNDiagramsDefinitions(metadata);
        List<Definitions> expectedDefinitions = Arrays.asList(definitions1, definitions3);
        Assert.assertEquals(expectedDefinitions, (Object)actualDefinitions);
    }

    @Test
    public void testLoadPath() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Path nioPath = (Path)Mockito.mock(Path.class);
        String expectedContent = "<dmn/>";
        byte[] contentBytes = "<dmn/>".getBytes();
        ((DMNMarshallerImportsHelperImpl)Mockito.doReturn((Object)nioPath).when((Object)this.helper)).convertPath(path);
        Mockito.when((Object)this.ioService.readAllBytes(nioPath)).thenReturn((Object)contentBytes);
        Optional inputStreamReader = this.helper.loadPath(path);
        Assert.assertTrue((boolean)inputStreamReader.isPresent());
        Assert.assertEquals((Object)"<dmn/>", (Object)new Scanner((Readable)inputStreamReader.get()).next());
    }

    @Test
    public void testLoadPathWhenPathDoesNotExist() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Path nioPath = (Path)Mockito.mock(Path.class);
        ((DMNMarshallerImportsHelperImpl)Mockito.doReturn((Object)nioPath).when((Object)this.helper)).convertPath(path);
        Mockito.when((Object)this.ioService.readAllBytes(nioPath)).thenThrow(new Throwable[]{new IOException()});
        Optional inputStreamReader = this.helper.loadPath(path);
        ((DMNMarshallerImportsHelperImpl)Mockito.verify((Object)this.helper)).closeInputStreamReader((InputStreamReader)Matchers.any());
        Assert.assertFalse((boolean)inputStreamReader.isPresent());
    }

    @Test
    public void testCloseInputStreamReader() throws Exception {
        InputStreamReader mutableInputStream = (InputStreamReader)Mockito.mock(InputStreamReader.class);
        this.helper.closeInputStreamReader(mutableInputStream);
        ((InputStreamReader)Mockito.verify((Object)mutableInputStream)).close();
    }

    private org.uberfire.backend.vfs.Path makePath(String uri) {
        PathFactory.PathImpl path = (PathFactory.PathImpl)Mockito.spy((Object)new PathFactory.PathImpl());
        ((PathFactory.PathImpl)Mockito.doReturn((Object)uri).when((Object)path)).toURI();
        return path;
    }
}

