/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.common;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.resource.DMNDefinitionSetResourceType;
import org.kie.workbench.common.dmn.backend.common.DMNPathsHelperImpl;
import org.kie.workbench.common.services.refactoring.backend.server.query.RefactoringQueryServiceImpl;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRequest;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Path;
import org.uberfire.paging.PageResponse;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNPathsHelperImplTest {
    @Mock
    private RefactoringQueryServiceImpl refactoringQueryService;
    @Mock
    private IOService ioService;
    @Mock
    private PageResponse<RefactoringPageRow> pageResponse;
    @Mock
    private WorkspaceProject workspaceProject;
    private DMNDefinitionSetResourceType resourceType;
    private DMNPathsHelperImpl helper;

    @Before
    public void setup() {
        this.resourceType = new DMNDefinitionSetResourceType();
        this.helper = (DMNPathsHelperImpl)Mockito.spy((Object)new DMNPathsHelperImpl(this.refactoringQueryService, this.resourceType, this.ioService));
    }

    @Test
    public void testGetDiagramsPathsWhenWorkspaceProjectIsNull() {
        Path nioPath1 = (Path)Mockito.mock(Path.class);
        Path nioPath2 = (Path)Mockito.mock(Path.class);
        org.uberfire.backend.vfs.Path path1 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path path2 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        DirectoryStreamFake fakeStream = new DirectoryStreamFake(nioPath1, nioPath2);
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)fakeStream).when((Object)this.helper)).getDMNPaths();
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)path1).when((Object)this.helper)).convertPath(nioPath1);
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)path2).when((Object)this.helper)).convertPath(nioPath2);
        List<org.uberfire.backend.vfs.Path> expectedPaths = Arrays.asList(path1, path2);
        List actualPaths = this.helper.getDiagramsPaths(null);
        Assert.assertEquals(expectedPaths, (Object)actualPaths);
    }

    @Test
    public void testGetDiagramsPathsWhenWorkspaceProjectIsNotNull() {
        org.uberfire.backend.vfs.Path rootPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String uri = "/src/path/file.dmn";
        RefactoringPageRow row1 = (RefactoringPageRow)Mockito.mock(RefactoringPageRow.class);
        RefactoringPageRow row2 = (RefactoringPageRow)Mockito.mock(RefactoringPageRow.class);
        RefactoringPageRow row3 = (RefactoringPageRow)Mockito.mock(RefactoringPageRow.class);
        List<RefactoringPageRow> rows = Arrays.asList(row1, row2, row3);
        org.uberfire.backend.vfs.Path path1 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path path2 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path path3 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)this.workspaceProject.getRootPath()).thenReturn((Object)rootPath);
        Mockito.when((Object)rootPath.toURI()).thenReturn((Object)"/src/path/file.dmn");
        Mockito.when((Object)this.refactoringQueryService.query((RefactoringPageRequest)Matchers.any(RefactoringPageRequest.class))).thenReturn(this.pageResponse);
        Mockito.when((Object)this.pageResponse.getPageRowList()).thenReturn(rows);
        Mockito.when((Object)row1.getValue()).thenReturn((Object)path1);
        Mockito.when((Object)row2.getValue()).thenReturn((Object)path2);
        Mockito.when((Object)row3.getValue()).thenReturn((Object)path3);
        List paths = this.helper.getDiagramsPaths(this.workspaceProject);
        Assert.assertEquals((long)3L, (long)paths.size());
        Assert.assertEquals((Object)path1, paths.get(0));
        Assert.assertEquals((Object)path2, paths.get(1));
        Assert.assertEquals((Object)path3, paths.get(2));
    }

    @Test
    public void testGetDMNPaths() {
        Path root = (Path)Mockito.mock(Path.class);
        DirectoryStream.Filter filter = path -> true;
        DirectoryStreamFake expectedStream = new DirectoryStreamFake(new Path[0]);
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)root).when((Object)this.helper)).getStandaloneRootPath();
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)filter).when((Object)this.helper)).dmnAssetsFilter();
        Mockito.when((Object)this.ioService.newDirectoryStream(root, filter)).thenReturn((Object)expectedStream);
        DirectoryStream actualStream = this.helper.getDMNPaths();
        Assert.assertEquals((Object)expectedStream, (Object)actualStream);
    }

    @Test
    public void testDMNAssetsFilter() {
        DirectoryStream.Filter filter = this.helper.dmnAssetsFilter();
        Path nioPath1 = (Path)Mockito.mock(Path.class);
        Path nioPath2 = (Path)Mockito.mock(Path.class);
        org.uberfire.backend.vfs.Path path1 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path path2 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)path1.getFileName()).thenReturn((Object)"/Users/karreiro/projects/dmn-project/file.dmn");
        Mockito.when((Object)path2.getFileName()).thenReturn((Object)"/Users/karreiro/projects/dmn-project/Readme.md");
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)path1).when((Object)this.helper)).convertPath(nioPath1);
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)path2).when((Object)this.helper)).convertPath(nioPath2);
        Assert.assertTrue((boolean)filter.accept((Object)nioPath1));
        Assert.assertFalse((boolean)filter.accept((Object)nioPath2));
    }

    @Test
    public void testGetStandaloneRootPath() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Path expectedPath = (Path)Mockito.mock(Path.class);
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)path).when((Object)this.helper)).newPath("diagrams", "default://master@system/stunner/diagrams");
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)expectedPath).when((Object)this.helper)).convertPath(path);
        Path actualPath = this.helper.getStandaloneRootPath();
        Assert.assertEquals((Object)expectedPath, (Object)actualPath);
    }

    class DirectoryStreamFake
    implements DirectoryStream<Path> {
        private List<Path> paths;

        DirectoryStreamFake(Path ... paths) {
            this.paths = Arrays.asList(paths);
        }

        public Iterator<Path> iterator() {
            return this.paths.iterator();
        }

        public void close() throws IOException {
        }
    }
}

