/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.common;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.v1_1.DRGElement;
import org.kie.workbench.common.dmn.api.definition.v1_1.Decision;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedNode;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.backend.editors.common.DMNIncludedNodeFactory;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;

public class DMNIncludedNodeFactoryTest {
    private DMNIncludedNodeFactory factory;

    @Before
    public void setup() {
        this.factory = new DMNIncludedNodeFactory();
    }

    @Test
    public void testMakeDMNIncludeModel() {
        Path path = (Path)Mockito.mock(Path.class);
        DMNIncludedModel includedModel = (DMNIncludedModel)Mockito.mock(DMNIncludedModel.class);
        String expectedId = "0000-1111-3333-4444";
        String expectedDrgElementName = "Can Drive?";
        String expectedFileName = "file.dmn";
        String expectedModelName = "model";
        String expectedImportedElementId = "model:0000-1111-3333-4444";
        Decision importedElementId = this.makeDecision("0000-1111-3333-4444", "Can Drive?");
        Mockito.when((Object)path.getFileName()).thenReturn((Object)"file.dmn");
        Mockito.when((Object)includedModel.getModelName()).thenReturn((Object)"model");
        DMNIncludedNode node = this.factory.makeDMNIncludeModel(path, includedModel, (DRGElement)importedElementId);
        Assert.assertEquals((Object)"0000-1111-3333-4444", (Object)node.getDrgElementId());
        Assert.assertEquals((Object)"Can Drive?", (Object)node.getDrgElementName());
        Assert.assertEquals((Object)"model:0000-1111-3333-4444", (Object)node.getImportedElementId());
        Assert.assertEquals((Object)"file.dmn", (Object)node.getFileName());
        Assert.assertEquals((Object)"model", (Object)node.getModelName());
        Assert.assertEquals(Decision.class, (Object)node.getDrgElementClass());
    }

    private Decision makeDecision(String id, String name) {
        Decision decision = new Decision();
        decision.setId(new Id(id));
        decision.setName(new Name(name));
        return decision;
    }
}

