/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.included;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedNode;
import org.kie.workbench.common.dmn.backend.common.DMNPathsHelperImpl;
import org.kie.workbench.common.dmn.backend.editors.common.DMNIncludeModelFactory;
import org.kie.workbench.common.dmn.backend.editors.common.DMNIncludedNodesFilter;
import org.kie.workbench.common.dmn.backend.editors.included.DMNIncludedModelsServiceImpl;
import org.kie.workbench.common.dmn.backend.editors.types.exceptions.DMNIncludeModelCouldNotBeCreatedException;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNIncludedModelsServiceImplTest {
    @Mock
    private DMNPathsHelperImpl pathsHelper;
    @Mock
    private DMNIncludeModelFactory includeModelFactory;
    @Mock
    private DMNIncludedNodesFilter includedNodesFilter;
    private DMNIncludedModelsServiceImpl service;

    @Before
    public void setup() {
        this.service = (DMNIncludedModelsServiceImpl)Mockito.spy((Object)new DMNIncludedModelsServiceImpl(this.pathsHelper, this.includeModelFactory, this.includedNodesFilter));
    }

    @Test
    public void testLoadModelsWhenWorkspaceProjectIsNull() throws Exception {
        WorkspaceProject workspaceProject = null;
        Path path1 = (Path)Mockito.mock(Path.class);
        Path path2 = (Path)Mockito.mock(Path.class);
        Path path3 = (Path)Mockito.mock(Path.class);
        DMNIncludedModel dmnIncludedModel1 = (DMNIncludedModel)Mockito.mock(DMNIncludedModel.class);
        DMNIncludedModel dmnIncludedModel2 = (DMNIncludedModel)Mockito.mock(DMNIncludedModel.class);
        Mockito.when((Object)this.pathsHelper.getDiagramsPaths(workspaceProject)).thenReturn(Arrays.asList(path1, path2, path3));
        Mockito.when((Object)this.includeModelFactory.create(path1)).thenReturn((Object)dmnIncludedModel1);
        Mockito.when((Object)this.includeModelFactory.create(path2)).thenReturn((Object)dmnIncludedModel2);
        Mockito.when((Object)this.includeModelFactory.create(path3)).thenThrow(new Throwable[]{new DMNIncludeModelCouldNotBeCreatedException()});
        List dmnIncludedModels = this.service.loadModels(workspaceProject);
        Assert.assertEquals((long)2L, (long)dmnIncludedModels.size());
        Assert.assertEquals((Object)dmnIncludedModel1, dmnIncludedModels.get(0));
        Assert.assertEquals((Object)dmnIncludedModel2, dmnIncludedModels.get(1));
    }

    @Test
    public void testLoadModelsWhenWorkspaceProjectIsNotNull() throws Exception {
        WorkspaceProject workspaceProject = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        Path rootPath = (Path)Mockito.mock(Path.class);
        String uri = "/src/path/file.dmn";
        Path path1 = (Path)Mockito.mock(Path.class);
        Path path2 = (Path)Mockito.mock(Path.class);
        Path path3 = (Path)Mockito.mock(Path.class);
        DMNIncludedModel dmnIncludedModel1 = (DMNIncludedModel)Mockito.mock(DMNIncludedModel.class);
        DMNIncludedModel dmnIncludedModel2 = (DMNIncludedModel)Mockito.mock(DMNIncludedModel.class);
        Mockito.when((Object)workspaceProject.getRootPath()).thenReturn((Object)rootPath);
        Mockito.when((Object)rootPath.toURI()).thenReturn((Object)"/src/path/file.dmn");
        Mockito.when((Object)this.pathsHelper.getDiagramsPaths(workspaceProject)).thenReturn(Arrays.asList(path1, path2, path3));
        Mockito.when((Object)this.includeModelFactory.create(path1)).thenReturn((Object)dmnIncludedModel1);
        Mockito.when((Object)this.includeModelFactory.create(path2)).thenReturn((Object)dmnIncludedModel2);
        Mockito.when((Object)this.includeModelFactory.create(path3)).thenThrow(new Throwable[]{new DMNIncludeModelCouldNotBeCreatedException()});
        List dmnIncludedModels = this.service.loadModels(workspaceProject);
        Assert.assertEquals((long)2L, (long)dmnIncludedModels.size());
        Assert.assertEquals((Object)dmnIncludedModel1, dmnIncludedModels.get(0));
        Assert.assertEquals((Object)dmnIncludedModel2, dmnIncludedModels.get(1));
    }

    @Test
    public void testLoadNodesFromImports() {
        WorkspaceProject workspaceProject = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        DMNIncludedModel includedModel1 = (DMNIncludedModel)Mockito.mock(DMNIncludedModel.class);
        DMNIncludedModel includedModel2 = (DMNIncludedModel)Mockito.mock(DMNIncludedModel.class);
        DMNIncludedModel includedModel3 = (DMNIncludedModel)Mockito.mock(DMNIncludedModel.class);
        Path path1 = (Path)Mockito.mock(Path.class);
        Path path2 = (Path)Mockito.mock(Path.class);
        Path path3 = (Path)Mockito.mock(Path.class);
        DMNIncludedNode node1 = (DMNIncludedNode)Mockito.mock(DMNIncludedNode.class);
        DMNIncludedNode node2 = (DMNIncludedNode)Mockito.mock(DMNIncludedNode.class);
        DMNIncludedNode node3 = (DMNIncludedNode)Mockito.mock(DMNIncludedNode.class);
        DMNIncludedNode node4 = (DMNIncludedNode)Mockito.mock(DMNIncludedNode.class);
        DMNIncludedNode node5 = (DMNIncludedNode)Mockito.mock(DMNIncludedNode.class);
        DMNIncludedNode node6 = (DMNIncludedNode)Mockito.mock(DMNIncludedNode.class);
        DMNIncludedNode node7 = (DMNIncludedNode)Mockito.mock(DMNIncludedNode.class);
        List<DMNIncludedNode> path1Nodes = Arrays.asList(node1, node2, node3, node4);
        List<DMNIncludedNode> path2Nodes = Collections.singletonList(node5);
        List<DMNIncludedNode> path3Nodes = Arrays.asList(node6, node7);
        List<DMNIncludedModel> includedModels = Arrays.asList(includedModel1, includedModel2, includedModel3);
        List<Path> paths = Arrays.asList(path1, path2, path3);
        Mockito.when((Object)this.pathsHelper.getDiagramsPaths(workspaceProject)).thenReturn(paths);
        Mockito.when((Object)this.includedNodesFilter.getNodesFromImports(path1, includedModels)).thenReturn(path1Nodes);
        Mockito.when((Object)this.includedNodesFilter.getNodesFromImports(path2, includedModels)).thenReturn(path2Nodes);
        Mockito.when((Object)this.includedNodesFilter.getNodesFromImports(path3, includedModels)).thenReturn(path3Nodes);
        List actualNodes = this.service.loadNodesFromImports(workspaceProject, includedModels);
        List<DMNIncludedNode> expectedNodes = Arrays.asList(node1, node2, node3, node4, node5, node6, node7);
        Assert.assertEquals(expectedNodes, (Object)actualNodes);
    }
}

