/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.v1_1.KieDMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;

public class QNamePropertyConverter {
    public static QName wbFromDMN(javax.xml.namespace.QName qName, DMNModelInstrumentedBase parent) {
        if (Objects.isNull(qName)) {
            return BuiltInType.UNDEFINED.asQName();
        }
        if (parent instanceof KieDMNModelInstrumentedBase && parent.getURIFEEL().equals(parent.getNamespaceURI(qName.getPrefix()))) {
            return new QName("", qName.getLocalPart());
        }
        return new QName(qName.getNamespaceURI(), qName.getLocalPart(), qName.getPrefix());
    }

    public static void setDMNfromWB(QName qname, Consumer<javax.xml.namespace.QName> setter) {
        if (qname != null) {
            setter.accept(QNamePropertyConverter.dmnFromWB(qname).orElse(null));
        }
    }

    public static Optional<javax.xml.namespace.QName> dmnFromWB(QName wb) {
        if (wb != null) {
            if (Objects.equals(wb, BuiltInType.UNDEFINED.asQName())) {
                return Optional.empty();
            }
            return Optional.of(new javax.xml.namespace.QName(wb.getNamespaceURI(), wb.getLocalPart(), wb.getPrefix()));
        }
        return Optional.empty();
    }
}

