/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.common;

import java.util.Optional;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Package;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.backend.editors.common.DMNDiagramHelper;
import org.kie.workbench.common.dmn.backend.editors.types.exceptions.DMNIncludeModelCouldNotBeCreatedException;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.vfs.Path;

public class DMNIncludeModelFactory {
    private static final String DEFAULT_PACKAGE_NAME = "";
    private final DMNDiagramHelper diagramHelper;
    private final KieModuleService moduleService;

    @Inject
    public DMNIncludeModelFactory(DMNDiagramHelper diagramHelper, KieModuleService moduleService) {
        this.diagramHelper = diagramHelper;
        this.moduleService = moduleService;
    }

    public DMNIncludedModel create(Path path) throws DMNIncludeModelCouldNotBeCreatedException {
        try {
            String fileName = path.getFileName();
            String modelPackage = this.getPackage(path);
            String pathURI = path.toURI();
            String namespace = this.diagramHelper.getNamespace(path);
            return new DMNIncludedModel(fileName, modelPackage, pathURI, namespace);
        }
        catch (Exception e) {
            throw new DMNIncludeModelCouldNotBeCreatedException();
        }
    }

    private String getPackage(Path path) {
        return Optional.ofNullable(this.moduleService.resolvePackage(path)).map(Package::getPackageName).orElse(DEFAULT_PACKAGE_NAME);
    }
}

