/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.model.api.DRGElement;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.ItemDefinition;
import org.kie.dmn.model.v1_2.TImport;
import org.kie.soup.commons.util.Maps;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.v1_1.Import;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.backend.definition.v1_1.DefinitionsConverter;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefinitionsConverterTest {
    private final String NAMESPACE = "SomePreviousSetNamespace";
    @Mock
    private Definitions apiDefinitions;
    @Mock
    private org.kie.workbench.common.dmn.api.definition.v1_1.Definitions wbDefinitions;

    @Test
    public void wbFromDMN() {
        TImport anImport = new TImport();
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        Map importDefinitions = new Maps.Builder().put((Object)anImport, (Object)definitions).build();
        Mockito.when((Object)definitions.getDrgElement()).thenReturn(Arrays.asList((DRGElement)Mockito.mock(DRGElement.class), (DRGElement)Mockito.mock(DRGElement.class)));
        Mockito.when((Object)definitions.getItemDefinition()).thenReturn(Arrays.asList((ItemDefinition)Mockito.mock(ItemDefinition.class), (ItemDefinition)Mockito.mock(ItemDefinition.class), (ItemDefinition)Mockito.mock(ItemDefinition.class)));
        Mockito.when((Object)this.apiDefinitions.getImport()).thenReturn(Collections.singletonList(anImport));
        org.kie.workbench.common.dmn.api.definition.v1_1.Definitions wb = DefinitionsConverter.wbFromDMN((Definitions)this.apiDefinitions, (Map)importDefinitions);
        String defaultNs = (String)wb.getNsContext().get(DMNModelInstrumentedBase.Namespace.DEFAULT.getPrefix());
        String namespace = wb.getNamespace().getValue();
        List imports = wb.getImport();
        Assert.assertEquals((Object)defaultNs, (Object)namespace);
        Assert.assertEquals((long)1L, (long)imports.size());
        Assert.assertEquals((long)2L, (long)((Import)imports.get(0)).getDrgElementsCount());
        Assert.assertEquals((long)3L, (long)((Import)imports.get(0)).getItemDefinitionsCount());
    }

    @Test
    public void dmnFromWB() {
        Mockito.when((Object)this.wbDefinitions.getNamespace()).thenReturn((Object)new Text());
        Definitions dmn = DefinitionsConverter.dmnFromWB((org.kie.workbench.common.dmn.api.definition.v1_1.Definitions)this.wbDefinitions);
        String defaultNs = (String)dmn.getNsContext().get(DMNModelInstrumentedBase.Namespace.DEFAULT.getPrefix());
        String namespace = dmn.getNamespace();
        Assert.assertNotNull((Object)defaultNs);
        Assert.assertEquals((Object)defaultNs, (Object)namespace);
        Mockito.when((Object)this.wbDefinitions.getNamespace()).thenReturn((Object)new Text("SomePreviousSetNamespace"));
        dmn = DefinitionsConverter.dmnFromWB((org.kie.workbench.common.dmn.api.definition.v1_1.Definitions)this.wbDefinitions);
        defaultNs = (String)dmn.getNsContext().get(DMNModelInstrumentedBase.Namespace.DEFAULT.getPrefix());
        namespace = dmn.getNamespace();
        Assert.assertNotNull((Object)defaultNs);
        Assert.assertEquals((Object)defaultNs, (Object)namespace);
        Assert.assertEquals((Object)"SomePreviousSetNamespace", (Object)defaultNs);
    }
}

