/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.List;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.v1_1.DRGElement;
import org.kie.workbench.common.dmn.api.definition.v1_1.Definitions;
import org.kie.workbench.common.dmn.api.definition.v1_1.Import;

public class HrefBuilder {
    public static String getHref(DRGElement drgElement) {
        Definitions definitions;
        if (!drgElement.getId().getValue().contains(":")) {
            return "#" + drgElement.getId().getValue();
        }
        DMNModelInstrumentedBase parent = drgElement.getParent();
        if (parent instanceof DMNDiagram) {
            DMNDiagram diagram = (DMNDiagram)parent;
            definitions = diagram.getDefinitions();
        } else {
            definitions = (Definitions)parent;
        }
        String[] split = drgElement.getId().getValue().split(":");
        String namespace = HrefBuilder.getNamespaceForImport(split[0], definitions.getImport());
        return namespace + "#" + split[1];
    }

    static String getNamespaceForImport(String importName, List<Import> imports) {
        return imports.stream().filter(imp -> imp.getName().getValue().equalsIgnoreCase(importName)).findFirst().get().getNamespace();
    }
}

