/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.included;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModelsService;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedNode;
import org.kie.workbench.common.dmn.backend.common.DMNMarshallerImportsHelper;
import org.kie.workbench.common.dmn.backend.common.DMNPathsHelperImpl;
import org.kie.workbench.common.dmn.backend.definition.v1_1.ImportedItemDefinitionConverter;
import org.kie.workbench.common.dmn.backend.editors.common.DMNIncludedModelFactory;
import org.kie.workbench.common.dmn.backend.editors.common.DMNIncludedNodesFilter;
import org.kie.workbench.common.dmn.backend.editors.types.exceptions.DMNIncludeModelCouldNotBeCreatedException;
import org.uberfire.backend.vfs.Path;

@Service
public class DMNIncludedModelsServiceImpl
implements DMNIncludedModelsService {
    private static Logger LOGGER = Logger.getLogger(DMNIncludedModelsServiceImpl.class.getName());
    private final DMNPathsHelperImpl pathsHelper;
    private final DMNIncludedNodesFilter includedNodesFilter;
    private final DMNIncludedModelFactory includedModelFactory;
    private final DMNMarshallerImportsHelper importsHelper;

    @Inject
    public DMNIncludedModelsServiceImpl(DMNPathsHelperImpl pathsHelper, DMNIncludedNodesFilter includedNodesFilter, DMNIncludedModelFactory includedModelFactory, DMNMarshallerImportsHelper importsHelper) {
        this.pathsHelper = pathsHelper;
        this.includedNodesFilter = includedNodesFilter;
        this.includedModelFactory = includedModelFactory;
        this.importsHelper = importsHelper;
    }

    public List<DMNIncludedModel> loadModels(WorkspaceProject workspaceProject) {
        return this.getPaths(workspaceProject).stream().map(this.getPathDMNIncludeModelFunction()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<DMNIncludedNode> loadNodesFromImports(WorkspaceProject workspaceProject, List<DMNIncludedModel> includedModels) {
        return this.getPaths(workspaceProject).stream().map(path -> this.includedNodesFilter.getNodesFromImports((Path)path, includedModels)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<ItemDefinition> loadItemDefinitionsByNamespace(WorkspaceProject workspaceProject, String modelName, String namespace) {
        return this.importsHelper.getImportedItemDefinitionsByNamespace(workspaceProject, modelName, namespace).stream().map(itemDefinition -> this.wbFromDMN((org.kie.dmn.model.api.ItemDefinition)itemDefinition, modelName)).collect(Collectors.toList());
    }

    private Function<Path, DMNIncludedModel> getPathDMNIncludeModelFunction() {
        return path -> {
            try {
                return this.includedModelFactory.create((Path)path);
            }
            catch (DMNIncludeModelCouldNotBeCreatedException e) {
                LOGGER.warning("The 'DMNIncludedModel' could not be created for " + path.toURI());
                return null;
            }
        };
    }

    private List<Path> getPaths(WorkspaceProject workspaceProject) {
        return this.pathsHelper.getDiagramsPaths(workspaceProject);
    }

    ItemDefinition wbFromDMN(org.kie.dmn.model.api.ItemDefinition itemDefinition, String modelName) {
        return ImportedItemDefinitionConverter.wbFromDMN(itemDefinition, modelName);
    }
}

