/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.model.api.DRGElement;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.ItemDefinition;
import org.kie.dmn.model.v1_2.TImport;
import org.kie.soup.commons.util.Maps;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.v1_1.ImportDMN;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.backend.definition.v1_1.DefinitionsConverter;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefinitionsConverterTest {
    private final String NAMESPACE = "SomePreviousSetNamespace";
    @Mock
    private Definitions apiDefinitions;
    @Mock
    private org.kie.workbench.common.dmn.api.definition.v1_1.Definitions wbDefinitions;

    @Test
    public void wbFromDMN() {
        TImport anImport = new TImport();
        anImport.setImportType(DMNImportTypes.DMN.getDefaultNamespace());
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        Map importDefinitions = new Maps.Builder().put((Object)anImport, (Object)definitions).build();
        Map pmmlDocuments = new Maps.Builder().build();
        Mockito.when((Object)definitions.getDrgElement()).thenReturn(Arrays.asList((DRGElement)Mockito.mock(DRGElement.class), (DRGElement)Mockito.mock(DRGElement.class)));
        Mockito.when((Object)definitions.getItemDefinition()).thenReturn(Arrays.asList((ItemDefinition)Mockito.mock(ItemDefinition.class), (ItemDefinition)Mockito.mock(ItemDefinition.class), (ItemDefinition)Mockito.mock(ItemDefinition.class)));
        Mockito.when((Object)this.apiDefinitions.getImport()).thenReturn(Collections.singletonList(anImport));
        org.kie.workbench.common.dmn.api.definition.v1_1.Definitions wb = DefinitionsConverter.wbFromDMN((Definitions)this.apiDefinitions, (Map)importDefinitions, (Map)pmmlDocuments);
        String defaultNs = (String)wb.getNsContext().get(DMNModelInstrumentedBase.Namespace.DEFAULT.getPrefix());
        String namespace = wb.getNamespace().getValue();
        List imports = wb.getImport();
        Assert.assertEquals((Object)defaultNs, (Object)namespace);
        Assert.assertEquals((long)1L, (long)imports.size());
        Assert.assertTrue((boolean)(imports.get(0) instanceof ImportDMN));
        ImportDMN importDMN = (ImportDMN)imports.get(0);
        Assert.assertEquals((long)2L, (long)importDMN.getDrgElementsCount());
        Assert.assertEquals((long)3L, (long)importDMN.getItemDefinitionsCount());
    }

    @Test
    public void dmnFromWB() {
        Mockito.when((Object)this.wbDefinitions.getNamespace()).thenReturn((Object)new Text());
        Definitions dmn = DefinitionsConverter.dmnFromWB((org.kie.workbench.common.dmn.api.definition.v1_1.Definitions)this.wbDefinitions);
        String defaultNs = (String)dmn.getNsContext().get(DMNModelInstrumentedBase.Namespace.DEFAULT.getPrefix());
        String namespace = dmn.getNamespace();
        Assert.assertNotNull((Object)defaultNs);
        Assert.assertEquals((Object)defaultNs, (Object)namespace);
        Mockito.when((Object)this.wbDefinitions.getNamespace()).thenReturn((Object)new Text("SomePreviousSetNamespace"));
        dmn = DefinitionsConverter.dmnFromWB((org.kie.workbench.common.dmn.api.definition.v1_1.Definitions)this.wbDefinitions);
        defaultNs = (String)dmn.getNsContext().get(DMNModelInstrumentedBase.Namespace.DEFAULT.getPrefix());
        namespace = dmn.getNamespace();
        Assert.assertNotNull((Object)defaultNs);
        Assert.assertEquals((Object)defaultNs, (Object)namespace);
        Assert.assertEquals((Object)"SomePreviousSetNamespace", (Object)defaultNs);
    }

    @Test
    public void testDmnFromWBWithExistingDefaultNamespace() {
        HashMap<String, String> existingNsContext = new HashMap<String, String>();
        String existing = "existing";
        existingNsContext.put(DMNModelInstrumentedBase.Namespace.DEFAULT.getPrefix(), "existing");
        Mockito.when((Object)this.wbDefinitions.getNamespace()).thenReturn((Object)new Text());
        Mockito.when((Object)this.wbDefinitions.getNsContext()).thenReturn(existingNsContext);
        Definitions dmn = DefinitionsConverter.dmnFromWB((org.kie.workbench.common.dmn.api.definition.v1_1.Definitions)this.wbDefinitions);
        String defaultNs = (String)dmn.getNsContext().get(DMNModelInstrumentedBase.Namespace.DEFAULT.getPrefix());
        Assert.assertNotNull((Object)defaultNs);
        Assert.assertEquals((Object)"existing", (Object)defaultNs);
        Mockito.when((Object)this.wbDefinitions.getNamespace()).thenReturn((Object)new Text("SomePreviousSetNamespace"));
        dmn = DefinitionsConverter.dmnFromWB((org.kie.workbench.common.dmn.api.definition.v1_1.Definitions)this.wbDefinitions);
        defaultNs = (String)dmn.getNsContext().get(DMNModelInstrumentedBase.Namespace.DEFAULT.getPrefix());
        Assert.assertNotNull((Object)defaultNs);
        Assert.assertEquals((Object)"existing", (Object)defaultNs);
    }
}

