/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.model.api.Expression;
import org.kie.dmn.model.api.Invocation;
import org.kie.dmn.model.v1_2.TInvocation;
import org.kie.dmn.model.v1_2.TLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.backend.definition.v1_1.InvocationPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.ComponentWidths;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class InvocationPropertyConverterTest {
    private static final String INVOCATION_UUID = "i-uuid";
    private static final String INVOCATION_DESCRIPTION = "i-description";
    private static final String INVOCATION_QNAME_LOCALPART = "i-local";
    private static final String EXPRESSION_UUID = "uuid";
    @Mock
    private BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer;
    @Mock
    private Consumer<ComponentWidths> componentWidthsConsumer;
    @Captor
    private ArgumentCaptor<HasComponentWidths> hasComponentWidthsCaptor;
    @Captor
    private ArgumentCaptor<ComponentWidths> componentWidthsCaptor;

    @Test
    public void testWBFromDMN() {
        TInvocation dmn = new TInvocation();
        TLiteralExpression literalExpression = new TLiteralExpression();
        literalExpression.setId(EXPRESSION_UUID);
        dmn.setId(INVOCATION_UUID);
        dmn.setDescription(INVOCATION_DESCRIPTION);
        dmn.setTypeRef(new javax.xml.namespace.QName(INVOCATION_QNAME_LOCALPART));
        dmn.setExpression((Expression)literalExpression);
        org.kie.workbench.common.dmn.api.definition.v1_1.Invocation wb = InvocationPropertyConverter.wbFromDMN((Invocation)dmn, this.hasComponentWidthsConsumer);
        Assertions.assertThat((Object)wb).isNotNull();
        Assertions.assertThat((Object)wb.getId()).isNotNull();
        Assertions.assertThat((String)wb.getId().getValue()).isEqualTo((Object)INVOCATION_UUID);
        Assertions.assertThat((Object)wb.getDescription()).isNotNull();
        Assertions.assertThat((String)wb.getDescription().getValue()).isEqualTo((Object)INVOCATION_DESCRIPTION);
        Assertions.assertThat((Object)wb.getTypeRef()).isNotNull();
        Assertions.assertThat((String)wb.getTypeRef().getLocalPart()).isEqualTo((Object)INVOCATION_QNAME_LOCALPART);
        Assertions.assertThat((Object)wb.getExpression()).isNotNull();
        Assertions.assertThat((String)wb.getExpression().getId().getValue()).isEqualTo((Object)EXPRESSION_UUID);
        ((BiConsumer)Mockito.verify(this.hasComponentWidthsConsumer)).accept(Matchers.eq((Object)EXPRESSION_UUID), this.hasComponentWidthsCaptor.capture());
        HasComponentWidths hasComponentWidths = (HasComponentWidths)this.hasComponentWidthsCaptor.getValue();
        Assertions.assertThat((Object)hasComponentWidths).isNotNull();
        Assertions.assertThat((Object)hasComponentWidths).isEqualTo((Object)wb.getExpression());
    }

    @Test
    public void testDMNFromWB() {
        org.kie.workbench.common.dmn.api.definition.v1_1.Invocation wb = new org.kie.workbench.common.dmn.api.definition.v1_1.Invocation();
        LiteralExpression literalExpression = new LiteralExpression();
        literalExpression.getComponentWidths().set(0, 200.0);
        literalExpression.getId().setValue(EXPRESSION_UUID);
        wb.getId().setValue(INVOCATION_UUID);
        wb.getDescription().setValue(INVOCATION_DESCRIPTION);
        wb.setTypeRef(new QName("", INVOCATION_QNAME_LOCALPART));
        wb.setExpression((org.kie.workbench.common.dmn.api.definition.v1_1.Expression)literalExpression);
        Invocation dmn = InvocationPropertyConverter.dmnFromWB((org.kie.workbench.common.dmn.api.definition.v1_1.Invocation)wb, this.componentWidthsConsumer);
        Assertions.assertThat((Object)dmn).isNotNull();
        Assertions.assertThat((String)dmn.getId()).isNotNull();
        Assertions.assertThat((String)dmn.getId()).isEqualTo((Object)INVOCATION_UUID);
        Assertions.assertThat((String)dmn.getDescription()).isNotNull();
        Assertions.assertThat((String)dmn.getDescription()).isEqualTo((Object)INVOCATION_DESCRIPTION);
        Assertions.assertThat((Object)dmn.getTypeRef()).isNotNull();
        Assertions.assertThat((String)dmn.getTypeRef().getLocalPart()).isEqualTo((Object)INVOCATION_QNAME_LOCALPART);
        Assertions.assertThat((Object)dmn.getExpression()).isNotNull();
        Assertions.assertThat((String)dmn.getExpression().getId()).isEqualTo((Object)EXPRESSION_UUID);
        ((Consumer)Mockito.verify(this.componentWidthsConsumer)).accept(this.componentWidthsCaptor.capture());
        ComponentWidths componentWidths = (ComponentWidths)this.componentWidthsCaptor.getValue();
        Assertions.assertThat((Object)componentWidths).isNotNull();
        Assertions.assertThat((String)componentWidths.getDmnElementRef().getLocalPart()).isEqualTo((Object)EXPRESSION_UUID);
        Assertions.assertThat((int)componentWidths.getWidths().size()).isEqualTo(literalExpression.getRequiredComponentWidthCount());
        Assertions.assertThat((Double)((Double)componentWidths.getWidths().get(0))).isEqualTo(200.0);
    }
}

