/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.included;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.model.api.ItemDefinition;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedNode;
import org.kie.workbench.common.dmn.api.editors.included.IncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.editors.included.PMMLIncludedModel;
import org.kie.workbench.common.dmn.backend.common.DMNMarshallerImportsHelper;
import org.kie.workbench.common.dmn.backend.common.DMNPathsHelper;
import org.kie.workbench.common.dmn.backend.editors.common.DMNIncludedNodesFilter;
import org.kie.workbench.common.dmn.backend.editors.common.IncludedModelFactory;
import org.kie.workbench.common.dmn.backend.editors.common.PMMLIncludedDocumentsFilter;
import org.kie.workbench.common.dmn.backend.editors.included.DMNIncludedModelsServiceImpl;
import org.kie.workbench.common.dmn.backend.editors.types.exceptions.DMNIncludeModelCouldNotBeCreatedException;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNIncludedModelsServiceImplTest {
    @Mock
    private DMNPathsHelper pathsHelper;
    @Mock
    private IncludedModelFactory includedModelFactory;
    @Mock
    private DMNIncludedNodesFilter includedNodesFilter;
    @Mock
    private PMMLIncludedDocumentsFilter includedDocumentsFilter;
    @Mock
    private DMNMarshallerImportsHelper importsHelper;
    @Mock
    private Path dmnModelPath;
    private DMNIncludedModelsServiceImpl service;

    @Before
    public void setup() {
        this.service = (DMNIncludedModelsServiceImpl)Mockito.spy((Object)new DMNIncludedModelsServiceImpl(this.pathsHelper, this.includedModelFactory, this.includedNodesFilter, this.includedDocumentsFilter, this.importsHelper));
    }

    @Test
    public void testLoadModelsWhenWorkspaceProjectIsNull() throws Exception {
        WorkspaceProject workspaceProject = null;
        Path path1 = (Path)Mockito.mock(Path.class);
        Path path2 = (Path)Mockito.mock(Path.class);
        Path path3 = (Path)Mockito.mock(Path.class);
        IncludedModel includedModel1 = (IncludedModel)Mockito.mock(IncludedModel.class);
        IncludedModel includedModel2 = (IncludedModel)Mockito.mock(IncludedModel.class);
        Mockito.when((Object)this.pathsHelper.getModelsPaths(workspaceProject)).thenReturn(Arrays.asList(path1, path2, path3));
        Mockito.when((Object)this.includedModelFactory.create(this.dmnModelPath, path1)).thenReturn((Object)includedModel1);
        Mockito.when((Object)this.includedModelFactory.create(this.dmnModelPath, path2)).thenReturn((Object)includedModel2);
        Mockito.when((Object)this.includedModelFactory.create(this.dmnModelPath, path3)).thenThrow(new Throwable[]{new DMNIncludeModelCouldNotBeCreatedException()});
        List includedModels = this.service.loadModels(this.dmnModelPath, workspaceProject);
        Assert.assertEquals((long)2L, (long)includedModels.size());
        Assert.assertEquals((Object)includedModel1, includedModels.get(0));
        Assert.assertEquals((Object)includedModel2, includedModels.get(1));
    }

    @Test
    public void testLoadModelsWhenWorkspaceProjectIsNotNull() throws Exception {
        WorkspaceProject workspaceProject = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        Path rootPath = (Path)Mockito.mock(Path.class);
        String uri = "/src/path/file.dmn";
        Path path1 = (Path)Mockito.mock(Path.class);
        Path path2 = (Path)Mockito.mock(Path.class);
        Path path3 = (Path)Mockito.mock(Path.class);
        IncludedModel includedModel1 = (IncludedModel)Mockito.mock(IncludedModel.class);
        IncludedModel includedModel2 = (IncludedModel)Mockito.mock(IncludedModel.class);
        Mockito.when((Object)workspaceProject.getRootPath()).thenReturn((Object)rootPath);
        Mockito.when((Object)rootPath.toURI()).thenReturn((Object)"/src/path/file.dmn");
        Mockito.when((Object)this.pathsHelper.getModelsPaths(workspaceProject)).thenReturn(Arrays.asList(path1, path2, path3));
        Mockito.when((Object)this.includedModelFactory.create(this.dmnModelPath, path1)).thenReturn((Object)includedModel1);
        Mockito.when((Object)this.includedModelFactory.create(this.dmnModelPath, path2)).thenReturn((Object)includedModel2);
        Mockito.when((Object)this.includedModelFactory.create(this.dmnModelPath, path3)).thenThrow(new Throwable[]{new DMNIncludeModelCouldNotBeCreatedException()});
        List includedModels = this.service.loadModels(this.dmnModelPath, workspaceProject);
        Assert.assertEquals((long)2L, (long)includedModels.size());
        Assert.assertEquals((Object)includedModel1, includedModels.get(0));
        Assert.assertEquals((Object)includedModel2, includedModels.get(1));
    }

    @Test
    public void testLoadNodesFromImports() {
        WorkspaceProject workspaceProject = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        DMNIncludedModel includedModel1 = (DMNIncludedModel)Mockito.mock(DMNIncludedModel.class);
        DMNIncludedModel includedModel2 = (DMNIncludedModel)Mockito.mock(DMNIncludedModel.class);
        DMNIncludedModel includedModel3 = (DMNIncludedModel)Mockito.mock(DMNIncludedModel.class);
        Path path1 = (Path)Mockito.mock(Path.class);
        Path path2 = (Path)Mockito.mock(Path.class);
        Path path3 = (Path)Mockito.mock(Path.class);
        DMNIncludedNode node1 = (DMNIncludedNode)Mockito.mock(DMNIncludedNode.class);
        DMNIncludedNode node2 = (DMNIncludedNode)Mockito.mock(DMNIncludedNode.class);
        DMNIncludedNode node3 = (DMNIncludedNode)Mockito.mock(DMNIncludedNode.class);
        DMNIncludedNode node4 = (DMNIncludedNode)Mockito.mock(DMNIncludedNode.class);
        DMNIncludedNode node5 = (DMNIncludedNode)Mockito.mock(DMNIncludedNode.class);
        DMNIncludedNode node6 = (DMNIncludedNode)Mockito.mock(DMNIncludedNode.class);
        DMNIncludedNode node7 = (DMNIncludedNode)Mockito.mock(DMNIncludedNode.class);
        List<DMNIncludedNode> path1Nodes = Arrays.asList(node1, node2, node3, node4);
        List<DMNIncludedNode> path2Nodes = Collections.singletonList(node5);
        List<DMNIncludedNode> path3Nodes = Arrays.asList(node6, node7);
        List<DMNIncludedModel> includedModels = Arrays.asList(includedModel1, includedModel2, includedModel3);
        List<Path> paths = Arrays.asList(path1, path2, path3);
        Mockito.when((Object)this.pathsHelper.getDMNModelsPaths(workspaceProject)).thenReturn(paths);
        Mockito.when((Object)this.includedNodesFilter.getNodesFromImports(path1, includedModels)).thenReturn(path1Nodes);
        Mockito.when((Object)this.includedNodesFilter.getNodesFromImports(path2, includedModels)).thenReturn(path2Nodes);
        Mockito.when((Object)this.includedNodesFilter.getNodesFromImports(path3, includedModels)).thenReturn(path3Nodes);
        List actualNodes = this.service.loadNodesFromImports(workspaceProject, includedModels);
        List<DMNIncludedNode> expectedNodes = Arrays.asList(node1, node2, node3, node4, node5, node6, node7);
        Assert.assertEquals(expectedNodes, (Object)actualNodes);
    }

    @Test
    public void testLoadPMMLDocumentsFromImports() {
        WorkspaceProject workspaceProject = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        PMMLIncludedModel includedModel1 = (PMMLIncludedModel)Mockito.mock(PMMLIncludedModel.class);
        PMMLIncludedModel includedModel2 = (PMMLIncludedModel)Mockito.mock(PMMLIncludedModel.class);
        PMMLIncludedModel includedModel3 = (PMMLIncludedModel)Mockito.mock(PMMLIncludedModel.class);
        Path path1 = (Path)Mockito.mock(Path.class);
        Path path2 = (Path)Mockito.mock(Path.class);
        Path path3 = (Path)Mockito.mock(Path.class);
        PMMLDocumentMetadata pmmlDocument1 = (PMMLDocumentMetadata)Mockito.mock(PMMLDocumentMetadata.class);
        PMMLDocumentMetadata pmmlDocument2 = (PMMLDocumentMetadata)Mockito.mock(PMMLDocumentMetadata.class);
        PMMLDocumentMetadata pmmlDocument3 = (PMMLDocumentMetadata)Mockito.mock(PMMLDocumentMetadata.class);
        List<PMMLIncludedModel> includedModels = Arrays.asList(includedModel1, includedModel2, includedModel3);
        List<Path> paths = Arrays.asList(path1, path2, path3);
        Mockito.when((Object)this.pathsHelper.getPMMLModelsPaths(workspaceProject)).thenReturn(paths);
        Mockito.when((Object)this.includedDocumentsFilter.getDocumentFromImports(this.dmnModelPath, path1, includedModels)).thenReturn((Object)pmmlDocument1);
        Mockito.when((Object)this.includedDocumentsFilter.getDocumentFromImports(this.dmnModelPath, path2, includedModels)).thenReturn((Object)pmmlDocument2);
        Mockito.when((Object)this.includedDocumentsFilter.getDocumentFromImports(this.dmnModelPath, path3, includedModels)).thenReturn((Object)pmmlDocument3);
        List actualPMMLDocuments = this.service.loadPMMLDocumentsFromImports(this.dmnModelPath, workspaceProject, includedModels);
        List<PMMLDocumentMetadata> expectedPMMLDocuments = Arrays.asList(pmmlDocument1, pmmlDocument2, pmmlDocument3);
        Assert.assertEquals(expectedPMMLDocuments, (Object)actualPMMLDocuments);
    }

    @Test
    public void testLoadItemDefinitionsByNamespace() {
        WorkspaceProject workspaceProject = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        String modelName = "model1";
        String namespace = "://namespace";
        ItemDefinition itemDefinition1 = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ItemDefinition itemDefinition2 = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ItemDefinition itemDefinition3 = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition wbItemDefinition1 = (org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition)Mockito.mock(org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition.class);
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition wbItemDefinition2 = (org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition)Mockito.mock(org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition.class);
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition wbItemDefinition3 = (org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition)Mockito.mock(org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition.class);
        List<ItemDefinition> itemDefinitions = Arrays.asList(itemDefinition1, itemDefinition2, itemDefinition3);
        ((DMNIncludedModelsServiceImpl)Mockito.doReturn((Object)wbItemDefinition1).when((Object)this.service)).wbFromDMN(itemDefinition1, "model1");
        ((DMNIncludedModelsServiceImpl)Mockito.doReturn((Object)wbItemDefinition2).when((Object)this.service)).wbFromDMN(itemDefinition2, "model1");
        ((DMNIncludedModelsServiceImpl)Mockito.doReturn((Object)wbItemDefinition3).when((Object)this.service)).wbFromDMN(itemDefinition3, "model1");
        Mockito.when((Object)this.importsHelper.getImportedItemDefinitionsByNamespace(workspaceProject, "model1", "://namespace")).thenReturn(itemDefinitions);
        List actualItemDefinitions = this.service.loadItemDefinitionsByNamespace(workspaceProject, "model1", "://namespace");
        List<org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition> expectedItemDefinitions = Arrays.asList(wbItemDefinition1, wbItemDefinition2, wbItemDefinition3);
        Assert.assertEquals(expectedItemDefinitions, (Object)actualItemDefinitions);
    }
}

