/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.xml.namespace.QName;
import org.kie.dmn.model.api.DMNElementReference;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.FunctionDefinition;
import org.kie.dmn.model.api.InformationItem;
import org.kie.dmn.model.v1_2.TAuthorityRequirement;
import org.kie.dmn.model.v1_2.TBusinessKnowledgeModel;
import org.kie.dmn.model.v1_2.TDMNElementReference;
import org.kie.dmn.model.v1_2.TInformationItem;
import org.kie.dmn.model.v1_2.TKnowledgeRequirement;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.v1_1.DRGElement;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionService;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeRequirement;
import org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource;
import org.kie.workbench.common.dmn.api.property.background.BackgroundSet;
import org.kie.workbench.common.dmn.api.property.dimensions.GeneralRectangleDimensionsSet;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.font.FontSet;
import org.kie.workbench.common.dmn.backend.definition.v1_1.DMNExternalLinksToExtensionElements;
import org.kie.workbench.common.dmn.backend.definition.v1_1.DescriptionPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.FunctionDefinitionPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.HrefBuilder;
import org.kie.workbench.common.dmn.backend.definition.v1_1.InformationItemPrimaryPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.NodeConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.ComponentWidths;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class BusinessKnowledgeModelConverter
implements NodeConverter<org.kie.dmn.model.api.BusinessKnowledgeModel, BusinessKnowledgeModel> {
    private FactoryManager factoryManager;

    public BusinessKnowledgeModelConverter(FactoryManager factoryManager) {
        this.factoryManager = factoryManager;
    }

    @Override
    public Node<View<BusinessKnowledgeModel>, ?> nodeFromDMN(org.kie.dmn.model.api.BusinessKnowledgeModel dmn, BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer) {
        Node node = this.factoryManager.newElement(dmn.getId(), BindableAdapterUtils.getDefinitionId(BusinessKnowledgeModel.class)).asNode();
        Id id = new Id(dmn.getId());
        Description description = DescriptionPropertyConverter.wbFromDMN(dmn.getDescription());
        Name name = new Name(dmn.getName());
        InformationItemPrimary informationItem = InformationItemPrimaryPropertyConverter.wbFromDMN(dmn.getVariable(), (DMNModelInstrumentedBase)dmn);
        FunctionDefinition dmnFunctionDefinition = dmn.getEncapsulatedLogic();
        org.kie.workbench.common.dmn.api.definition.v1_1.FunctionDefinition functionDefinition = FunctionDefinitionPropertyConverter.wbFromDMN(dmnFunctionDefinition, hasComponentWidthsConsumer);
        BusinessKnowledgeModel bkm = new BusinessKnowledgeModel(id, description, name, informationItem, functionDefinition, new BackgroundSet(), new FontSet(), new GeneralRectangleDimensionsSet());
        ((View)node.getContent()).setDefinition((Object)bkm);
        if (informationItem != null) {
            informationItem.setParent((org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase)bkm);
        }
        if (functionDefinition != null) {
            functionDefinition.setParent((org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase)bkm);
        }
        if (Objects.nonNull(dmnFunctionDefinition)) {
            hasComponentWidthsConsumer.accept(dmnFunctionDefinition.getId(), (HasComponentWidths)functionDefinition);
        }
        DMNExternalLinksToExtensionElements.loadExternalLinksFromExtensionElements((org.kie.dmn.model.api.DRGElement)dmn, (DRGElement)bkm);
        return node;
    }

    @Override
    public org.kie.dmn.model.api.BusinessKnowledgeModel dmnFromNode(Node<View<BusinessKnowledgeModel>, ?> node, Consumer<ComponentWidths> componentWidthsConsumer) {
        String uuid;
        BusinessKnowledgeModel source = (BusinessKnowledgeModel)((View)node.getContent()).getDefinition();
        TBusinessKnowledgeModel result = new TBusinessKnowledgeModel();
        result.setId(source.getId().getValue());
        result.setDescription(DescriptionPropertyConverter.dmnFromWB(source.getDescription()));
        result.setName(source.getName().getValue());
        DMNExternalLinksToExtensionElements.loadExternalLinksIntoExtensionElements((DRGElement)source, (org.kie.dmn.model.api.DRGElement)result);
        TInformationItem variable = InformationItemPrimaryPropertyConverter.dmnFromWB(source.getVariable(), (org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase)source);
        if (variable != null) {
            variable.setParent((DMNModelInstrumentedBase)result);
        }
        result.setVariable((InformationItem)variable);
        FunctionDefinition functionDefinition = FunctionDefinitionPropertyConverter.dmnFromWB(source.getEncapsulatedLogic(), componentWidthsConsumer);
        org.kie.workbench.common.dmn.api.definition.v1_1.FunctionDefinition wbFunctionDefinition = source.getEncapsulatedLogic();
        if (Objects.nonNull(wbFunctionDefinition) && Objects.nonNull(uuid = wbFunctionDefinition.getId().getValue())) {
            ComponentWidths componentWidths = new ComponentWidths();
            componentWidths.setDmnElementRef(new QName(uuid));
            componentWidths.setWidths(new ArrayList<Double>(source.getEncapsulatedLogic().getComponentWidths()));
            componentWidthsConsumer.accept(componentWidths);
        }
        if (functionDefinition != null) {
            functionDefinition.setParent((DMNModelInstrumentedBase)result);
        }
        result.setEncapsulatedLogic(functionDefinition);
        List inEdges = node.getInEdges();
        for (Edge e : inEdges) {
            TDMNElementReference ri;
            TKnowledgeRequirement iReq;
            View view;
            Node sourceNode = e.getSourceNode();
            if (!(sourceNode.getContent() instanceof View) || !((view = (View)sourceNode.getContent()).getDefinition() instanceof DRGElement)) continue;
            DRGElement drgElement = (DRGElement)view.getDefinition();
            if (drgElement instanceof BusinessKnowledgeModel) {
                iReq = new TKnowledgeRequirement();
                iReq.setId(e.getUUID());
                ri = new TDMNElementReference();
                ri.setHref(HrefBuilder.getHref(drgElement));
                iReq.setRequiredKnowledge((DMNElementReference)ri);
                result.getKnowledgeRequirement().add(iReq);
                continue;
            }
            if (drgElement instanceof KnowledgeSource) {
                iReq = new TAuthorityRequirement();
                iReq.setId(e.getUUID());
                ri = new TDMNElementReference();
                ri.setHref(HrefBuilder.getHref(drgElement));
                iReq.setRequiredAuthority((DMNElementReference)ri);
                result.getAuthorityRequirement().add(iReq);
                continue;
            }
            if (drgElement instanceof DecisionService) {
                if (e.getContent() instanceof View && ((View)e.getContent()).getDefinition() instanceof KnowledgeRequirement) {
                    iReq = new TKnowledgeRequirement();
                    iReq.setId(e.getUUID());
                    ri = new TDMNElementReference();
                    ri.setHref(HrefBuilder.getHref(drgElement));
                    iReq.setRequiredKnowledge((DMNElementReference)ri);
                    result.getKnowledgeRequirement().add(iReq);
                    continue;
                }
                throw new UnsupportedOperationException("wrong model definition.");
            }
            throw new UnsupportedOperationException("wrong model definition.");
        }
        return result;
    }
}

