/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.List;
import javax.xml.namespace.QName;
import org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition;
import org.kie.workbench.common.dmn.api.editors.types.BuiltInTypeUtils;
import org.kie.workbench.common.dmn.backend.definition.v1_1.ItemDefinitionPropertyConverter;

public class ImportedItemDefinitionConverter {
    public static ItemDefinition wbFromDMN(org.kie.dmn.model.api.ItemDefinition dmnItemDefinition, String prefix) {
        org.kie.dmn.model.api.ItemDefinition dmnItemDefinitionWithNamespace = ImportedItemDefinitionConverter.withNamespace(dmnItemDefinition, prefix);
        ItemDefinition wbItemDefinition = ItemDefinitionPropertyConverter.wbFromDMN(dmnItemDefinitionWithNamespace);
        ImportedItemDefinitionConverter.allowOnlyVisualChange(wbItemDefinition);
        return wbItemDefinition;
    }

    public static org.kie.dmn.model.api.ItemDefinition withNamespace(org.kie.dmn.model.api.ItemDefinition itemDefinition, String prefix) {
        String nameWithPrefix = prefix + "." + itemDefinition.getName();
        List itemComponents = itemDefinition.getItemComponent();
        if (itemDefinition.getTypeRef() != null && !ImportedItemDefinitionConverter.isBuiltInType(itemDefinition.getTypeRef())) {
            itemDefinition.setTypeRef(ImportedItemDefinitionConverter.makeQNameWithPrefix(itemDefinition.getTypeRef(), prefix));
        }
        itemDefinition.setName(nameWithPrefix);
        ImportedItemDefinitionConverter.setItemDefinitionsNamespace(itemComponents, prefix);
        return itemDefinition;
    }

    private static void allowOnlyVisualChange(ItemDefinition itemDefinition) {
        itemDefinition.setAllowOnlyVisualChange(true);
        itemDefinition.getItemComponent().forEach(ImportedItemDefinitionConverter::allowOnlyVisualChange);
    }

    private static void setItemDefinitionsNamespace(List<org.kie.dmn.model.api.ItemDefinition> itemDefinitions, String prefix) {
        itemDefinitions.forEach(itemDefinition -> ImportedItemDefinitionConverter.withNamespace(itemDefinition, prefix));
    }

    private static boolean isBuiltInType(QName typeRef) {
        return BuiltInTypeUtils.isBuiltInType((String)typeRef.getLocalPart());
    }

    private static QName makeQNameWithPrefix(QName qName, String prefix) {
        String namespaceURI = qName.getNamespaceURI();
        String localPart = prefix + "." + qName.getLocalPart();
        return new QName(namespaceURI, localPart, qName.getPrefix());
    }
}

