/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.common;

import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.v1_1.DRGElement;
import org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition;
import org.kie.workbench.common.dmn.api.graph.DMNDiagramUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.service.DiagramService;
import org.uberfire.backend.vfs.Path;

@Dependent
public class DMNDiagramHelper {
    private final DiagramService diagramService;
    private final DMNDiagramUtils dmnDiagramUtils;

    @Inject
    public DMNDiagramHelper(DiagramService diagramService, DMNDiagramUtils dmnDiagramUtils) {
        this.diagramService = diagramService;
        this.dmnDiagramUtils = dmnDiagramUtils;
    }

    public List<DRGElement> getNodes(Diagram diagram) {
        return this.dmnDiagramUtils.getDRGElements(diagram);
    }

    public List<ItemDefinition> getItemDefinitions(Diagram diagram) {
        return this.dmnDiagramUtils.getDefinitions(diagram).getItemDefinition();
    }

    public String getNamespace(Path path) {
        Diagram<Graph, Metadata> diagram = this.getDiagramByPath(path);
        return this.dmnDiagramUtils.getNamespace(diagram);
    }

    public String getNamespace(Diagram diagram) {
        return this.dmnDiagramUtils.getNamespace(diagram);
    }

    public Diagram<Graph, Metadata> getDiagramByPath(Path path) {
        return this.diagramService.getDiagramByPath(path);
    }
}

