/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.v1_1.DRGElement;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedNode;
import org.kie.workbench.common.dmn.api.editors.included.IncludedModel;
import org.kie.workbench.common.dmn.backend.editors.common.DMNDiagramHelper;
import org.kie.workbench.common.dmn.backend.editors.common.DMNIncludedNodeFactory;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.uberfire.backend.vfs.Path;

@Dependent
public class DMNIncludedNodesFilter {
    private final DMNDiagramHelper diagramHelper;
    private final DMNIncludedNodeFactory factory;

    @Inject
    public DMNIncludedNodesFilter(DMNDiagramHelper diagramHelper, DMNIncludedNodeFactory factory) {
        this.diagramHelper = diagramHelper;
        this.factory = factory;
    }

    public List<DMNIncludedNode> getNodesFromImports(Path path, List<DMNIncludedModel> includedModels) {
        try {
            Diagram<Graph, Metadata> diagram = this.diagramHelper.getDiagramByPath(path);
            Optional<DMNIncludedModel> diagramImport = this.getDiagramImport(diagram, includedModels);
            return diagramImport.map(dmn -> this.diagramHelper.getNodes(diagram).stream().map(node -> this.factory.makeDMNIncludeModel(path, (IncludedModel)dmn, (DRGElement)node)).collect(Collectors.toList())).orElse(new ArrayList());
        }
        catch (Exception exception) {
            return new ArrayList<DMNIncludedNode>();
        }
    }

    private Optional<DMNIncludedModel> getDiagramImport(Diagram<Graph, Metadata> diagram, List<DMNIncludedModel> includedModels) {
        String pathNamespace = this.diagramHelper.getNamespace(diagram);
        return includedModels.stream().filter(i -> Objects.equals(pathNamespace, i.getNamespace())).findAny();
    }
}

