/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.validation;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.api.builder.Message;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.model.api.DMNElement;
import org.kie.dmn.model.api.Import;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.DMNValidatorFactory;
import org.kie.workbench.common.dmn.api.DMNDefinitionSet;
import org.kie.workbench.common.dmn.api.definition.v1_1.Definitions;
import org.kie.workbench.common.dmn.api.graph.DMNDiagramUtils;
import org.kie.workbench.common.dmn.backend.DMNMarshaller;
import org.kie.workbench.common.dmn.backend.common.DMNMarshallerImportsHelper;
import org.kie.workbench.common.dmn.backend.definition.v1_1.ImportConverter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingMessage;
import org.kie.workbench.common.stunner.core.validation.DomainValidator;
import org.kie.workbench.common.stunner.core.validation.DomainViolation;
import org.kie.workbench.common.stunner.core.validation.Violation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DMNDomainValidator
implements DomainValidator {
    static final String DEFAULT_UUID = "uuid";
    private static final Logger LOGGER = LoggerFactory.getLogger(DMNDomainValidator.class);
    private DMNValidator dmnValidator;
    private DMNMarshaller dmnMarshaller;
    private DMNDiagramUtils dmnDiagramUtils;
    private DMNMarshallerImportsHelper importsHelper;

    @Inject
    public DMNDomainValidator(DMNMarshaller dmnMarshaller, DMNDiagramUtils dmnDiagramUtils, DMNMarshallerImportsHelper importsHelper) {
        this.dmnMarshaller = dmnMarshaller;
        this.dmnDiagramUtils = dmnDiagramUtils;
        this.importsHelper = importsHelper;
    }

    @PostConstruct
    public void setupValidator() {
        this.dmnValidator = this.getDMNValidator();
    }

    DMNValidator getDMNValidator() {
        return DMNValidatorFactory.newValidator();
    }

    public String getDefinitionSetId() {
        return BindableAdapterUtils.getDefinitionSetId(DMNDefinitionSet.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(Diagram diagram, Consumer<Collection<DomainViolation>> resultConsumer) {
        ArrayList<StringReader> dmnXMLReaders = new ArrayList<StringReader>();
        try {
            String uiDiagramXML = this.dmnMarshaller.marshall((Diagram<Graph, Metadata>)diagram);
            dmnXMLReaders.add(this.getStringReader(uiDiagramXML));
            Definitions uiDefinitions = this.dmnDiagramUtils.getDefinitions(diagram);
            List uiImports = uiDefinitions.getImport();
            List<Import> dmnImports = uiImports.stream().map(ImportConverter::dmnFromWb).collect(Collectors.toList());
            Map<Import, String> importedDiagramsXML = this.importsHelper.getImportXML(diagram.getMetadata(), dmnImports);
            importedDiagramsXML.values().forEach(importedDiagramXML -> dmnXMLReaders.add(this.getStringReader((String)importedDiagramXML)));
            Reader[] aDMNXMLReaders = new Reader[]{};
            List messages = this.dmnValidator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE}).theseModels(dmnXMLReaders.toArray(aDMNXMLReaders));
            resultConsumer.accept(this.convert(messages));
        }
        catch (IOException ioe) {
            LOGGER.error("Error while converting diagram with UUID [" + diagram.getName() + "] to XML.", (Throwable)ioe);
        }
        finally {
            dmnXMLReaders.forEach(reader -> {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }

    StringReader getStringReader(String xml) {
        return new StringReader(xml);
    }

    private Collection<DomainViolation> convert(List<DMNMessage> messages) {
        return messages.stream().map(this::convert).collect(Collectors.toList());
    }

    private DomainViolation convert(DMNMessage message) {
        return new MarshallingMessage.MarshallingMessageBuilder().elementUUID(this.getDMNElementUUID(message.getSourceReference())).type(this.convert(message.getLevel())).message(message.getText()).build();
    }

    private String getDMNElementUUID(Object source) {
        if (source instanceof DMNElement) {
            DMNElement element = (DMNElement)source;
            if (Objects.isNull(element.getId())) {
                return this.getDMNElementUUID(element.getParent());
            }
            return element.getId();
        }
        return DEFAULT_UUID;
    }

    private Violation.Type convert(Message.Level level) {
        switch (level) {
            case ERROR: {
                return Violation.Type.ERROR;
            }
            case WARNING: {
                return Violation.Type.WARNING;
            }
        }
        return Violation.Type.INFO;
    }
}

