/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.model.api.ContextEntry;
import org.kie.dmn.model.v1_2.TContextEntry;
import org.kie.dmn.model.v1_2.TInformationItem;
import org.kie.dmn.model.v1_2.TLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.backend.definition.v1_1.ContextEntryPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.ComponentWidths;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ContextEntryPropertyConverterTest {
    private static final String EXPRESSION_UUID = "uuid";
    @Mock
    private BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer;
    @Mock
    private Consumer<ComponentWidths> componentWidthsConsumer;
    @Captor
    private ArgumentCaptor<HasComponentWidths> hasComponentWidthsCaptor;
    @Captor
    private ArgumentCaptor<ComponentWidths> componentWidthsCaptor;

    @Test
    public void testWBFromDMN() {
        TContextEntry dmn = new TContextEntry();
        TInformationItem informationItem = new TInformationItem();
        dmn.setVariable((org.kie.dmn.model.api.InformationItem)informationItem);
        TLiteralExpression literalExpression = new TLiteralExpression();
        literalExpression.setId(EXPRESSION_UUID);
        dmn.setExpression((org.kie.dmn.model.api.Expression)literalExpression);
        org.kie.workbench.common.dmn.api.definition.model.ContextEntry wb = ContextEntryPropertyConverter.wbFromDMN((ContextEntry)dmn, this.hasComponentWidthsConsumer);
        Assertions.assertThat((Object)wb).isNotNull();
        Assertions.assertThat((Object)wb.getVariable()).isNotNull();
        Assertions.assertThat((Object)wb.getExpression()).isNotNull();
        Assertions.assertThat((String)wb.getExpression().getId().getValue()).isEqualTo((Object)EXPRESSION_UUID);
        ((BiConsumer)Mockito.verify(this.hasComponentWidthsConsumer)).accept(Matchers.eq((Object)EXPRESSION_UUID), this.hasComponentWidthsCaptor.capture());
        HasComponentWidths hasComponentWidths = (HasComponentWidths)this.hasComponentWidthsCaptor.getValue();
        Assertions.assertThat((Object)hasComponentWidths).isNotNull();
        Assertions.assertThat((Object)hasComponentWidths).isEqualTo((Object)wb.getExpression());
    }

    @Test
    public void testDMNFromWB() {
        org.kie.workbench.common.dmn.api.definition.model.ContextEntry wb = new org.kie.workbench.common.dmn.api.definition.model.ContextEntry();
        InformationItem informationItem = new InformationItem();
        wb.setVariable(informationItem);
        LiteralExpression literalExpression = new LiteralExpression();
        literalExpression.getComponentWidths().set(0, 200.0);
        literalExpression.getId().setValue(EXPRESSION_UUID);
        wb.setExpression((Expression)literalExpression);
        ContextEntry dmn = ContextEntryPropertyConverter.dmnFromWB((org.kie.workbench.common.dmn.api.definition.model.ContextEntry)wb, this.componentWidthsConsumer);
        Assertions.assertThat((Object)dmn).isNotNull();
        Assertions.assertThat((Object)dmn.getVariable()).isNotNull();
        Assertions.assertThat((Object)dmn.getExpression()).isNotNull();
        Assertions.assertThat((String)dmn.getExpression().getId()).isEqualTo((Object)EXPRESSION_UUID);
        ((Consumer)Mockito.verify(this.componentWidthsConsumer)).accept(this.componentWidthsCaptor.capture());
        ComponentWidths componentWidths = (ComponentWidths)this.componentWidthsCaptor.getValue();
        Assertions.assertThat((Object)componentWidths).isNotNull();
        Assertions.assertThat((String)componentWidths.getDmnElementRef().getLocalPart()).isEqualTo((Object)EXPRESSION_UUID);
        Assertions.assertThat((int)componentWidths.getWidths().size()).isEqualTo(literalExpression.getRequiredComponentWidthCount());
        Assertions.assertThat((Double)((Double)componentWidths.getWidths().get(0))).isEqualTo(200.0);
    }
}

