/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.model.api.Context;
import org.kie.dmn.model.api.ContextEntry;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.Decision;
import org.kie.dmn.model.api.FunctionDefinition;
import org.kie.dmn.model.api.FunctionKind;
import org.kie.dmn.model.v1_2.TContext;
import org.kie.dmn.model.v1_2.TContextEntry;
import org.kie.dmn.model.v1_2.TInformationItem;
import org.kie.dmn.model.v1_2.TLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.backend.definition.v1_1.ContextPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.ComponentWidths;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ContextPropertyConverterTest {
    private static final String EXPRESSION_UUID = "uuid";
    private static final String DEFAULT_EXPRESSION_UUID = "default-uuid";
    @Mock
    private BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer;
    @Mock
    private Consumer<ComponentWidths> componentWidthsConsumer;
    @Mock
    private Decision decision;
    @Mock
    private FunctionDefinition functionDefinition;
    @Captor
    private ArgumentCaptor<HasComponentWidths> hasComponentWidthsCaptor;
    @Captor
    private ArgumentCaptor<ComponentWidths> componentWidthsCaptor;
    private LiteralExpression literalExpression;

    @Before
    public void setup() {
        this.literalExpression = new LiteralExpression();
    }

    @Test
    public void testWBFromDMNWithDecisionAsParent() {
        Context dmn = this.setupWBFromDMN((DMNModelInstrumentedBase)this.decision);
        org.kie.workbench.common.dmn.api.definition.model.Context wb = ContextPropertyConverter.wbFromDMN((Context)dmn, this.hasComponentWidthsConsumer);
        this.assertDefaultContextEntry(wb);
    }

    @Test
    public void testWBFromDMNWithJavaFunctionDefinitionAsParent() {
        Mockito.when((Object)this.functionDefinition.getKind()).thenReturn((Object)FunctionKind.JAVA);
        Context dmn = this.setupWBFromDMN((DMNModelInstrumentedBase)this.functionDefinition);
        org.kie.workbench.common.dmn.api.definition.model.Context wb = ContextPropertyConverter.wbFromDMN((Context)dmn, this.hasComponentWidthsConsumer);
        this.assertNoDefaultContextEntry(wb);
    }

    @Test
    public void testWBFromDMNWithPMMLFunctionDefinitionAsParent() {
        Mockito.when((Object)this.functionDefinition.getKind()).thenReturn((Object)FunctionKind.PMML);
        Context dmn = this.setupWBFromDMN((DMNModelInstrumentedBase)this.functionDefinition);
        org.kie.workbench.common.dmn.api.definition.model.Context wb = ContextPropertyConverter.wbFromDMN((Context)dmn, this.hasComponentWidthsConsumer);
        this.assertNoDefaultContextEntry(wb);
    }

    @Test
    public void testWBFromDMNWithFEELFunctionDefinitionAsParent() {
        Mockito.when((Object)this.functionDefinition.getKind()).thenReturn((Object)FunctionKind.FEEL);
        Context dmn = this.setupWBFromDMN((DMNModelInstrumentedBase)this.functionDefinition);
        org.kie.workbench.common.dmn.api.definition.model.Context wb = ContextPropertyConverter.wbFromDMN((Context)dmn, this.hasComponentWidthsConsumer);
        this.assertDefaultContextEntry(wb);
    }

    private void assertDefaultContextEntry(org.kie.workbench.common.dmn.api.definition.model.Context wb) {
        Assertions.assertThat((Object)wb).isNotNull();
        Assertions.assertThat((List)wb.getContextEntry()).isNotNull();
        Assertions.assertThat((int)wb.getContextEntry().size()).isEqualTo(2);
        Assertions.assertThat(wb.getContextEntry().get(0)).isNotNull();
        Assertions.assertThat((Object)((org.kie.workbench.common.dmn.api.definition.model.ContextEntry)wb.getContextEntry().get(0)).getExpression()).isInstanceOf(LiteralExpression.class);
        Assertions.assertThat((String)((org.kie.workbench.common.dmn.api.definition.model.ContextEntry)wb.getContextEntry().get(0)).getExpression().getId().getValue()).isEqualTo((Object)EXPRESSION_UUID);
        Assertions.assertThat(wb.getContextEntry().get(1)).isNotNull();
        Assertions.assertThat((Object)((org.kie.workbench.common.dmn.api.definition.model.ContextEntry)wb.getContextEntry().get(1)).getExpression()).isNull();
        ((BiConsumer)Mockito.verify(this.hasComponentWidthsConsumer)).accept(Matchers.eq((Object)EXPRESSION_UUID), this.hasComponentWidthsCaptor.capture());
        HasComponentWidths hasComponentWidths = (HasComponentWidths)this.hasComponentWidthsCaptor.getValue();
        Assertions.assertThat((Object)hasComponentWidths).isNotNull();
        Assertions.assertThat((Object)hasComponentWidths).isEqualTo((Object)((org.kie.workbench.common.dmn.api.definition.model.ContextEntry)wb.getContextEntry().get(0)).getExpression());
    }

    private void assertNoDefaultContextEntry(org.kie.workbench.common.dmn.api.definition.model.Context wb) {
        Assertions.assertThat((Object)wb).isNotNull();
        Assertions.assertThat((List)wb.getContextEntry()).isNotNull();
        Assertions.assertThat((int)wb.getContextEntry().size()).isEqualTo(1);
        Assertions.assertThat(wb.getContextEntry().get(0)).isNotNull();
        Assertions.assertThat((Object)((org.kie.workbench.common.dmn.api.definition.model.ContextEntry)wb.getContextEntry().get(0)).getExpression()).isInstanceOf(LiteralExpression.class);
        Assertions.assertThat((String)((org.kie.workbench.common.dmn.api.definition.model.ContextEntry)wb.getContextEntry().get(0)).getExpression().getId().getValue()).isEqualTo((Object)EXPRESSION_UUID);
        ((BiConsumer)Mockito.verify(this.hasComponentWidthsConsumer)).accept(Matchers.eq((Object)EXPRESSION_UUID), this.hasComponentWidthsCaptor.capture());
        HasComponentWidths hasComponentWidths = (HasComponentWidths)this.hasComponentWidthsCaptor.getValue();
        Assertions.assertThat((Object)hasComponentWidths).isNotNull();
        Assertions.assertThat((Object)hasComponentWidths).isEqualTo((Object)((org.kie.workbench.common.dmn.api.definition.model.ContextEntry)wb.getContextEntry().get(0)).getExpression());
    }

    private Context setupWBFromDMN(DMNModelInstrumentedBase parent) {
        TContext dmn = new TContext();
        TContextEntry contextEntry = new TContextEntry();
        TInformationItem informationItem = new TInformationItem();
        TLiteralExpression literalExpression = new TLiteralExpression();
        literalExpression.setId(EXPRESSION_UUID);
        contextEntry.setExpression((org.kie.dmn.model.api.Expression)literalExpression);
        contextEntry.setVariable((org.kie.dmn.model.api.InformationItem)informationItem);
        dmn.getContextEntry().add(contextEntry);
        dmn.setParent(parent);
        return dmn;
    }

    @Test
    public void testDMNFromWBWithNoDefault() {
        org.kie.workbench.common.dmn.api.definition.model.Context wb = this.setupDMNFromWB(Optional.empty());
        Context dmn = ContextPropertyConverter.dmnFromWB((org.kie.workbench.common.dmn.api.definition.model.Context)wb, this.componentWidthsConsumer);
        Assertions.assertThat((Object)dmn).isNotNull();
        Assertions.assertThat((List)dmn.getContextEntry()).isNotNull();
        Assertions.assertThat((int)dmn.getContextEntry().size()).isEqualTo(1);
        Assertions.assertThat(dmn.getContextEntry().get(0)).isNotNull();
        Assertions.assertThat((String)((ContextEntry)dmn.getContextEntry().get(0)).getExpression().getId()).isEqualTo((Object)EXPRESSION_UUID);
        ((Consumer)Mockito.verify(this.componentWidthsConsumer)).accept(this.componentWidthsCaptor.capture());
        ComponentWidths componentWidths = (ComponentWidths)this.componentWidthsCaptor.getValue();
        Assertions.assertThat((Object)componentWidths).isNotNull();
        Assertions.assertThat((String)componentWidths.getDmnElementRef().getLocalPart()).isEqualTo((Object)EXPRESSION_UUID);
        Assertions.assertThat((int)componentWidths.getWidths().size()).isEqualTo(this.literalExpression.getRequiredComponentWidthCount());
        Assertions.assertThat((Double)((Double)componentWidths.getWidths().get(0))).isEqualTo(200.0);
    }

    @Test
    public void testDMNFromWBWithDefault() {
        LiteralExpression defaultExpression = new LiteralExpression();
        defaultExpression.getId().setValue(DEFAULT_EXPRESSION_UUID);
        defaultExpression.getComponentWidths().set(0, 100.0);
        org.kie.workbench.common.dmn.api.definition.model.Context wb = this.setupDMNFromWB(Optional.of(defaultExpression));
        Context dmn = ContextPropertyConverter.dmnFromWB((org.kie.workbench.common.dmn.api.definition.model.Context)wb, this.componentWidthsConsumer);
        Assertions.assertThat((Object)dmn).isNotNull();
        Assertions.assertThat((List)dmn.getContextEntry()).isNotNull();
        Assertions.assertThat((int)dmn.getContextEntry().size()).isEqualTo(2);
        Assertions.assertThat(dmn.getContextEntry().get(0)).isNotNull();
        Assertions.assertThat((String)((ContextEntry)dmn.getContextEntry().get(0)).getExpression().getId()).isEqualTo((Object)EXPRESSION_UUID);
        Assertions.assertThat(dmn.getContextEntry().get(1)).isNotNull();
        Assertions.assertThat((String)((ContextEntry)dmn.getContextEntry().get(1)).getExpression().getId()).isEqualTo((Object)DEFAULT_EXPRESSION_UUID);
        ((Consumer)Mockito.verify(this.componentWidthsConsumer, (VerificationMode)Mockito.times((int)2))).accept(this.componentWidthsCaptor.capture());
        List componentWidths = this.componentWidthsCaptor.getAllValues();
        Assertions.assertThat((List)componentWidths).isNotNull();
        Assertions.assertThat((int)componentWidths.size()).isEqualTo(2);
        Assertions.assertThat((String)((ComponentWidths)componentWidths.get(0)).getDmnElementRef().getLocalPart()).isEqualTo((Object)EXPRESSION_UUID);
        Assertions.assertThat((int)((ComponentWidths)componentWidths.get(0)).getWidths().size()).isEqualTo(this.literalExpression.getRequiredComponentWidthCount());
        Assertions.assertThat((Double)((Double)((ComponentWidths)componentWidths.get(0)).getWidths().get(0))).isEqualTo(200.0);
        Assertions.assertThat((String)((ComponentWidths)componentWidths.get(1)).getDmnElementRef().getLocalPart()).isEqualTo((Object)DEFAULT_EXPRESSION_UUID);
        Assertions.assertThat((int)((ComponentWidths)componentWidths.get(1)).getWidths().size()).isEqualTo(defaultExpression.getRequiredComponentWidthCount());
        Assertions.assertThat((Double)((Double)((ComponentWidths)componentWidths.get(1)).getWidths().get(0))).isEqualTo(100.0);
    }

    private org.kie.workbench.common.dmn.api.definition.model.Context setupDMNFromWB(Optional<Expression> defaultExpression) {
        org.kie.workbench.common.dmn.api.definition.model.Context wb = new org.kie.workbench.common.dmn.api.definition.model.Context();
        org.kie.workbench.common.dmn.api.definition.model.ContextEntry contextEntry1 = new org.kie.workbench.common.dmn.api.definition.model.ContextEntry();
        org.kie.workbench.common.dmn.api.definition.model.ContextEntry contextEntry2 = new org.kie.workbench.common.dmn.api.definition.model.ContextEntry();
        InformationItem informationItem = new InformationItem();
        this.literalExpression.getComponentWidths().set(0, 200.0);
        this.literalExpression.getId().setValue(EXPRESSION_UUID);
        contextEntry1.setExpression((Expression)this.literalExpression);
        contextEntry1.setVariable(informationItem);
        defaultExpression.ifPresent(arg_0 -> ((org.kie.workbench.common.dmn.api.definition.model.ContextEntry)contextEntry2).setExpression(arg_0));
        wb.getContextEntry().add(contextEntry1);
        wb.getContextEntry().add(contextEntry2);
        return wb;
    }
}

