/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.marshalling.server.ServerMarshalling;
import org.kie.dmn.backend.marshalling.v1_1.DMNMarshallerFactory;
import org.kie.dmn.model.v1_1.BusinessKnowledgeModel;
import org.kie.dmn.model.v1_1.DMNElement;
import org.kie.dmn.model.v1_1.DMNElementReference;
import org.kie.dmn.model.v1_1.Decision;
import org.kie.dmn.model.v1_1.Definitions;
import org.kie.dmn.model.v1_1.InformationRequirement;
import org.kie.dmn.model.v1_1.KnowledgeSource;
import org.kie.dmn.model.v1_1.TextAnnotation;
import org.kie.workbench.common.dmn.api.DMNDefinitionSet;
import org.kie.workbench.common.dmn.api.definition.v1_1.Association;
import org.kie.workbench.common.dmn.api.definition.v1_1.AuthorityRequirement;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.v1_1.DRGElement;
import org.kie.workbench.common.dmn.api.definition.v1_1.InputData;
import org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeRequirement;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.backend.definition.v1_1.AssociationConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.BusinessKnowledgeModelConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.DecisionConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.DefinitionsConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.InputDataConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.KnowledgeSourceConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.TextAnnotationConverter;
import org.kie.workbench.common.stunner.backend.service.XMLEncoderDiagramMetadataMarshaller;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMetadataMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;
import org.kie.workbench.common.stunner.core.util.UUID;

@ApplicationScoped
public class DMNMarshaller
implements DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>> {
    private XMLEncoderDiagramMetadataMarshaller diagramMetadataMarshaller;
    private FactoryManager factoryManager;
    private InputDataConverter inputDataConverter;
    private DecisionConverter decisionConverter;
    private BusinessKnowledgeModelConverter bkmConverter;
    private KnowledgeSourceConverter knowledgeSourceConverter;
    private TextAnnotationConverter textAnnotationConverter;
    private org.kie.dmn.api.marshalling.v1_1.DMNMarshaller marshaller;

    protected DMNMarshaller() {
        this(null, null);
    }

    @Inject
    public DMNMarshaller(XMLEncoderDiagramMetadataMarshaller diagramMetadataMarshaller, FactoryManager factoryManager) {
        this.diagramMetadataMarshaller = diagramMetadataMarshaller;
        this.factoryManager = factoryManager;
        this.inputDataConverter = new InputDataConverter(factoryManager);
        this.decisionConverter = new DecisionConverter(factoryManager);
        this.bkmConverter = new BusinessKnowledgeModelConverter(factoryManager);
        this.knowledgeSourceConverter = new KnowledgeSourceConverter(factoryManager);
        this.textAnnotationConverter = new TextAnnotationConverter(factoryManager);
        this.marshaller = DMNMarshallerFactory.newDefaultMarshaller();
    }

    @Deprecated
    public Graph unmarshallFromStunnerJSON(Metadata metadata, InputStream input) throws IOException {
        Graph result = (Graph)ServerMarshalling.fromJSON((InputStream)input);
        return result;
    }

    @Deprecated
    public String marshallFromStunnerToJSON(Diagram<Graph, Metadata> diagram) throws IOException {
        String result = ServerMarshalling.toJSON((Object)diagram.getGraph());
        return result;
    }

    public Graph unmarshall(Metadata metadata, InputStream input) throws IOException {
        Definitions dmnXml = this.marshaller.unmarshal((Reader)new InputStreamReader(input));
        Map<String, Map.Entry> elems = dmnXml.getDrgElement().stream().collect(Collectors.toMap(DMNElement::getId, dmn -> new AbstractMap.SimpleEntry<org.kie.dmn.model.v1_1.DRGElement, Node>((org.kie.dmn.model.v1_1.DRGElement)dmn, this.dmnToStunner((org.kie.dmn.model.v1_1.DRGElement)dmn))));
        for (Map.Entry kv2 : elems.values()) {
            Edge myEdge;
            Node requiredNode;
            String reqInputID;
            org.kie.dmn.model.v1_1.DRGElement elem = (org.kie.dmn.model.v1_1.DRGElement)kv2.getKey();
            Node currentNode = (Node)kv2.getValue();
            if (elem instanceof Decision) {
                Decision decision = (Decision)elem;
                for (InformationRequirement ir : decision.getInformationRequirement()) {
                    if (ir.getRequiredInput() != null) {
                        reqInputID = this.getId(ir.getRequiredInput());
                        requiredNode = (Node)elems.get(reqInputID).getValue();
                        myEdge = this.factoryManager.newElement(UUID.uuid(), org.kie.workbench.common.dmn.api.definition.v1_1.InformationRequirement.class).asEdge();
                        this.connectEdge(myEdge, requiredNode, currentNode);
                        this.setConnectionMagnets(myEdge);
                    }
                    if (ir.getRequiredDecision() == null) continue;
                    reqInputID = this.getId(ir.getRequiredDecision());
                    requiredNode = (Node)elems.get(reqInputID).getValue();
                    myEdge = this.factoryManager.newElement(UUID.uuid(), org.kie.workbench.common.dmn.api.definition.v1_1.InformationRequirement.class).asEdge();
                    this.connectEdge(myEdge, requiredNode, currentNode);
                    this.setConnectionMagnets(myEdge);
                }
                for (org.kie.dmn.model.v1_1.KnowledgeRequirement kr : decision.getKnowledgeRequirement()) {
                    reqInputID = this.getId(kr.getRequiredKnowledge());
                    requiredNode = (Node)elems.get(reqInputID).getValue();
                    myEdge = this.factoryManager.newElement(UUID.uuid(), KnowledgeRequirement.class).asEdge();
                    this.connectEdge(myEdge, requiredNode, currentNode);
                    this.setConnectionMagnets(myEdge);
                }
                for (org.kie.dmn.model.v1_1.KnowledgeRequirement kr : decision.getAuthorityRequirement()) {
                    reqInputID = this.getId(kr.getRequiredAuthority());
                    requiredNode = (Node)elems.get(reqInputID).getValue();
                    myEdge = this.factoryManager.newElement(UUID.uuid(), AuthorityRequirement.class).asEdge();
                    this.connectEdge(myEdge, requiredNode, currentNode);
                    this.setConnectionMagnets(myEdge);
                }
                continue;
            }
            if (elem instanceof BusinessKnowledgeModel) {
                BusinessKnowledgeModel bkm = (BusinessKnowledgeModel)elem;
                for (org.kie.dmn.model.v1_1.KnowledgeRequirement kr : bkm.getKnowledgeRequirement()) {
                    reqInputID = this.getId(kr.getRequiredKnowledge());
                    requiredNode = (Node)elems.get(reqInputID).getValue();
                    myEdge = this.factoryManager.newElement(UUID.uuid(), KnowledgeRequirement.class).asEdge();
                    this.connectEdge(myEdge, requiredNode, currentNode);
                    this.setConnectionMagnets(myEdge);
                }
                for (org.kie.dmn.model.v1_1.KnowledgeRequirement kr : bkm.getAuthorityRequirement()) {
                    reqInputID = this.getId(kr.getRequiredAuthority());
                    requiredNode = (Node)elems.get(reqInputID).getValue();
                    myEdge = this.factoryManager.newElement(UUID.uuid(), AuthorityRequirement.class).asEdge();
                    this.connectEdge(myEdge, requiredNode, currentNode);
                    this.setConnectionMagnets(myEdge);
                }
                continue;
            }
            if (!(elem instanceof KnowledgeSource)) continue;
            KnowledgeSource ks = (KnowledgeSource)elem;
            for (InformationRequirement ir : ks.getAuthorityRequirement()) {
                if (ir.getRequiredInput() != null) {
                    reqInputID = this.getId(ir.getRequiredInput());
                    requiredNode = (Node)elems.get(reqInputID).getValue();
                    myEdge = this.factoryManager.newElement(UUID.uuid(), AuthorityRequirement.class).asEdge();
                    this.connectEdge(myEdge, requiredNode, currentNode);
                    this.setConnectionMagnets(myEdge);
                }
                if (ir.getRequiredDecision() != null) {
                    reqInputID = this.getId(ir.getRequiredDecision());
                    requiredNode = (Node)elems.get(reqInputID).getValue();
                    myEdge = this.factoryManager.newElement(UUID.uuid(), AuthorityRequirement.class).asEdge();
                    this.connectEdge(myEdge, requiredNode, currentNode);
                    this.setConnectionMagnets(myEdge);
                }
                if (ir.getRequiredAuthority() == null) continue;
                reqInputID = this.getId(ir.getRequiredAuthority());
                requiredNode = (Node)elems.get(reqInputID).getValue();
                myEdge = this.factoryManager.newElement(UUID.uuid(), AuthorityRequirement.class).asEdge();
                this.connectEdge(myEdge, requiredNode, currentNode);
                this.setConnectionMagnets(myEdge);
            }
        }
        Map<String, Node> textAnnotations = dmnXml.getArtifact().stream().filter(TextAnnotation.class::isInstance).map(TextAnnotation.class::cast).collect(Collectors.toMap(DMNElement::getId, this.textAnnotationConverter::nodeFromDMN));
        List associations = dmnXml.getArtifact().stream().filter(org.kie.dmn.model.v1_1.Association.class::isInstance).map(org.kie.dmn.model.v1_1.Association.class::cast).collect(Collectors.toList());
        for (org.kie.dmn.model.v1_1.Association a : associations) {
            String sourceId = this.getId(a.getSourceRef());
            Node sourceNode = Optional.ofNullable(elems.get(sourceId)).map(Map.Entry::getValue).orElse(textAnnotations.get(sourceId));
            String targetId = this.getId(a.getTargetRef());
            Node targetNode = Optional.ofNullable(elems.get(targetId)).map(Map.Entry::getValue).orElse(textAnnotations.get(targetId));
            Edge myEdge = this.factoryManager.newElement(UUID.uuid(), Association.class).asEdge();
            Id id = new Id(a.getId());
            Description description = new Description(a.getDescription());
            Association definition = new Association(id, description);
            ((View)myEdge.getContent()).setDefinition((Object)definition);
            this.connectEdge(myEdge, sourceNode, targetNode);
            this.setConnectionMagnets(myEdge);
        }
        Graph graph = this.factoryManager.newDiagram("prova", BindableAdapterUtils.getDefinitionSetId(DMNDefinitionSet.class), metadata).getGraph();
        elems.values().stream().map(kv -> (Node)kv.getValue()).forEach(arg_0 -> ((Graph)graph).addNode(arg_0));
        textAnnotations.values().forEach(arg_0 -> ((Graph)graph).addNode(arg_0));
        Node<?, ?> dmnDiagramRoot = DMNMarshaller.findDMNDiagramRoot(graph);
        org.kie.workbench.common.dmn.api.definition.v1_1.Definitions definitionsStunnerPojo = DefinitionsConverter.wbFromDMN(dmnXml);
        ((DMNDiagram)((View)dmnDiagramRoot.getContent()).getDefinition()).setDefinitions(definitionsStunnerPojo);
        elems.values().stream().map(kv -> (Node)kv.getValue()).forEach(node -> this.connectRootWithChild((Node)dmnDiagramRoot, (Node)node));
        textAnnotations.values().stream().forEach(node -> this.connectRootWithChild((Node)dmnDiagramRoot, (Node)node));
        return graph;
    }

    public static Node<?, ?> findDMNDiagramRoot(Graph<?, Node<View, ?>> graph) {
        return StreamSupport.stream(graph.nodes().spliterator(), false).filter(n -> ((View)n.getContent()).getDefinition() instanceof DMNDiagram).findFirst().orElseThrow(() -> new UnsupportedOperationException("TODO"));
    }

    private String getId(DMNElementReference er) {
        String href = er.getHref();
        return href.contains("#") ? href.substring(href.indexOf(35) + 1) : href;
    }

    private Node dmnToStunner(org.kie.dmn.model.v1_1.DRGElement dmn) {
        if (dmn instanceof org.kie.dmn.model.v1_1.InputData) {
            return this.inputDataConverter.nodeFromDMN((org.kie.dmn.model.v1_1.InputData)dmn);
        }
        if (dmn instanceof Decision) {
            return this.decisionConverter.nodeFromDMN((Decision)dmn);
        }
        if (dmn instanceof BusinessKnowledgeModel) {
            return this.bkmConverter.nodeFromDMN((BusinessKnowledgeModel)dmn);
        }
        if (dmn instanceof KnowledgeSource) {
            return this.knowledgeSourceConverter.nodeFromDMN((KnowledgeSource)dmn);
        }
        throw new UnsupportedOperationException("TODO");
    }

    private void connectRootWithChild(Node dmnDiagramRoot, Node child) {
        String uuid = UUID.uuid();
        EdgeImpl edge = new EdgeImpl(uuid);
        edge.setContent((Object)new Child());
        this.connectEdge((Edge)edge, dmnDiagramRoot, child);
    }

    private void connectEdge(Edge edge, Node source, Node target) {
        edge.setSourceNode(source);
        edge.setTargetNode(target);
        source.getOutEdges().add(edge);
        target.getInEdges().add(edge);
    }

    private void setConnectionMagnets(Edge edge) {
        Node targetNode;
        ViewConnector connectionContent = (ViewConnector)edge.getContent();
        Node sourceNode = edge.getSourceNode();
        if (null != sourceNode) {
            connectionContent.setSourceConnection((Connection)MagnetConnection.Builder.forElement((Element)sourceNode));
        }
        if (null != (targetNode = edge.getTargetNode())) {
            connectionContent.setTargetConnection((Connection)MagnetConnection.Builder.forElement((Element)targetNode));
        }
    }

    public String marshall(Diagram<Graph, Metadata> diagram) throws IOException {
        Graph g = diagram.getGraph();
        HashMap<String, org.kie.dmn.model.v1_1.DRGElement> nodes = new HashMap<String, org.kie.dmn.model.v1_1.DRGElement>();
        HashMap<String, TextAnnotation> textAnnotations = new HashMap<String, TextAnnotation>();
        Node<?, ?> dmnDiagramRoot = DMNMarshaller.findDMNDiagramRoot(g);
        org.kie.workbench.common.dmn.api.definition.v1_1.Definitions definitionsStunnerPojo = ((DMNDiagram)((View)dmnDiagramRoot.getContent()).getDefinition()).getDefinitions();
        Definitions definitions = DefinitionsConverter.dmnFromWB(definitionsStunnerPojo);
        for (Node node : g.nodes()) {
            if (!(node.getContent() instanceof View)) continue;
            View view = (View)node.getContent();
            if (view.getDefinition() instanceof DRGElement) {
                DRGElement n = (DRGElement)view.getDefinition();
                nodes.put(n.getId().getValue(), this.stunnerToDMN(node));
                continue;
            }
            if (!(view.getDefinition() instanceof org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation)) continue;
            org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation textAnnotation = (org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation)view.getDefinition();
            textAnnotations.put(textAnnotation.getId().getValue(), this.textAnnotationConverter.dmnFromNode((Node<View<org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation>, ?>)node));
            List<org.kie.dmn.model.v1_1.Association> associations = AssociationConverter.dmnFromWB(node);
            definitions.getArtifact().addAll(associations);
        }
        nodes.values().forEach(definitions.getDrgElement()::add);
        textAnnotations.values().forEach(definitions.getArtifact()::add);
        String marshalled = this.marshaller.marshal((Object)definitions);
        return marshalled;
    }

    private org.kie.dmn.model.v1_1.DRGElement stunnerToDMN(Node<?, ?> node) {
        if (node.getContent() instanceof View) {
            View view = (View)node.getContent();
            if (view.getDefinition() instanceof InputData) {
                return this.inputDataConverter.dmnFromNode((Node<View<InputData>, ?>)node);
            }
            if (view.getDefinition() instanceof org.kie.workbench.common.dmn.api.definition.v1_1.Decision) {
                return this.decisionConverter.dmnFromNode((Node<View<org.kie.workbench.common.dmn.api.definition.v1_1.Decision>, ?>)node);
            }
            if (view.getDefinition() instanceof org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel) {
                return this.bkmConverter.dmnFromNode((Node<View<org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel>, ?>)node);
            }
            if (view.getDefinition() instanceof org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource) {
                return this.knowledgeSourceConverter.dmnFromNode((Node<View<org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource>, ?>)node);
            }
            throw new UnsupportedOperationException("TODO");
        }
        throw new RuntimeException("wrong diagram structure to marshall");
    }

    public DiagramMetadataMarshaller<Metadata> getMetadataMarshaller() {
        return this.diagramMetadataMarshaller;
    }
}

