/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.List;
import org.kie.dmn.model.v1_1.AuthorityRequirement;
import org.kie.dmn.model.v1_1.DMNElementReference;
import org.kie.dmn.model.v1_1.KnowledgeRequirement;
import org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.v1_1.DRGElement;
import org.kie.workbench.common.dmn.api.definition.v1_1.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource;
import org.kie.workbench.common.dmn.api.property.background.BackgroundSet;
import org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.font.FontSet;
import org.kie.workbench.common.dmn.backend.definition.v1_1.FunctionDefinitionConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.InformationItemPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.NodeConverter;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class BusinessKnowledgeModelConverter
implements NodeConverter<org.kie.dmn.model.v1_1.BusinessKnowledgeModel, BusinessKnowledgeModel> {
    private FactoryManager factoryManager;

    public BusinessKnowledgeModelConverter(FactoryManager factoryManager) {
        this.factoryManager = factoryManager;
    }

    @Override
    public Node<View<BusinessKnowledgeModel>, ?> nodeFromDMN(org.kie.dmn.model.v1_1.BusinessKnowledgeModel dmn) {
        Node node = this.factoryManager.newElement(dmn.getId(), BusinessKnowledgeModel.class).asNode();
        Id id = new Id(dmn.getId());
        Description description = new Description(dmn.getDescription());
        Name name = new Name(dmn.getName());
        InformationItem informationItem = InformationItemPropertyConverter.wbFromDMN(dmn.getVariable());
        FunctionDefinition functionDefinition = FunctionDefinitionConverter.wbFromDMN(dmn.getEncapsulatedLogic());
        BusinessKnowledgeModel bkm = new BusinessKnowledgeModel(id, description, name, informationItem, functionDefinition, new BackgroundSet(), new FontSet(), new RectangleDimensionsSet());
        ((View)node.getContent()).setDefinition((Object)bkm);
        return node;
    }

    @Override
    public org.kie.dmn.model.v1_1.BusinessKnowledgeModel dmnFromNode(Node<View<BusinessKnowledgeModel>, ?> node) {
        BusinessKnowledgeModel source = (BusinessKnowledgeModel)((View)node.getContent()).getDefinition();
        org.kie.dmn.model.v1_1.BusinessKnowledgeModel result = new org.kie.dmn.model.v1_1.BusinessKnowledgeModel();
        result.setId(source.getId().getValue());
        result.setDescription(source.getDescription().getValue());
        result.setName(source.getName().getValue());
        result.setVariable(InformationItemPropertyConverter.dmnFromWB(source.getVariable()));
        result.setEncapsulatedLogic(FunctionDefinitionConverter.dmnFromWB(source.getEncapsulatedLogic()));
        List inEdges = node.getInEdges();
        for (Edge e : inEdges) {
            DMNElementReference ri;
            KnowledgeRequirement iReq;
            View view;
            Node sourceNode = e.getSourceNode();
            if (!(sourceNode.getContent() instanceof View) || !((view = (View)sourceNode.getContent()).getDefinition() instanceof DRGElement)) continue;
            DRGElement drgElement = (DRGElement)view.getDefinition();
            if (drgElement instanceof BusinessKnowledgeModel) {
                iReq = new KnowledgeRequirement();
                ri = new DMNElementReference();
                ri.setHref("#" + drgElement.getId().getValue());
                iReq.setRequiredKnowledge(ri);
                result.getKnowledgeRequirement().add(iReq);
                continue;
            }
            if (drgElement instanceof KnowledgeSource) {
                iReq = new AuthorityRequirement();
                ri = new DMNElementReference();
                ri.setHref("#" + drgElement.getId().getValue());
                iReq.setRequiredAuthority(ri);
                result.getAuthorityRequirement().add(iReq);
                continue;
            }
            throw new UnsupportedOperationException("wrong model definition.");
        }
        return result;
    }
}

