/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.common;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import javax.xml.namespace.QName;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.api.marshalling.DMNMarshaller;
import org.kie.dmn.model.api.DRGElement;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.Import;
import org.kie.dmn.model.api.InformationItem;
import org.kie.dmn.model.api.ItemDefinition;
import org.kie.dmn.model.v1_2.TDecision;
import org.kie.dmn.model.v1_2.TDecisionService;
import org.kie.dmn.model.v1_2.TInformationItem;
import org.kie.dmn.model.v1_2.TInputData;
import org.kie.dmn.model.v1_2.TItemDefinition;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.marshalling.DMNPathsHelper;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.backend.common.DMNIOHelper;
import org.kie.workbench.common.dmn.backend.common.DMNMarshallerImportsHelperStandaloneImpl;
import org.kie.workbench.common.dmn.backend.common.DMNPathsHelperImpl;
import org.kie.workbench.common.dmn.backend.editors.common.PMMLIncludedDocumentFactory;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNMarshallerImplImportsHelperTest {
    @Mock
    private DMNPathsHelperImpl pathsHelper;
    @Mock
    private WorkspaceProjectService projectService;
    @Mock
    private IOService ioService;
    @Mock
    private DMNMarshaller marshaller;
    @Mock
    private DMNIOHelper dmnIOHelper;
    @Mock
    private PMMLIncludedDocumentFactory pmmlDocumentFactory;
    private DMNMarshallerImportsHelperStandaloneImpl helper;

    @Before
    public void setup() {
        this.helper = (DMNMarshallerImportsHelperStandaloneImpl)Mockito.spy((Object)new DMNMarshallerImportsHelperStandaloneImpl((DMNPathsHelper)this.pathsHelper, this.projectService, this.marshaller, this.dmnIOHelper, this.pmmlDocumentFactory, this.ioService));
    }

    @Test
    public void testGetImportDefinitions() {
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        Import import1 = (Import)Mockito.mock(Import.class);
        Import import2 = (Import)Mockito.mock(Import.class);
        Import import3 = (Import)Mockito.mock(Import.class);
        List<Import> imports = Arrays.asList(import1, import2, import3);
        Definitions definitions1 = (Definitions)Mockito.mock(Definitions.class);
        Definitions definitions2 = (Definitions)Mockito.mock(Definitions.class);
        Definitions definitions3 = (Definitions)Mockito.mock(Definitions.class);
        List<Definitions> definitions = Arrays.asList(definitions1, definitions2, definitions3);
        Mockito.when((Object)definitions1.getNamespace()).thenReturn((Object)"://namespace1");
        Mockito.when((Object)definitions2.getNamespace()).thenReturn((Object)"://namespace2");
        Mockito.when((Object)definitions3.getNamespace()).thenReturn((Object)"://namespace3");
        Mockito.when((Object)import1.getNamespace()).thenReturn((Object)"://namespace1");
        Mockito.when((Object)import2.getNamespace()).thenReturn((Object)"://namespace2-diff");
        Mockito.when((Object)import3.getNamespace()).thenReturn((Object)"://namespace3");
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn(definitions).when((Object)this.helper)).getOtherDMNDiagramsDefinitions(metadata);
        Map importDefinitions = this.helper.getImportDefinitions(metadata, imports);
        Assert.assertEquals((long)2L, (long)importDefinitions.size());
        Assert.assertEquals((Object)definitions1, importDefinitions.get(import1));
        Assert.assertEquals((Object)definitions3, importDefinitions.get(import3));
    }

    @Test
    public void testGetPMMLDocuments() {
        org.uberfire.backend.vfs.Path dmnModelPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        PMMLDocumentMetadata pmmlDocument = (PMMLDocumentMetadata)Mockito.mock(PMMLDocumentMetadata.class);
        Import import1 = (Import)Mockito.mock(Import.class);
        List<Import> imports = Collections.singletonList(import1);
        org.uberfire.backend.vfs.Path path1 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path path2 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        List<org.uberfire.backend.vfs.Path> paths = Arrays.asList(path1, path2);
        Mockito.when((Object)metadata.getPath()).thenReturn((Object)dmnModelPath);
        Mockito.when((Object)import1.getLocationURI()).thenReturn((Object)"document1.pmml");
        Mockito.when((Object)this.pathsHelper.getRelativeURI(dmnModelPath, path1)).thenReturn((Object)"document1.pmml");
        Mockito.when((Object)this.pathsHelper.getRelativeURI(dmnModelPath, path2)).thenReturn((Object)"document2.pmml");
        Mockito.when((Object)this.pmmlDocumentFactory.getDocumentByPath(path1)).thenReturn((Object)pmmlDocument);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn(paths).when((Object)this.helper)).getPMMLDocumentPaths(metadata);
        Map importDefinitions = this.helper.getPMMLDocuments(metadata, imports);
        Assert.assertEquals((long)1L, (long)importDefinitions.size());
        Assert.assertEquals((Object)pmmlDocument, importDefinitions.get(import1));
    }

    @Test
    public void testGetPMMLDocumentPaths() {
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        WorkspaceProject project = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        org.uberfire.backend.vfs.Path projectPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)metadata.getPath()).thenReturn((Object)projectPath);
        Mockito.when((Object)this.projectService.resolveProject((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class))).thenReturn((Object)project);
        this.helper.getPMMLDocumentPaths(metadata);
        ((WorkspaceProjectService)Mockito.verify((Object)this.projectService)).resolveProject(projectPath);
    }

    @Test
    public void testGetImportXML() throws java.io.IOException {
        String xml1 = "<some xml/>";
        String xml2 = "<some other xml/>";
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        Import import1 = (Import)Mockito.mock(Import.class);
        org.uberfire.backend.vfs.Path path1 = this.makePath("../file1.dmn");
        org.uberfire.backend.vfs.Path path2 = this.makePath("../file2.dmn");
        InputStream inputStream1 = (InputStream)Mockito.mock(InputStream.class);
        InputStream inputStream2 = (InputStream)Mockito.mock(InputStream.class);
        InputStreamReader inputStreamReader1 = (InputStreamReader)Mockito.mock(InputStreamReader.class);
        InputStreamReader inputStreamReader2 = (InputStreamReader)Mockito.mock(InputStreamReader.class);
        List<org.uberfire.backend.vfs.Path> paths = Arrays.asList(path1, path2);
        Mockito.when((Object)this.pathsHelper.getDMNModelsPaths((WorkspaceProject)Matchers.any())).thenReturn(paths);
        Mockito.when((Object)this.dmnIOHelper.isAsString(inputStream1)).thenReturn((Object)"<some xml/>");
        Mockito.when((Object)this.dmnIOHelper.isAsString(inputStream2)).thenReturn((Object)"<some other xml/>");
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn(Optional.of(inputStream1)).when((Object)this.helper)).loadPath(path1);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn(Optional.of(inputStream2)).when((Object)this.helper)).loadPath(path2);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn((Object)inputStreamReader1).when((Object)this.helper)).toInputStreamReader(inputStream1);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn((Object)inputStreamReader2).when((Object)this.helper)).toInputStreamReader(inputStream2);
        StringReader stringReader1 = (StringReader)Mockito.mock(StringReader.class);
        StringReader stringReader2 = (StringReader)Mockito.mock(StringReader.class);
        Definitions definitions1 = (Definitions)Mockito.mock(Definitions.class);
        Definitions definitions2 = (Definitions)Mockito.mock(Definitions.class);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn((Object)stringReader1).when((Object)this.helper)).toStringReader("<some xml/>");
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn((Object)stringReader2).when((Object)this.helper)).toStringReader("<some other xml/>");
        Mockito.when((Object)this.marshaller.unmarshal((Reader)stringReader1)).thenReturn((Object)definitions1);
        Mockito.when((Object)this.marshaller.unmarshal((Reader)stringReader2)).thenReturn((Object)definitions2);
        Mockito.when((Object)import1.getNamespace()).thenReturn((Object)"://namespace1");
        Mockito.when((Object)definitions1.getNamespace()).thenReturn((Object)"://namespace1");
        Mockito.when((Object)definitions2.getNamespace()).thenReturn((Object)"://namespace2-not-imported");
        List<Import> imports = Collections.singletonList(import1);
        Map importXML = this.helper.getImportXML(metadata, imports);
        Assert.assertEquals((long)1L, (long)importXML.size());
        Assert.assertEquals((Object)"<some xml/>", importXML.get(import1));
    }

    @Test
    public void testGetImportedDRGElements() {
        HashMap<Import, Definitions> importDefinitions = new HashMap<Import, Definitions>();
        Import anImport = (Import)Mockito.mock(Import.class);
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        DRGElement drgElement1 = (DRGElement)Mockito.mock(DRGElement.class);
        DRGElement drgElement2 = (DRGElement)Mockito.mock(DRGElement.class);
        DRGElement drgElement3 = (DRGElement)Mockito.mock(DRGElement.class);
        List<DRGElement> expectedDRGElements = Arrays.asList(drgElement1, drgElement2, drgElement3);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn(expectedDRGElements).when((Object)this.helper)).getDrgElementsWithNamespace(definitions, anImport);
        importDefinitions.put(anImport, definitions);
        List actualDRGElements = this.helper.getImportedDRGElements(importDefinitions);
        Assert.assertEquals(expectedDRGElements, (Object)actualDRGElements);
    }

    @Test
    public void testGetImportedItemDefinitions() {
        HashMap<Import, Definitions> importDefinitions = new HashMap<Import, Definitions>();
        Import anImport = (Import)Mockito.mock(Import.class);
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        ItemDefinition itemDefinition1 = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ItemDefinition itemDefinition2 = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ItemDefinition itemDefinition3 = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        List<ItemDefinition> expectedItemDefinitions = Arrays.asList(itemDefinition1, itemDefinition2, itemDefinition3);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn(expectedItemDefinitions).when((Object)this.helper)).getItemDefinitionsWithNamespace(definitions, anImport);
        importDefinitions.put(anImport, definitions);
        List actualItemDefinitions = this.helper.getImportedItemDefinitions(importDefinitions);
        Assert.assertEquals(expectedItemDefinitions, (Object)actualItemDefinitions);
    }

    @Test
    public void testGetDrgElementsWithNamespace() {
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        Import anImport = (Import)Mockito.mock(Import.class);
        TDecision drgElement1 = new TDecision();
        TInputData drgElement2 = new TInputData();
        TDecisionService drgElement3 = new TDecisionService();
        TInformationItem informationItem1 = new TInformationItem();
        TInformationItem informationItem2 = new TInformationItem();
        TInformationItem informationItem3 = new TInformationItem();
        List<DRGElement> drgElements = Arrays.asList(drgElement1, drgElement2, drgElement3);
        String namespace = "http://github.com/kiegroup/_something";
        String builtInTypeNumber = BuiltInType.NUMBER.getName();
        Mockito.when((Object)anImport.getName()).thenReturn((Object)"model");
        Mockito.when((Object)anImport.getNamespace()).thenReturn((Object)"http://github.com/kiegroup/_something");
        informationItem1.setTypeRef(new QName("", "tUUID", ""));
        informationItem2.setTypeRef(new QName("", "tAge", ""));
        informationItem3.setTypeRef(new QName("", builtInTypeNumber, ""));
        drgElement1.setId("0000-1111");
        drgElement2.setId("2222-3333");
        drgElement3.setId("4444-5555");
        drgElement1.setName("Decision");
        drgElement2.setName("Input Data");
        drgElement3.setName("Decision Service");
        drgElement1.setVariable((InformationItem)informationItem1);
        drgElement2.setVariable((InformationItem)informationItem2);
        drgElement3.setVariable((InformationItem)informationItem3);
        Mockito.when((Object)definitions.getDrgElement()).thenReturn(drgElements);
        List elements = this.helper.getDrgElementsWithNamespace(definitions, anImport);
        Assert.assertEquals((long)3L, (long)elements.size());
        TDecision element1 = (TDecision)elements.get(0);
        Assert.assertEquals((Object)"model:0000-1111", (Object)element1.getId());
        Assert.assertEquals((Object)"model.Decision", (Object)element1.getName());
        Assert.assertEquals((Object)"model.tUUID", (Object)element1.getVariable().getTypeRef().getLocalPart());
        Assert.assertEquals((Object)"http://github.com/kiegroup/_something", (Object)this.getNamespace((DRGElement)element1));
        TInputData element2 = (TInputData)elements.get(1);
        Assert.assertEquals((Object)"model:2222-3333", (Object)element2.getId());
        Assert.assertEquals((Object)"model.Input Data", (Object)element2.getName());
        Assert.assertEquals((Object)"model.tAge", (Object)element2.getVariable().getTypeRef().getLocalPart());
        Assert.assertEquals((Object)"http://github.com/kiegroup/_something", (Object)this.getNamespace((DRGElement)element2));
        TDecisionService element3 = (TDecisionService)elements.get(2);
        Assert.assertEquals((Object)"model:4444-5555", (Object)element3.getId());
        Assert.assertEquals((Object)"model.Decision Service", (Object)element3.getName());
        Assert.assertEquals((Object)builtInTypeNumber, (Object)element3.getVariable().getTypeRef().getLocalPart());
        Assert.assertEquals((Object)"http://github.com/kiegroup/_something", (Object)this.getNamespace((DRGElement)element3));
    }

    private String getNamespace(DRGElement element) {
        return (String)element.getAdditionalAttributes().get(DMNMarshallerImportsHelperStandaloneImpl.NAMESPACE);
    }

    @Test
    public void testGetItemDefinitionsWithNamespace() {
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        Import anImport = (Import)Mockito.mock(Import.class);
        TItemDefinition itemDefinition1 = new TItemDefinition();
        TItemDefinition itemDefinition2 = new TItemDefinition();
        TItemDefinition itemDefinition3 = new TItemDefinition();
        TItemDefinition itemDefinition4 = new TItemDefinition();
        TItemDefinition itemDefinition5 = new TItemDefinition();
        List<ItemDefinition> itemDefinitions = Arrays.asList(itemDefinition1, itemDefinition2, itemDefinition3, itemDefinition4, itemDefinition5);
        itemDefinition1.setName("tUUID");
        itemDefinition2.setName("tPerson");
        itemDefinition3.setName("id");
        itemDefinition4.setName("name");
        itemDefinition5.setName("age");
        itemDefinition1.setTypeRef(new QName("string"));
        itemDefinition2.setTypeRef(null);
        itemDefinition3.setTypeRef(new QName("tUUID"));
        itemDefinition4.setTypeRef(new QName("string"));
        itemDefinition5.setTypeRef(new QName("number"));
        Mockito.when((Object)anImport.getName()).thenReturn((Object)"model");
        Mockito.when((Object)definitions.getItemDefinition()).thenReturn(itemDefinitions);
        List actualItemDefinitions = this.helper.getItemDefinitionsWithNamespace(definitions, anImport);
        Assert.assertEquals((long)5L, (long)actualItemDefinitions.size());
        ItemDefinition actualItemDefinition1 = (ItemDefinition)actualItemDefinitions.get(0);
        Assert.assertEquals((Object)"model.tUUID", (Object)actualItemDefinition1.getName());
        Assert.assertEquals((Object)"string", (Object)actualItemDefinition1.getTypeRef().getLocalPart());
        ItemDefinition actualItemDefinition2 = (ItemDefinition)actualItemDefinitions.get(1);
        Assert.assertEquals((Object)"model.tPerson", (Object)actualItemDefinition2.getName());
        Assert.assertNull((Object)actualItemDefinition2.getTypeRef());
        ItemDefinition actualItemDefinition3 = (ItemDefinition)actualItemDefinitions.get(2);
        Assert.assertEquals((Object)"model.id", (Object)actualItemDefinition3.getName());
        Assert.assertEquals((Object)"model.tUUID", (Object)actualItemDefinition3.getTypeRef().getLocalPart());
        ItemDefinition actualItemDefinition4 = (ItemDefinition)actualItemDefinitions.get(3);
        Assert.assertEquals((Object)"model.name", (Object)actualItemDefinition4.getName());
        Assert.assertEquals((Object)"string", (Object)actualItemDefinition4.getTypeRef().getLocalPart());
        ItemDefinition actualItemDefinition5 = (ItemDefinition)actualItemDefinitions.get(4);
        Assert.assertEquals((Object)"model.age", (Object)actualItemDefinition5.getName());
        Assert.assertEquals((Object)"number", (Object)actualItemDefinition5.getTypeRef().getLocalPart());
    }

    @Test
    public void testGetOtherDMNDiagramsDefinitions() {
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        org.uberfire.backend.vfs.Path path1 = this.makePath("../file1.dmn");
        org.uberfire.backend.vfs.Path path2 = this.makePath("../file2.dmn");
        org.uberfire.backend.vfs.Path path3 = this.makePath("../file3.dmn");
        org.uberfire.backend.vfs.Path path4 = this.makePath("../file4.dmn");
        InputStream inputStream1 = (InputStream)Mockito.mock(InputStream.class);
        InputStream inputStream2 = (InputStream)Mockito.mock(InputStream.class);
        InputStream inputStream3 = (InputStream)Mockito.mock(InputStream.class);
        InputStreamReader inputStreamReader1 = (InputStreamReader)Mockito.mock(InputStreamReader.class);
        InputStreamReader inputStreamReader2 = (InputStreamReader)Mockito.mock(InputStreamReader.class);
        InputStreamReader inputStreamReader3 = (InputStreamReader)Mockito.mock(InputStreamReader.class);
        Definitions definitions1 = (Definitions)Mockito.mock(Definitions.class);
        Definitions definitions2 = (Definitions)Mockito.mock(Definitions.class);
        Definitions definitions3 = (Definitions)Mockito.mock(Definitions.class);
        List<org.uberfire.backend.vfs.Path> paths = Arrays.asList(path1, path2, path3, path4);
        Mockito.when((Object)this.pathsHelper.getDMNModelsPaths((WorkspaceProject)Matchers.any())).thenReturn(paths);
        Mockito.when((Object)metadata.getPath()).thenReturn((Object)path2);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn(Optional.of(inputStream1)).when((Object)this.helper)).loadPath(path1);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn(Optional.of(inputStream2)).when((Object)this.helper)).loadPath(path2);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn(Optional.of(inputStream3)).when((Object)this.helper)).loadPath(path3);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn((Object)inputStreamReader1).when((Object)this.helper)).toInputStreamReader(inputStream1);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn((Object)inputStreamReader2).when((Object)this.helper)).toInputStreamReader(inputStream2);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn((Object)inputStreamReader3).when((Object)this.helper)).toInputStreamReader(inputStream3);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn(Optional.empty()).when((Object)this.helper)).loadPath(path4);
        Mockito.when((Object)this.marshaller.unmarshal((Reader)inputStreamReader1)).thenReturn((Object)definitions1);
        Mockito.when((Object)this.marshaller.unmarshal((Reader)inputStreamReader2)).thenReturn((Object)definitions2);
        Mockito.when((Object)this.marshaller.unmarshal((Reader)inputStreamReader3)).thenReturn((Object)definitions3);
        List actualDefinitions = this.helper.getOtherDMNDiagramsDefinitions(metadata);
        List<Definitions> expectedDefinitions = Arrays.asList(definitions1, definitions3);
        Assert.assertEquals(expectedDefinitions, (Object)actualDefinitions);
    }

    @Test
    public void testGetOtherDMNDiagramsDefinitionsWhenProjectCannotBeFound() {
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        org.uberfire.backend.vfs.Path path1 = this.makePath("../file1.dmn");
        org.uberfire.backend.vfs.Path path2 = this.makePath("../file2.dmn");
        org.uberfire.backend.vfs.Path path3 = this.makePath("../file3.dmn");
        InputStream inputStream1 = (InputStream)Mockito.mock(InputStream.class);
        InputStream inputStream2 = (InputStream)Mockito.mock(InputStream.class);
        InputStream inputStream3 = (InputStream)Mockito.mock(InputStream.class);
        InputStreamReader inputStreamReader1 = (InputStreamReader)Mockito.mock(InputStreamReader.class);
        InputStreamReader inputStreamReader2 = (InputStreamReader)Mockito.mock(InputStreamReader.class);
        InputStreamReader inputStreamReader3 = (InputStreamReader)Mockito.mock(InputStreamReader.class);
        Definitions definitions1 = (Definitions)Mockito.mock(Definitions.class);
        Definitions definitions2 = (Definitions)Mockito.mock(Definitions.class);
        Definitions definitions3 = (Definitions)Mockito.mock(Definitions.class);
        List<org.uberfire.backend.vfs.Path> paths = Arrays.asList(path1, path2, path3);
        Mockito.when((Object)this.projectService.resolveProject((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class))).thenThrow(new Throwable[]{new NullPointerException()});
        Mockito.when((Object)this.pathsHelper.getDMNModelsPaths((WorkspaceProject)Matchers.any())).thenReturn(paths);
        Mockito.when((Object)metadata.getPath()).thenReturn((Object)path2);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn(Optional.of(inputStream1)).when((Object)this.helper)).loadPath(path1);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn(Optional.of(inputStream2)).when((Object)this.helper)).loadPath(path2);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn(Optional.of(inputStream3)).when((Object)this.helper)).loadPath(path3);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn((Object)inputStreamReader1).when((Object)this.helper)).toInputStreamReader(inputStream1);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn((Object)inputStreamReader2).when((Object)this.helper)).toInputStreamReader(inputStream2);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn((Object)inputStreamReader3).when((Object)this.helper)).toInputStreamReader(inputStream3);
        Mockito.when((Object)this.marshaller.unmarshal((Reader)inputStreamReader1)).thenReturn((Object)definitions1);
        Mockito.when((Object)this.marshaller.unmarshal((Reader)inputStreamReader2)).thenReturn((Object)definitions2);
        Mockito.when((Object)this.marshaller.unmarshal((Reader)inputStreamReader3)).thenReturn((Object)definitions3);
        List actualDefinitions = this.helper.getOtherDMNDiagramsDefinitions(metadata);
        List<Definitions> expectedDefinitions = Arrays.asList(definitions1, definitions3);
        Assert.assertEquals(expectedDefinitions, (Object)actualDefinitions);
    }

    @Test
    public void testLoadPath() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Path nioPath = (Path)Mockito.mock(Path.class);
        String expectedContent = "<dmn/>";
        byte[] contentBytes = "<dmn/>".getBytes();
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn((Object)nioPath).when((Object)this.helper)).convertPath(path);
        Mockito.when((Object)this.ioService.newInputStream(nioPath, new OpenOption[0])).thenReturn((Object)new ByteArrayInputStream(contentBytes));
        Optional inputStream = this.helper.loadPath(path);
        Assert.assertTrue((boolean)inputStream.isPresent());
        Assert.assertEquals((Object)"<dmn/>", (Object)new Scanner(new InputStreamReader((InputStream)inputStream.get())).next());
    }

    @Test
    public void testLoadPathWhenPathDoesNotExist() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Path nioPath = (Path)Mockito.mock(Path.class);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn((Object)nioPath).when((Object)this.helper)).convertPath(path);
        Mockito.when((Object)this.ioService.newInputStream(nioPath, new OpenOption[0])).thenThrow(new Throwable[]{new IOException()});
        Optional inputStream = this.helper.loadPath(path);
        Assert.assertFalse((boolean)inputStream.isPresent());
    }

    @Test
    public void testGetImportedItemDefinitionsByNamespace() {
        WorkspaceProject workspaceProject = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        String modelName = "model1";
        String namespace = "://namespace1";
        org.uberfire.backend.vfs.Path path1 = this.makePath("../file1.dmn");
        org.uberfire.backend.vfs.Path path2 = this.makePath("../file2.dmn");
        org.uberfire.backend.vfs.Path path3 = this.makePath("../file3.dmn");
        org.uberfire.backend.vfs.Path path4 = this.makePath("../file4.dmn");
        InputStream inputStream1 = (InputStream)Mockito.mock(InputStream.class);
        InputStream inputStream2 = (InputStream)Mockito.mock(InputStream.class);
        InputStream inputStream3 = (InputStream)Mockito.mock(InputStream.class);
        InputStreamReader inputStreamReader1 = (InputStreamReader)Mockito.mock(InputStreamReader.class);
        InputStreamReader inputStreamReader2 = (InputStreamReader)Mockito.mock(InputStreamReader.class);
        InputStreamReader inputStreamReader3 = (InputStreamReader)Mockito.mock(InputStreamReader.class);
        Definitions definitions1 = (Definitions)Mockito.mock(Definitions.class);
        Definitions definitions2 = (Definitions)Mockito.mock(Definitions.class);
        Definitions definitions3 = (Definitions)Mockito.mock(Definitions.class);
        ItemDefinition itemDefinition1 = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ItemDefinition itemDefinition2 = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        List<org.uberfire.backend.vfs.Path> paths = Arrays.asList(path1, path2, path3, path4);
        Mockito.when((Object)this.pathsHelper.getDMNModelsPaths((WorkspaceProject)Matchers.any())).thenReturn(paths);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn(Optional.of(inputStream1)).when((Object)this.helper)).loadPath(path1);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn(Optional.of(inputStream2)).when((Object)this.helper)).loadPath(path2);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn(Optional.of(inputStream3)).when((Object)this.helper)).loadPath(path3);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn((Object)inputStreamReader1).when((Object)this.helper)).toInputStreamReader(inputStream1);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn((Object)inputStreamReader2).when((Object)this.helper)).toInputStreamReader(inputStream2);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn((Object)inputStreamReader3).when((Object)this.helper)).toInputStreamReader(inputStream3);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn(Optional.empty()).when((Object)this.helper)).loadPath(path4);
        Mockito.when((Object)this.marshaller.unmarshal((Reader)inputStreamReader1)).thenReturn((Object)definitions1);
        Mockito.when((Object)this.marshaller.unmarshal((Reader)inputStreamReader2)).thenReturn((Object)definitions2);
        Mockito.when((Object)this.marshaller.unmarshal((Reader)inputStreamReader3)).thenReturn((Object)definitions3);
        Mockito.when((Object)definitions1.getNamespace()).thenReturn((Object)"://namespace1");
        Mockito.when((Object)definitions2.getNamespace()).thenReturn((Object)"://namespace2");
        Mockito.when((Object)definitions3.getNamespace()).thenReturn((Object)"://namespace3");
        Mockito.when((Object)definitions1.getItemDefinition()).thenReturn(Arrays.asList(itemDefinition1, itemDefinition2));
        List actualItemDefinitions = this.helper.getImportedItemDefinitionsByNamespace(workspaceProject, "model1", "://namespace1");
        List<ItemDefinition> expectedItemDefinitions = Arrays.asList(itemDefinition1, itemDefinition2);
        Assert.assertEquals(expectedItemDefinitions, (Object)actualItemDefinitions);
    }

    @Test
    public void testGetModelPath() {
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        WorkspaceProject workspaceProject = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        org.uberfire.backend.vfs.Path metadataPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path path1 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path path2 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path path3 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Definitions definitions1 = (Definitions)Mockito.mock(Definitions.class);
        Definitions definitions2 = (Definitions)Mockito.mock(Definitions.class);
        String modelNamespace = "0000-1111-2222-3333";
        String modelName = "model name";
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn(Optional.of(definitions1)).when((Object)this.helper)).getDefinitionsByPath(path1);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn(Optional.of(definitions2)).when((Object)this.helper)).getDefinitionsByPath(path2);
        ((DMNMarshallerImportsHelperStandaloneImpl)Mockito.doReturn(Optional.empty()).when((Object)this.helper)).getDefinitionsByPath(path3);
        Mockito.when((Object)definitions1.getNamespace()).thenReturn((Object)"0000-0000-0000-0000");
        Mockito.when((Object)definitions2.getNamespace()).thenReturn((Object)"0000-1111-2222-3333");
        Mockito.when((Object)definitions1.getName()).thenReturn((Object)"modll name");
        Mockito.when((Object)definitions2.getName()).thenReturn((Object)"model name");
        Mockito.when((Object)metadata.getPath()).thenReturn((Object)metadataPath);
        Mockito.when((Object)this.projectService.resolveProject(metadataPath)).thenReturn((Object)workspaceProject);
        Mockito.when((Object)this.pathsHelper.getDMNModelsPaths(workspaceProject)).thenReturn(Arrays.asList(path1, path2, path3));
        org.uberfire.backend.vfs.Path modelPath = this.helper.getDMNModelPath(metadata, "0000-1111-2222-3333", "model name");
        Assert.assertEquals((Object)path2, (Object)modelPath);
    }

    @Test
    public void testGetModelPathWhenDMNModelCouldNotBeFound() {
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        String modelNamespace = "0000-1111-2222-3333";
        String modelName = "model name";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.helper.getDMNModelPath(metadata, "0000-1111-2222-3333", "model name")).isInstanceOf(IllegalStateException.class)).hasMessageContaining("A path for the DMN model with namespace [0000-1111-2222-3333] could not be found.");
    }

    private org.uberfire.backend.vfs.Path makePath(String uri) {
        PathFactory.PathImpl path = (PathFactory.PathImpl)Mockito.spy((Object)new PathFactory.PathImpl());
        ((PathFactory.PathImpl)Mockito.doReturn((Object)uri).when((Object)path)).toURI();
        return path;
    }
}

