/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.Collections;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.definition.model.UnaryTests;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.backend.definition.v1_1.ItemDefinitionPropertyConverter;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ItemDefinitionPropertyConverterTest {
    @Test
    public void testWbFromDMNWhenDMNIsNull() {
        Assert.assertNull((Object)ItemDefinitionPropertyConverter.wbFromDMN(null));
    }

    @Test
    public void testWbFromDMNWhenDMNIsNotNull() {
        org.kie.dmn.model.api.ItemDefinition dmn = (org.kie.dmn.model.api.ItemDefinition)Mockito.mock(org.kie.dmn.model.api.ItemDefinition.class);
        String id = "id";
        String name = "name";
        Id expectedId = new Id("id");
        Name expectedName = new Name("name");
        String expectedTypeLanguage = "typeLanguage";
        boolean expectedIsCollection = true;
        String description = "description";
        boolean expectedAllowOnlyVisualChange = false;
        String qNameNamespaceURI = "qName namespaceURI";
        String qNameLocalPart = "qName local part";
        String qNamePrefix = "qName prefix";
        Description expectedDescription = new Description("description");
        javax.xml.namespace.QName expectedTypeRef = new javax.xml.namespace.QName("qName namespaceURI", "qName local part", "qName prefix");
        Mockito.when((Object)dmn.getId()).thenReturn((Object)"id");
        Mockito.when((Object)dmn.getName()).thenReturn((Object)"name");
        Mockito.when((Object)dmn.getTypeLanguage()).thenReturn((Object)"typeLanguage");
        Mockito.when((Object)dmn.isIsCollection()).thenReturn((Object)true);
        Mockito.when((Object)dmn.getDescription()).thenReturn((Object)"description");
        Mockito.when((Object)dmn.getTypeRef()).thenReturn((Object)expectedTypeRef);
        ItemDefinition actualItemDefinition = ItemDefinitionPropertyConverter.wbFromDMN((org.kie.dmn.model.api.ItemDefinition)dmn);
        Id actualId = actualItemDefinition.getId();
        Name actualName = actualItemDefinition.getName();
        String actualTypeLanguage = actualItemDefinition.getTypeLanguage();
        boolean actualIsCollection = actualItemDefinition.isIsCollection();
        Description actualDescription = actualItemDefinition.getDescription();
        QName actualTypeRef = actualItemDefinition.getTypeRef();
        boolean actualAllowOnlyVisualChange = actualItemDefinition.isAllowOnlyVisualChange();
        Assert.assertEquals((Object)expectedId, (Object)actualId);
        Assert.assertEquals((Object)expectedName, (Object)actualName);
        Assert.assertEquals((Object)"typeLanguage", (Object)actualTypeLanguage);
        Assert.assertEquals((Object)true, (Object)actualIsCollection);
        Assert.assertEquals((Object)expectedDescription, (Object)actualDescription);
        Assert.assertEquals((Object)false, (Object)actualAllowOnlyVisualChange);
        Assert.assertEquals((Object)expectedTypeRef.getLocalPart(), (Object)actualTypeRef.getLocalPart());
        Assert.assertEquals((Object)expectedTypeRef.getPrefix(), (Object)actualTypeRef.getPrefix());
        Assert.assertEquals((Object)expectedTypeRef.getNamespaceURI(), (Object)actualTypeRef.getNamespaceURI());
    }

    @Test
    public void testSetItemComponent() {
        String id = "id";
        String name = "name";
        String typeLanguage = "typeLanguage";
        boolean isCollection = true;
        boolean isOnlyVisualChanges = false;
        String description = "description";
        ItemDefinition expectedWbChild = new ItemDefinition(new Id("id"), new Description("description"), new Name("name"), null, null, null, "typeLanguage", Boolean.valueOf(true), Boolean.valueOf(false));
        ItemDefinition wb = new ItemDefinition();
        org.kie.dmn.model.api.ItemDefinition dmn = (org.kie.dmn.model.api.ItemDefinition)Mockito.mock(org.kie.dmn.model.api.ItemDefinition.class);
        org.kie.dmn.model.api.ItemDefinition dmnChild = (org.kie.dmn.model.api.ItemDefinition)Mockito.mock(org.kie.dmn.model.api.ItemDefinition.class);
        Mockito.when((Object)dmnChild.getId()).thenReturn((Object)"id");
        Mockito.when((Object)dmnChild.getName()).thenReturn((Object)"name");
        Mockito.when((Object)dmnChild.getTypeLanguage()).thenReturn((Object)"typeLanguage");
        Mockito.when((Object)dmnChild.isIsCollection()).thenReturn((Object)true);
        Mockito.when((Object)dmnChild.getDescription()).thenReturn((Object)"description");
        Mockito.when((Object)dmnChild.getTypeRef()).thenReturn(null);
        Mockito.when((Object)dmn.getItemComponent()).thenReturn(Collections.singletonList(dmnChild));
        ItemDefinitionPropertyConverter.setItemComponent((ItemDefinition)wb, (org.kie.dmn.model.api.ItemDefinition)dmn);
        List<ItemDefinition> expectedItemDefinitions = Collections.singletonList(expectedWbChild);
        List actualItemDefinitions = wb.getItemComponent();
        Assert.assertEquals(expectedItemDefinitions, (Object)actualItemDefinitions);
        Assert.assertEquals((Object)wb, (Object)((ItemDefinition)actualItemDefinitions.get(0)).getParent());
    }

    @Test
    public void testSetUnaryTestsWhenUnaryTestsIsNotNull() {
        ItemDefinition wb = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ArgumentCaptor argument = ArgumentCaptor.forClass(UnaryTests.class);
        org.kie.dmn.model.api.ItemDefinition dmn = (org.kie.dmn.model.api.ItemDefinition)Mockito.mock(org.kie.dmn.model.api.ItemDefinition.class);
        org.kie.dmn.model.api.UnaryTests dmnAllowedValues = (org.kie.dmn.model.api.UnaryTests)Mockito.mock(org.kie.dmn.model.api.UnaryTests.class);
        Mockito.when((Object)dmn.getAllowedValues()).thenReturn((Object)dmnAllowedValues);
        ItemDefinitionPropertyConverter.setUnaryTests((ItemDefinition)wb, (org.kie.dmn.model.api.ItemDefinition)dmn);
        ((ItemDefinition)Mockito.verify((Object)wb)).setAllowedValues((UnaryTests)argument.capture());
        Assert.assertEquals((Object)wb, (Object)((UnaryTests)argument.getValue()).getParent());
    }

    @Test
    public void testSetUnaryTestsWhenUnaryTestsIsNull() {
        ItemDefinition wb = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        UnaryTests wbAllowedValues = (UnaryTests)Mockito.mock(UnaryTests.class);
        org.kie.dmn.model.api.ItemDefinition dmn = (org.kie.dmn.model.api.ItemDefinition)Mockito.mock(org.kie.dmn.model.api.ItemDefinition.class);
        Object dmnAllowedValues = null;
        Mockito.when((Object)dmn.getAllowedValues()).thenReturn(dmnAllowedValues);
        ItemDefinitionPropertyConverter.setUnaryTests((ItemDefinition)wb, (org.kie.dmn.model.api.ItemDefinition)dmn);
        ((ItemDefinition)Mockito.verify((Object)wb, (VerificationMode)Mockito.never())).setAllowedValues(wbAllowedValues);
        ((UnaryTests)Mockito.verify((Object)wbAllowedValues, (VerificationMode)Mockito.never())).setParent((DMNModelInstrumentedBase)wb);
    }

    @Test
    public void testWbDescriptionFromDMN() {
        String description = "description";
        Description expectedDescription = new Description("description");
        org.kie.dmn.model.api.ItemDefinition dmn = (org.kie.dmn.model.api.ItemDefinition)Mockito.mock(org.kie.dmn.model.api.ItemDefinition.class);
        Mockito.when((Object)dmn.getDescription()).thenReturn((Object)"description");
        Description actualDescription = ItemDefinitionPropertyConverter.wbDescriptionFromDMN((org.kie.dmn.model.api.ItemDefinition)dmn);
        Assert.assertEquals((Object)expectedDescription, (Object)actualDescription);
    }

    @Test
    public void testWbTypeRefFromDMNWhenQNameIsUndefined() {
        org.kie.dmn.model.api.ItemDefinition dmn = (org.kie.dmn.model.api.ItemDefinition)Mockito.mock(org.kie.dmn.model.api.ItemDefinition.class);
        Object dmnQName = null;
        Mockito.when((Object)dmn.getTypeRef()).thenReturn(dmnQName);
        QName actualQName = ItemDefinitionPropertyConverter.wbTypeRefFromDMN((org.kie.dmn.model.api.ItemDefinition)dmn);
        Assert.assertNull((Object)actualQName);
    }

    @Test
    public void testWbTypeRefFromDMNWhenQNameIsNotUndefined() {
        String qNameLocalPart = "string";
        String qNamePrefix = "qName prefix";
        org.kie.dmn.model.api.ItemDefinition dmn = (org.kie.dmn.model.api.ItemDefinition)Mockito.mock(org.kie.dmn.model.api.ItemDefinition.class);
        javax.xml.namespace.QName dmnQName = (javax.xml.namespace.QName)Mockito.mock(javax.xml.namespace.QName.class);
        QName expectedQName = BuiltInType.STRING.asQName();
        Mockito.when((Object)dmn.getTypeRef()).thenReturn((Object)dmnQName);
        Mockito.when((Object)dmnQName.getLocalPart()).thenReturn((Object)"string");
        Mockito.when((Object)dmnQName.getPrefix()).thenReturn((Object)"qName prefix");
        QName actualQName = ItemDefinitionPropertyConverter.wbTypeRefFromDMN((org.kie.dmn.model.api.ItemDefinition)dmn);
        Assert.assertEquals((Object)actualQName, (Object)expectedQName);
    }

    @Test
    public void testWbChildFromDMNWhenWbChildIsNotNull() {
        String id = "id";
        String name = "name";
        String typeLanguage = "typeLanguage";
        boolean isCollection = true;
        boolean isOnlyVisualChanges = false;
        String description = "description";
        ItemDefinition expectedWbParent = new ItemDefinition();
        ItemDefinition expectedWbChild = new ItemDefinition(new Id("id"), new Description("description"), new Name("name"), null, null, null, "typeLanguage", Boolean.valueOf(true), Boolean.valueOf(false));
        org.kie.dmn.model.api.ItemDefinition dmnChild = (org.kie.dmn.model.api.ItemDefinition)Mockito.mock(org.kie.dmn.model.api.ItemDefinition.class);
        Mockito.when((Object)dmnChild.getId()).thenReturn((Object)"id");
        Mockito.when((Object)dmnChild.getName()).thenReturn((Object)"name");
        Mockito.when((Object)dmnChild.getTypeLanguage()).thenReturn((Object)"typeLanguage");
        Mockito.when((Object)dmnChild.isIsCollection()).thenReturn((Object)true);
        Mockito.when((Object)dmnChild.getDescription()).thenReturn((Object)"description");
        Mockito.when((Object)dmnChild.getTypeRef()).thenReturn(null);
        ItemDefinition actualWbChild = ItemDefinitionPropertyConverter.wbChildFromDMN((ItemDefinition)expectedWbParent, (org.kie.dmn.model.api.ItemDefinition)dmnChild);
        ItemDefinition actualParent = (ItemDefinition)actualWbChild.getParent();
        Assert.assertEquals((Object)expectedWbChild, (Object)actualWbChild);
        Assert.assertEquals((Object)expectedWbParent, (Object)actualParent);
    }

    @Test
    public void testWbChildFromDMNWhenWbChildIsNull() {
        ItemDefinition expectedWbParent = new ItemDefinition();
        org.kie.dmn.model.api.ItemDefinition dmnChild = null;
        ItemDefinition actualWbChild = ItemDefinitionPropertyConverter.wbChildFromDMN((ItemDefinition)expectedWbParent, dmnChild);
        Assert.assertNull((Object)actualWbChild);
    }

    @After
    public void validate() {
        Mockito.validateMockitoUsage();
    }
}

