/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.model.api.DecisionTable;
import org.kie.dmn.model.api.OutputClause;
import org.kie.dmn.model.v1_2.TDecisionTable;
import org.kie.dmn.model.v1_2.TOutputClause;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.backend.definition.v1_1.DecisionTablePropertyConverter;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DecisionTablePropertyConverterTest {
    private static final String UUID = "uuid";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String QNAME_LOCALPART = "local-part";

    @Test
    public void testWBFromDMNSingleOutputClauseTypeRef() {
        TDecisionTable dmn = new TDecisionTable();
        TOutputClause dmnOutputClause1 = new TOutputClause();
        dmn.setId(UUID);
        dmn.setDescription(DESCRIPTION);
        dmn.setTypeRef(new javax.xml.namespace.QName(QNAME_LOCALPART));
        dmnOutputClause1.setName(NAME);
        dmnOutputClause1.setTypeRef(new javax.xml.namespace.QName("local-part-oc1"));
        dmn.getOutput().add(dmnOutputClause1);
        org.kie.workbench.common.dmn.api.definition.model.DecisionTable wb = DecisionTablePropertyConverter.wbFromDMN((DecisionTable)dmn);
        Assertions.assertThat((Object)wb).isNotNull();
        Assertions.assertThat((Object)wb.getId()).isNotNull();
        Assertions.assertThat((String)wb.getId().getValue()).isEqualTo(UUID);
        Assertions.assertThat((Object)wb.getDescription()).isNotNull();
        Assertions.assertThat((String)wb.getDescription().getValue()).isEqualTo(DESCRIPTION);
        Assertions.assertThat((Object)wb.getTypeRef()).isNotNull();
        Assertions.assertThat((String)wb.getTypeRef().getLocalPart()).isEqualTo(QNAME_LOCALPART);
        Assertions.assertThat((List)wb.getOutput()).hasSize(1);
        org.kie.workbench.common.dmn.api.definition.model.OutputClause wbOutputClause1 = (org.kie.workbench.common.dmn.api.definition.model.OutputClause)wb.getOutput().get(0);
        Assertions.assertThat((String)wbOutputClause1.getName()).isNull();
        Assertions.assertThat((Object)wbOutputClause1.getTypeRef()).isNull();
    }

    @Test
    public void testWBFromDMNMultipleOutputClauseTypeRef() {
        TDecisionTable dmn = new TDecisionTable();
        TOutputClause dmnOutputClause1 = new TOutputClause();
        TOutputClause dmnOutputClause2 = new TOutputClause();
        dmn.setId(UUID);
        dmn.setDescription(DESCRIPTION);
        dmn.setTypeRef(new javax.xml.namespace.QName(QNAME_LOCALPART));
        dmnOutputClause1.setName("name-oc1");
        dmnOutputClause2.setName("name-oc2");
        dmnOutputClause1.setTypeRef(new javax.xml.namespace.QName("local-part-oc1"));
        dmnOutputClause2.setTypeRef(new javax.xml.namespace.QName("local-part-oc2"));
        dmn.getOutput().add(dmnOutputClause1);
        dmn.getOutput().add(dmnOutputClause2);
        org.kie.workbench.common.dmn.api.definition.model.DecisionTable wb = DecisionTablePropertyConverter.wbFromDMN((DecisionTable)dmn);
        Assertions.assertThat((Object)wb).isNotNull();
        Assertions.assertThat((Object)wb.getId()).isNotNull();
        Assertions.assertThat((String)wb.getId().getValue()).isEqualTo(UUID);
        Assertions.assertThat((Object)wb.getDescription()).isNotNull();
        Assertions.assertThat((String)wb.getDescription().getValue()).isEqualTo(DESCRIPTION);
        Assertions.assertThat((Object)wb.getTypeRef()).isNotNull();
        Assertions.assertThat((String)wb.getTypeRef().getLocalPart()).isEqualTo(QNAME_LOCALPART);
        Assertions.assertThat((List)wb.getOutput()).hasSize(2);
        org.kie.workbench.common.dmn.api.definition.model.OutputClause wbOutputClause1 = (org.kie.workbench.common.dmn.api.definition.model.OutputClause)wb.getOutput().get(0);
        org.kie.workbench.common.dmn.api.definition.model.OutputClause wbOutputClause2 = (org.kie.workbench.common.dmn.api.definition.model.OutputClause)wb.getOutput().get(1);
        Assertions.assertThat((String)wbOutputClause1.getName()).isEqualTo("name-oc1");
        Assertions.assertThat((String)wbOutputClause2.getName()).isEqualTo("name-oc2");
        Assertions.assertThat((String)wbOutputClause1.getTypeRef().getLocalPart()).isEqualTo("local-part-oc1");
        Assertions.assertThat((String)wbOutputClause2.getTypeRef().getLocalPart()).isEqualTo("local-part-oc2");
    }

    @Test
    public void testDMNFromWBSingleOutputClauseTypeRef() {
        org.kie.workbench.common.dmn.api.definition.model.DecisionTable wb = new org.kie.workbench.common.dmn.api.definition.model.DecisionTable();
        org.kie.workbench.common.dmn.api.definition.model.OutputClause outputClause1 = new org.kie.workbench.common.dmn.api.definition.model.OutputClause();
        wb.getId().setValue(UUID);
        wb.getDescription().setValue(DESCRIPTION);
        wb.setTypeRef(new QName("", QNAME_LOCALPART));
        outputClause1.setName(NAME);
        outputClause1.setTypeRef(new QName("", "local-part-oc1"));
        wb.getOutput().add(outputClause1);
        DecisionTable dmn = DecisionTablePropertyConverter.dmnFromWB((org.kie.workbench.common.dmn.api.definition.model.DecisionTable)wb);
        Assertions.assertThat((Object)dmn).isNotNull();
        Assertions.assertThat((String)dmn.getId()).isNotNull();
        Assertions.assertThat((String)dmn.getId()).isEqualTo(UUID);
        Assertions.assertThat((String)dmn.getDescription()).isNotNull();
        Assertions.assertThat((String)dmn.getDescription()).isEqualTo(DESCRIPTION);
        Assertions.assertThat((Object)dmn.getTypeRef()).isNotNull();
        Assertions.assertThat((String)dmn.getTypeRef().getLocalPart()).isEqualTo(QNAME_LOCALPART);
        Assertions.assertThat((List)dmn.getOutput()).hasSize(1);
        OutputClause dmnOutputClause1 = (OutputClause)dmn.getOutput().get(0);
        Assertions.assertThat((String)dmnOutputClause1.getName()).isNull();
        Assertions.assertThat((Object)dmnOutputClause1.getTypeRef()).isNull();
    }

    @Test
    public void testDMNFromWBMultipleOutputClauseTypeRef() {
        org.kie.workbench.common.dmn.api.definition.model.DecisionTable wb = new org.kie.workbench.common.dmn.api.definition.model.DecisionTable();
        org.kie.workbench.common.dmn.api.definition.model.OutputClause wbOutputClause1 = new org.kie.workbench.common.dmn.api.definition.model.OutputClause();
        org.kie.workbench.common.dmn.api.definition.model.OutputClause wbOutputClause2 = new org.kie.workbench.common.dmn.api.definition.model.OutputClause();
        wb.getId().setValue(UUID);
        wb.getDescription().setValue(DESCRIPTION);
        wb.setTypeRef(new QName("", QNAME_LOCALPART));
        wbOutputClause1.setName("name-oc1");
        wbOutputClause2.setName("name-oc2");
        wbOutputClause1.setTypeRef(new QName("", "local-part-oc1"));
        wbOutputClause2.setTypeRef(new QName("", "local-part-oc2"));
        wb.getOutput().add(wbOutputClause1);
        wb.getOutput().add(wbOutputClause2);
        DecisionTable dmn = DecisionTablePropertyConverter.dmnFromWB((org.kie.workbench.common.dmn.api.definition.model.DecisionTable)wb);
        Assertions.assertThat((Object)dmn).isNotNull();
        Assertions.assertThat((String)dmn.getId()).isNotNull();
        Assertions.assertThat((String)dmn.getId()).isEqualTo(UUID);
        Assertions.assertThat((String)dmn.getDescription()).isNotNull();
        Assertions.assertThat((String)dmn.getDescription()).isEqualTo(DESCRIPTION);
        Assertions.assertThat((Object)dmn.getTypeRef()).isNotNull();
        Assertions.assertThat((String)dmn.getTypeRef().getLocalPart()).isEqualTo(QNAME_LOCALPART);
        Assertions.assertThat((List)dmn.getOutput()).hasSize(2);
        OutputClause dmnOutputClause1 = (OutputClause)dmn.getOutput().get(0);
        OutputClause dmnOutputClause2 = (OutputClause)dmn.getOutput().get(1);
        Assertions.assertThat((String)dmnOutputClause1.getName()).isEqualTo("name-oc1");
        Assertions.assertThat((String)dmnOutputClause2.getName()).isEqualTo("name-oc2");
        Assertions.assertThat((String)dmnOutputClause1.getTypeRef().getLocalPart()).isEqualTo("local-part-oc1");
        Assertions.assertThat((String)dmnOutputClause2.getTypeRef().getLocalPart()).isEqualTo("local-part-oc2");
    }
}

