/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.model.api.Relation;
import org.kie.dmn.model.v1_2.TInformationItem;
import org.kie.dmn.model.v1_2.TList;
import org.kie.dmn.model.v1_2.TLiteralExpression;
import org.kie.dmn.model.v1_2.TRelation;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.backend.definition.v1_1.RelationPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.ComponentWidths;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RelationPropertyConverterTest {
    private static final String RELATION_UUID = "r-uuid";
    private static final String RELATION_DESCRIPTION = "r-description";
    private static final String RELATION_QNAME_LOCALPART = "r-local";
    private static final String EXPRESSION_UUID = "uuid";
    @Mock
    private BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer;
    @Mock
    private Consumer<ComponentWidths> componentWidthsConsumer;
    @Captor
    private ArgumentCaptor<HasComponentWidths> hasComponentWidthsCaptor;
    @Captor
    private ArgumentCaptor<ComponentWidths> componentWidthsCaptor;

    @Test
    public void testWBFromDMN() {
        TRelation dmn = new TRelation();
        TInformationItem informationItem = new TInformationItem();
        TList list = new TList();
        TLiteralExpression literalExpression = new TLiteralExpression();
        literalExpression.setId(EXPRESSION_UUID);
        list.getExpression().add(literalExpression);
        dmn.setId(RELATION_UUID);
        dmn.setDescription(RELATION_DESCRIPTION);
        dmn.setTypeRef(new javax.xml.namespace.QName(RELATION_QNAME_LOCALPART));
        dmn.getColumn().add(informationItem);
        dmn.getRow().add(list);
        org.kie.workbench.common.dmn.api.definition.model.Relation wb = RelationPropertyConverter.wbFromDMN((Relation)dmn, this.hasComponentWidthsConsumer);
        Assertions.assertThat((Object)wb).isNotNull();
        Assertions.assertThat((Object)wb.getId()).isNotNull();
        Assertions.assertThat((String)wb.getId().getValue()).isEqualTo(RELATION_UUID);
        Assertions.assertThat((Object)wb.getDescription()).isNotNull();
        Assertions.assertThat((String)wb.getDescription().getValue()).isEqualTo(RELATION_DESCRIPTION);
        Assertions.assertThat((Object)wb.getTypeRef()).isNotNull();
        Assertions.assertThat((String)wb.getTypeRef().getLocalPart()).isEqualTo(RELATION_QNAME_LOCALPART);
        Assertions.assertThat((List)wb.getColumn()).isNotNull();
        Assertions.assertThat((int)wb.getColumn().size()).isEqualTo(1);
        Assertions.assertThat(wb.getColumn().get(0)).isNotNull();
        Assertions.assertThat((List)wb.getRow()).isNotNull();
        Assertions.assertThat((int)wb.getRow().size()).isEqualTo(1);
        Assertions.assertThat(wb.getRow().get(0)).isNotNull();
        Assertions.assertThat((List)((org.kie.workbench.common.dmn.api.definition.model.List)wb.getRow().get(0)).getExpression()).isNotNull();
        Assertions.assertThat((int)((org.kie.workbench.common.dmn.api.definition.model.List)wb.getRow().get(0)).getExpression().size()).isEqualTo(1);
        Assertions.assertThat((String)((HasExpression)((org.kie.workbench.common.dmn.api.definition.model.List)wb.getRow().get(0)).getExpression().get(0)).getExpression().getId().getValue()).isEqualTo(EXPRESSION_UUID);
        ((BiConsumer)Mockito.verify(this.hasComponentWidthsConsumer)).accept(Matchers.eq((Object)EXPRESSION_UUID), this.hasComponentWidthsCaptor.capture());
        HasComponentWidths hasComponentWidths = (HasComponentWidths)this.hasComponentWidthsCaptor.getValue();
        Assertions.assertThat((Object)hasComponentWidths).isNotNull();
        Assertions.assertThat((Object)hasComponentWidths).isEqualTo((Object)((HasExpression)((org.kie.workbench.common.dmn.api.definition.model.List)wb.getRow().get(0)).getExpression().get(0)).getExpression());
    }

    @Test
    public void testDMNFromWB() {
        org.kie.workbench.common.dmn.api.definition.model.Relation wb = new org.kie.workbench.common.dmn.api.definition.model.Relation();
        InformationItem informationItem = new InformationItem();
        org.kie.workbench.common.dmn.api.definition.model.List list = new org.kie.workbench.common.dmn.api.definition.model.List();
        LiteralExpression literalExpression = new LiteralExpression();
        HasExpression hasExpression = HasExpression.wrap((DMNModelInstrumentedBase)wb, (Expression)literalExpression);
        literalExpression.getComponentWidths().set(0, 200.0);
        literalExpression.getId().setValue(EXPRESSION_UUID);
        list.getExpression().add(hasExpression);
        wb.getId().setValue(RELATION_UUID);
        wb.getDescription().setValue(RELATION_DESCRIPTION);
        wb.setTypeRef(new QName("", RELATION_QNAME_LOCALPART));
        wb.getColumn().add(informationItem);
        wb.getRow().add(list);
        Relation dmn = RelationPropertyConverter.dmnFromWB((org.kie.workbench.common.dmn.api.definition.model.Relation)wb, this.componentWidthsConsumer);
        Assertions.assertThat((Object)dmn).isNotNull();
        Assertions.assertThat((String)dmn.getId()).isNotNull();
        Assertions.assertThat((String)dmn.getId()).isEqualTo(RELATION_UUID);
        Assertions.assertThat((String)dmn.getDescription()).isNotNull();
        Assertions.assertThat((String)dmn.getDescription()).isEqualTo(RELATION_DESCRIPTION);
        Assertions.assertThat((Object)dmn.getTypeRef()).isNotNull();
        Assertions.assertThat((String)dmn.getTypeRef().getLocalPart()).isEqualTo(RELATION_QNAME_LOCALPART);
        Assertions.assertThat((List)dmn.getColumn()).isNotNull();
        Assertions.assertThat((int)dmn.getColumn().size()).isEqualTo(1);
        Assertions.assertThat(dmn.getColumn().get(0)).isNotNull();
        Assertions.assertThat((List)dmn.getRow()).isNotNull();
        Assertions.assertThat((int)dmn.getRow().size()).isEqualTo(1);
        Assertions.assertThat(dmn.getRow().get(0)).isNotNull();
        Assertions.assertThat((List)((org.kie.dmn.model.api.List)dmn.getRow().get(0)).getExpression()).isNotNull();
        Assertions.assertThat((int)((org.kie.dmn.model.api.List)dmn.getRow().get(0)).getExpression().size()).isEqualTo(1);
        Assertions.assertThat((String)((org.kie.dmn.model.api.Expression)((org.kie.dmn.model.api.List)dmn.getRow().get(0)).getExpression().get(0)).getId()).isEqualTo(EXPRESSION_UUID);
        ((Consumer)Mockito.verify(this.componentWidthsConsumer)).accept(this.componentWidthsCaptor.capture());
        ComponentWidths componentWidths = (ComponentWidths)this.componentWidthsCaptor.getValue();
        Assertions.assertThat((Object)componentWidths).isNotNull();
        Assertions.assertThat((String)componentWidths.getDmnElementRef().getLocalPart()).isEqualTo(EXPRESSION_UUID);
        Assertions.assertThat((int)componentWidths.getWidths().size()).isEqualTo(literalExpression.getRequiredComponentWidthCount());
        Assertions.assertThat((Double)((Double)componentWidths.getWidths().get(0))).isEqualTo(200.0);
    }
}

