/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.Map;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.ConstraintType;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.IsUnaryTests;
import org.kie.workbench.common.dmn.api.definition.model.UnaryTests;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.backend.definition.v1_1.UnaryTestsPropertyConverter;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class UnaryTestsPropertyConverterTest {
    private static final String ID = "thisId";
    private static final String TEXT = "1,2,3";
    private static final String DESCRIPTION = "description";
    private static final String EXPRESSION_LANGUAGE = "FEEL";
    private static final QName CONSTRAINT_KEY = new QName(DMNModelInstrumentedBase.Namespace.KIE.getUri(), "constraintType", DMNModelInstrumentedBase.Namespace.KIE.getPrefix());
    @Mock
    private IsUnaryTests wbUnaryTests;
    @Mock
    private org.kie.dmn.model.api.UnaryTests dmnUnary;
    @Mock
    private Map<QName, String> additionalAttributes;

    @Before
    public void setup() {
        Mockito.when((Object)this.dmnUnary.getId()).thenReturn((Object)ID);
        Mockito.when((Object)this.dmnUnary.getAdditionalAttributes()).thenReturn(this.additionalAttributes);
        Mockito.when((Object)this.dmnUnary.getText()).thenReturn((Object)TEXT);
        Mockito.when((Object)this.dmnUnary.getDescription()).thenReturn((Object)DESCRIPTION);
        Mockito.when((Object)this.dmnUnary.getExpressionLanguage()).thenReturn((Object)EXPRESSION_LANGUAGE);
        Mockito.when((Object)this.additionalAttributes.containsKey(CONSTRAINT_KEY)).thenReturn((Object)true);
        Mockito.when((Object)this.wbUnaryTests.getId()).thenReturn((Object)new Id(ID));
        Mockito.when((Object)this.wbUnaryTests.getText()).thenReturn((Object)new Text(TEXT));
    }

    @Test
    public void testWbFromDMNEnumeration() {
        this.testWbFromDMN(ConstraintType.ENUMERATION);
    }

    @Test
    public void testWbFromDMNRange() {
        this.testWbFromDMN(ConstraintType.RANGE);
    }

    @Test
    public void testWbFromDMNExpression() {
        this.testWbFromDMN(ConstraintType.EXPRESSION);
    }

    @Test
    public void testDmnFromWBEnumeration() {
        this.testDmnFromWB(ConstraintType.ENUMERATION);
    }

    @Test
    public void testDmnFromWBRange() {
        this.testDmnFromWB(ConstraintType.RANGE);
    }

    @Test
    public void testDmnFromWBExpression() {
        this.testDmnFromWB(ConstraintType.EXPRESSION);
    }

    public void testWbFromDMN(ConstraintType constraintType) {
        Mockito.when((Object)this.additionalAttributes.get(CONSTRAINT_KEY)).thenReturn((Object)constraintType.value());
        UnaryTests unaryTests = UnaryTestsPropertyConverter.wbFromDMN((org.kie.dmn.model.api.UnaryTests)this.dmnUnary);
        Assert.assertEquals((Object)ID, (Object)unaryTests.getId().getValue());
        Assert.assertEquals((Object)DESCRIPTION, (Object)unaryTests.getDescription().getValue());
        Assert.assertEquals((Object)TEXT, (Object)unaryTests.getText().getValue());
        Assert.assertEquals((Object)EXPRESSION_LANGUAGE, (Object)unaryTests.getExpressionLanguage().getValue());
        Assert.assertEquals((Object)constraintType, (Object)unaryTests.getConstraintType());
    }

    public void testDmnFromWB(ConstraintType constraintType) {
        Mockito.when((Object)this.wbUnaryTests.getConstraintType()).thenReturn((Object)constraintType);
        org.kie.dmn.model.api.UnaryTests unaryTests = UnaryTestsPropertyConverter.dmnFromWB((IsUnaryTests)this.wbUnaryTests);
        Assert.assertEquals((Object)ID, (Object)unaryTests.getId());
        Assert.assertEquals((Object)TEXT, (Object)unaryTests.getText());
        Assert.assertEquals((Object)constraintType.value(), unaryTests.getAdditionalAttributes().get(CONSTRAINT_KEY));
    }
}

