/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.model.api.InformationItem;
import org.kie.dmn.model.v1_2.TDecisionService;
import org.kie.dmn.model.v1_2.TInformationItem;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.backend.definition.v1_1.DecisionServiceConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.ComponentWidths;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.core.util.UUID;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DecisionServiceConverterTest {
    private static final String DECISION_SERVICE_UUID = "ds-uuid";
    private static final String DECISION_SERVICE_NAME = "ds-name";
    private static final String DECISION_SERVICE_DESCRIPTION = "ds-description";
    @Mock
    private BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer;
    @Mock
    private Consumer<ComponentWidths> componentWidthsConsumer;
    @Mock
    private FactoryManager factoryManager;
    @Mock
    private Element element;
    private DecisionServiceConverter converter;

    @Before
    public void setup() {
        this.converter = new DecisionServiceConverter(this.factoryManager);
    }

    @Test
    public void testWBFromDMN() {
        NodeImpl factoryNode = new NodeImpl(UUID.uuid());
        ViewImpl view = new ViewImpl((Object)new DecisionService(), Bounds.create());
        factoryNode.setContent((Object)view);
        Mockito.when((Object)this.factoryManager.newElement(Matchers.anyString(), (String)Matchers.eq((Object)BindableAdapterUtils.getDefinitionId(DecisionService.class)))).thenReturn((Object)this.element);
        Mockito.when((Object)this.element.asNode()).thenReturn((Object)factoryNode);
        TDecisionService dmn = new TDecisionService();
        TInformationItem informationItem = new TInformationItem();
        dmn.setId(DECISION_SERVICE_UUID);
        dmn.setName(DECISION_SERVICE_NAME);
        dmn.setDescription(DECISION_SERVICE_DESCRIPTION);
        dmn.setVariable((InformationItem)informationItem);
        Node node = this.converter.nodeFromDMN((org.kie.dmn.model.api.DecisionService)dmn, this.hasComponentWidthsConsumer);
        DecisionService wb = (DecisionService)DefinitionUtils.getElementDefinition((Element)node);
        Assertions.assertThat((Object)wb).isNotNull();
        Assertions.assertThat((Object)wb.getId()).isNotNull();
        Assertions.assertThat((String)wb.getId().getValue()).isEqualTo(DECISION_SERVICE_UUID);
        Assertions.assertThat((Object)wb.getName()).isNotNull();
        Assertions.assertThat((String)wb.getName().getValue()).isEqualTo(DECISION_SERVICE_NAME);
        Assertions.assertThat((Object)wb.getDescription()).isNotNull();
        Assertions.assertThat((String)wb.getDescription().getValue()).isEqualTo(DECISION_SERVICE_DESCRIPTION);
        Assertions.assertThat((Object)wb.getVariable()).isNotNull();
        Assertions.assertThat((String)wb.getVariable().getName().getValue()).isEqualTo(DECISION_SERVICE_NAME);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.hasComponentWidthsConsumer});
    }

    @Test
    public void testDMNFromWB() {
        DecisionService wb = new DecisionService();
        InformationItemPrimary informationItem = new InformationItemPrimary();
        wb.getId().setValue(DECISION_SERVICE_UUID);
        wb.getName().setValue(DECISION_SERVICE_NAME);
        wb.getDescription().setValue(DECISION_SERVICE_DESCRIPTION);
        wb.setVariable(informationItem);
        NodeImpl node = new NodeImpl(UUID.uuid());
        ViewImpl view = new ViewImpl((Object)wb, Bounds.create());
        node.setContent((Object)view);
        org.kie.dmn.model.api.DecisionService dmn = this.converter.dmnFromNode((Node)node, this.componentWidthsConsumer);
        Assertions.assertThat((Object)dmn).isNotNull();
        Assertions.assertThat((String)dmn.getId()).isNotNull();
        Assertions.assertThat((String)dmn.getId()).isEqualTo(DECISION_SERVICE_UUID);
        Assertions.assertThat((String)dmn.getName()).isNotNull();
        Assertions.assertThat((String)dmn.getName()).isEqualTo(DECISION_SERVICE_NAME);
        Assertions.assertThat((String)dmn.getDescription()).isNotNull();
        Assertions.assertThat((String)dmn.getDescription()).isEqualTo(DECISION_SERVICE_DESCRIPTION);
        Assertions.assertThat((Object)dmn.getVariable()).isNotNull();
        Assertions.assertThat((String)dmn.getVariable().getName()).isEqualTo(DECISION_SERVICE_NAME);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.componentWidthsConsumer});
    }
}

