/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.model.api.FunctionKind;
import org.kie.dmn.model.api.InformationItem;
import org.kie.dmn.model.v1_2.TContext;
import org.kie.dmn.model.v1_2.TContextEntry;
import org.kie.dmn.model.v1_2.TFunctionDefinition;
import org.kie.dmn.model.v1_2.TInformationItem;
import org.kie.dmn.model.v1_2.TLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.model.Context;
import org.kie.workbench.common.dmn.api.definition.model.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.model.IsLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocument;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocumentModel;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.backend.definition.v1_1.FunctionDefinitionPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.ComponentWidths;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class FunctionDefinitionPropertyConverterTest {
    private static final String FUNCTION_DEFINITION_UUID = "fd-uuid";
    private static final String FUNCTION_DEFINITION_DESCRIPTION = "fd-description";
    private static final String FUNCTION_DEFINITION_QNAME_LOCALPART = "fd-local";
    private static final String EXPRESSION_UUID = "uuid";
    @Mock
    private BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer;
    @Mock
    private Consumer<ComponentWidths> componentWidthsConsumer;
    @Captor
    private ArgumentCaptor<HasComponentWidths> hasComponentWidthsCaptor;
    @Captor
    private ArgumentCaptor<ComponentWidths> componentWidthsCaptor;

    @Test
    public void testWBFromDMN() {
        TFunctionDefinition dmn = new TFunctionDefinition();
        TLiteralExpression literalExpression = new TLiteralExpression();
        literalExpression.setId(EXPRESSION_UUID);
        dmn.setId(FUNCTION_DEFINITION_UUID);
        dmn.setDescription(FUNCTION_DEFINITION_DESCRIPTION);
        dmn.setTypeRef(new javax.xml.namespace.QName(FUNCTION_DEFINITION_QNAME_LOCALPART));
        dmn.setKind(FunctionKind.JAVA);
        dmn.setExpression((org.kie.dmn.model.api.Expression)literalExpression);
        FunctionDefinition wb = FunctionDefinitionPropertyConverter.wbFromDMN((org.kie.dmn.model.api.FunctionDefinition)dmn, this.hasComponentWidthsConsumer);
        Assertions.assertThat((Object)wb).isNotNull();
        Assertions.assertThat((Object)wb.getId()).isNotNull();
        Assertions.assertThat((String)wb.getId().getValue()).isEqualTo(FUNCTION_DEFINITION_UUID);
        Assertions.assertThat((Object)wb.getDescription()).isNotNull();
        Assertions.assertThat((String)wb.getDescription().getValue()).isEqualTo(FUNCTION_DEFINITION_DESCRIPTION);
        Assertions.assertThat((Object)wb.getTypeRef()).isNotNull();
        Assertions.assertThat((String)wb.getTypeRef().getLocalPart()).isEqualTo(FUNCTION_DEFINITION_QNAME_LOCALPART);
        Assertions.assertThat((Comparable)wb.getKind()).isNotNull();
        Assertions.assertThat((Comparable)wb.getKind()).isEqualTo((Object)FunctionDefinition.Kind.JAVA);
        Assertions.assertThat((Object)wb.getExpression()).isNotNull();
        Assertions.assertThat((String)wb.getExpression().getId().getValue()).isEqualTo(EXPRESSION_UUID);
        ((BiConsumer)Mockito.verify(this.hasComponentWidthsConsumer)).accept(Matchers.eq((Object)EXPRESSION_UUID), this.hasComponentWidthsCaptor.capture());
        HasComponentWidths hasComponentWidths = (HasComponentWidths)this.hasComponentWidthsCaptor.getValue();
        Assertions.assertThat((Object)hasComponentWidths).isNotNull();
        Assertions.assertThat((Object)hasComponentWidths).isEqualTo((Object)wb.getExpression());
    }

    @Test
    public void testWBFromDMNWithJavaContext() {
        this.doTestWBFromDMNWithContextEntry(FunctionKind.JAVA, "cheese", LiteralExpression.class);
    }

    @Test
    public void testWBFromDMNWithPMMLContextDocumentEntry() {
        this.doTestWBFromDMNWithContextEntry(FunctionKind.PMML, "document", LiteralExpressionPMMLDocument.class);
    }

    @Test
    public void testWBFromDMNWithPMMLContextDocumentModelEntry() {
        this.doTestWBFromDMNWithContextEntry(FunctionKind.PMML, "model", LiteralExpressionPMMLDocumentModel.class);
    }

    private void doTestWBFromDMNWithContextEntry(FunctionKind kind, String variableName, Class<? extends IsLiteralExpression> literalExpressionClass) {
        TFunctionDefinition dmn = new TFunctionDefinition();
        TContext contextExpression = new TContext();
        TContextEntry contextEntry = new TContextEntry();
        TInformationItem variable = new TInformationItem();
        variable.setName(variableName);
        contextEntry.setVariable((InformationItem)variable);
        contextEntry.setExpression((org.kie.dmn.model.api.Expression)new TLiteralExpression());
        contextExpression.getContextEntry().add(contextEntry);
        dmn.setKind(kind);
        dmn.setExpression((org.kie.dmn.model.api.Expression)contextExpression);
        FunctionDefinition wb = FunctionDefinitionPropertyConverter.wbFromDMN((org.kie.dmn.model.api.FunctionDefinition)dmn, this.hasComponentWidthsConsumer);
        Assertions.assertThat((Object)wb.getExpression()).isInstanceOf(Context.class);
        Assertions.assertThat((Object)((ContextEntry)((Context)wb.getExpression()).getContextEntry().get(0)).getExpression()).isInstanceOf(literalExpressionClass);
    }

    @Test
    public void testDMNFromWB() {
        FunctionDefinition wb = new FunctionDefinition();
        LiteralExpression literalExpression = new LiteralExpression();
        literalExpression.getComponentWidths().set(0, 200.0);
        literalExpression.getId().setValue(EXPRESSION_UUID);
        wb.getId().setValue(FUNCTION_DEFINITION_UUID);
        wb.getDescription().setValue(FUNCTION_DEFINITION_DESCRIPTION);
        wb.setTypeRef(new QName("", FUNCTION_DEFINITION_QNAME_LOCALPART));
        wb.setKind(FunctionDefinition.Kind.JAVA);
        wb.setExpression((Expression)literalExpression);
        org.kie.dmn.model.api.FunctionDefinition dmn = FunctionDefinitionPropertyConverter.dmnFromWB((FunctionDefinition)wb, this.componentWidthsConsumer);
        Assertions.assertThat((Object)dmn).isNotNull();
        Assertions.assertThat((String)dmn.getId()).isNotNull();
        Assertions.assertThat((String)dmn.getId()).isEqualTo(FUNCTION_DEFINITION_UUID);
        Assertions.assertThat((String)dmn.getDescription()).isNotNull();
        Assertions.assertThat((String)dmn.getDescription()).isEqualTo(FUNCTION_DEFINITION_DESCRIPTION);
        Assertions.assertThat((Object)dmn.getTypeRef()).isNotNull();
        Assertions.assertThat((String)dmn.getTypeRef().getLocalPart()).isEqualTo(FUNCTION_DEFINITION_QNAME_LOCALPART);
        Assertions.assertThat((Comparable)dmn.getKind()).isNotNull();
        Assertions.assertThat((Comparable)dmn.getKind()).isEqualTo((Object)FunctionKind.JAVA);
        Assertions.assertThat((Object)dmn.getExpression()).isNotNull();
        Assertions.assertThat((String)dmn.getExpression().getId()).isEqualTo(EXPRESSION_UUID);
        ((Consumer)Mockito.verify(this.componentWidthsConsumer)).accept(this.componentWidthsCaptor.capture());
        ComponentWidths componentWidths = (ComponentWidths)this.componentWidthsCaptor.getValue();
        Assertions.assertThat((Object)componentWidths).isNotNull();
        Assertions.assertThat((String)componentWidths.getDmnElementRef().getLocalPart()).isEqualTo(EXPRESSION_UUID);
        Assertions.assertThat((int)componentWidths.getWidths().size()).isEqualTo(literalExpression.getRequiredComponentWidthCount());
        Assertions.assertThat((Double)((Double)componentWidths.getWidths().get(0))).isEqualTo(200.0);
    }
}

