/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.Arrays;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.model.api.DRGElement;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.Import;
import org.kie.dmn.model.api.ItemDefinition;
import org.kie.dmn.model.v1_2.TImport;
import org.kie.workbench.common.dmn.api.definition.model.ImportDMN;
import org.kie.workbench.common.dmn.api.definition.model.ImportPMML;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.editors.included.PMMLModelMetadata;
import org.kie.workbench.common.dmn.backend.definition.v1_1.ImportConverter;
import org.mockito.Mockito;

public class ImportConverterTest {
    @Test
    public void testWbFromDMNWhenGeneric() {
        TImport dmn = new TImport();
        dmn.setImportType("cheese");
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        PMMLDocumentMetadata pmmlDocument = (PMMLDocumentMetadata)Mockito.mock(PMMLDocumentMetadata.class);
        org.kie.workbench.common.dmn.api.definition.model.Import anImport = ImportConverter.wbFromDMN((Import)dmn, (Definitions)definitions, (PMMLDocumentMetadata)pmmlDocument);
        Assert.assertNotNull((Object)anImport);
    }

    @Test
    public void testWbFromDMNWhenDMNImport() {
        TImport dmn = new TImport();
        dmn.setImportType(DMNImportTypes.DMN.getDefaultNamespace());
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        PMMLDocumentMetadata pmmlDocument = (PMMLDocumentMetadata)Mockito.mock(PMMLDocumentMetadata.class);
        String key = "drools";
        String value = "http://www.drools.org/kie/dmn/1.1";
        dmn.getNsContext().put("drools", "http://www.drools.org/kie/dmn/1.1");
        Mockito.when((Object)definitions.getDrgElement()).thenReturn(Arrays.asList((DRGElement)Mockito.mock(DRGElement.class), (DRGElement)Mockito.mock(DRGElement.class)));
        Mockito.when((Object)definitions.getItemDefinition()).thenReturn(Arrays.asList((ItemDefinition)Mockito.mock(ItemDefinition.class), (ItemDefinition)Mockito.mock(ItemDefinition.class), (ItemDefinition)Mockito.mock(ItemDefinition.class)));
        org.kie.workbench.common.dmn.api.definition.model.Import anImport = ImportConverter.wbFromDMN((Import)dmn, (Definitions)definitions, (PMMLDocumentMetadata)pmmlDocument);
        Map nsContext = anImport.getNsContext();
        Assert.assertEquals((long)1L, (long)nsContext.size());
        Assert.assertEquals((Object)"http://www.drools.org/kie/dmn/1.1", nsContext.get("drools"));
        Assert.assertTrue((boolean)(anImport instanceof ImportDMN));
        ImportDMN dmnImport = (ImportDMN)anImport;
        Assert.assertEquals((long)2L, (long)dmnImport.getDrgElementsCount());
        Assert.assertEquals((long)3L, (long)dmnImport.getItemDefinitionsCount());
    }

    @Test
    public void testWbFromDMNWhenPMMLImport() {
        TImport dmn = new TImport();
        dmn.setImportType(DMNImportTypes.PMML.getDefaultNamespace());
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        PMMLDocumentMetadata pmmlDocument = (PMMLDocumentMetadata)Mockito.mock(PMMLDocumentMetadata.class);
        Mockito.when((Object)pmmlDocument.getModels()).thenReturn(Arrays.asList((PMMLModelMetadata)Mockito.mock(PMMLModelMetadata.class), (PMMLModelMetadata)Mockito.mock(PMMLModelMetadata.class)));
        org.kie.workbench.common.dmn.api.definition.model.Import anImport = ImportConverter.wbFromDMN((Import)dmn, (Definitions)definitions, (PMMLDocumentMetadata)pmmlDocument);
        Assert.assertTrue((boolean)(anImport instanceof ImportPMML));
        ImportPMML pmmlImport = (ImportPMML)anImport;
        Assert.assertEquals((long)2L, (long)pmmlImport.getModelCount());
    }

    @Test
    public void testDmnFromWb() {
        org.kie.workbench.common.dmn.api.definition.model.Import wb = new org.kie.workbench.common.dmn.api.definition.model.Import();
        String key = "drools";
        String value = "http://www.drools.org/kie/dmn/1.1";
        wb.getNsContext().put("drools", "http://www.drools.org/kie/dmn/1.1");
        Import anImport = ImportConverter.dmnFromWb((org.kie.workbench.common.dmn.api.definition.model.Import)wb);
        Map nsContext = anImport.getNsContext();
        Assert.assertEquals((long)1L, (long)nsContext.size());
        Assert.assertEquals((Object)"http://www.drools.org/kie/dmn/1.1", nsContext.get("drools"));
    }
}

