/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.types;

import java.util.List;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.editors.types.DMNSimpleTimeZone;
import org.kie.workbench.common.dmn.backend.editors.types.TimeZoneServiceImpl;
import org.mockito.Mockito;

public class TimeZoneServiceImplTest {
    private TimeZoneServiceImpl service;

    @Before
    public void setup() {
        this.service = (TimeZoneServiceImpl)Mockito.spy((Object)new TimeZoneServiceImpl());
    }

    @Test
    public void testGetTimeZones() {
        TimeZone timeZone0 = (TimeZone)Mockito.mock(TimeZone.class);
        TimeZone timeZone1 = (TimeZone)Mockito.mock(TimeZone.class);
        String[] ids = new String[]{"0", "1"};
        Mockito.when((Object)timeZone0.getRawOffset()).thenReturn((Object)0);
        Mockito.when((Object)timeZone1.getRawOffset()).thenReturn((Object)3600000);
        ((TimeZoneServiceImpl)Mockito.doReturn((Object)ids).when((Object)this.service)).getAvailableIds();
        ((TimeZoneServiceImpl)Mockito.doReturn((Object)timeZone0).when((Object)this.service)).getTimeZone("0");
        ((TimeZoneServiceImpl)Mockito.doReturn((Object)timeZone1).when((Object)this.service)).getTimeZone("1");
        List simpleTimeZones = this.service.getTimeZones();
        Assert.assertEquals((long)2L, (long)simpleTimeZones.size());
        Assert.assertEquals((double)0.0, (double)((DMNSimpleTimeZone)simpleTimeZones.get(0)).getOffset(), (double)0.01);
        Assert.assertEquals((double)1.0, (double)((DMNSimpleTimeZone)simpleTimeZones.get(1)).getOffset(), (double)0.01);
        Assert.assertEquals((Object)"+00:00", (Object)((DMNSimpleTimeZone)simpleTimeZones.get(0)).getOffsetString());
        Assert.assertEquals((Object)"+01:00", (Object)((DMNSimpleTimeZone)simpleTimeZones.get(1)).getOffsetString());
    }

    @Test
    public void testToHours() {
        long input = 3600000L;
        double expected = 1.0;
        double actual = this.service.toHours(3600000L);
        Assert.assertEquals((double)1.0, (double)actual, (double)0.01);
    }

    @Test
    public void testToHoursOneAndAHalfHour() {
        long input = 5400000L;
        double expected = 1.5;
        double actual = this.service.toHours(5400000L);
        Assert.assertEquals((double)1.5, (double)actual, (double)0.01);
    }

    @Test
    public void testFormatOffsetWithPositiveIntegerHour() {
        double input = 2.0;
        String expected = "+02:00";
        this.testFormatOffset(2.0, "+02:00");
    }

    @Test
    public void testFormatOffsetWithNegativeIntegerHour() {
        double input = -2.0;
        String expected = "-02:00";
        this.testFormatOffset(-2.0, "-02:00");
    }

    @Test
    public void testFormatOffsetWithNegativeFractionalHour() {
        double input = -2.5;
        String expected = "-02:30";
        this.testFormatOffset(-2.5, "-02:30");
    }

    @Test
    public void testFormatOffsetWithPositiveFractionalHour() {
        double input = 2.5;
        String expected = "+02:30";
        this.testFormatOffset(2.5, "+02:30");
    }

    @Test
    public void testFormatOffsetWithZeroHour() {
        double input = 0.0;
        String expected = "+00:00";
        this.testFormatOffset(0.0, "+00:00");
    }

    @Test
    public void testFormatOffsetWithTwoDigitsHour() {
        double input = 10.0;
        String expected = "+10:00";
        this.testFormatOffset(10.0, "+10:00");
    }

    private void testFormatOffset(double input, String expected) {
        String actual = this.service.formatOffset(input);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

