/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.Map;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.model.api.UnaryTests;
import org.kie.workbench.common.dmn.api.definition.model.ConstraintType;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.InputClauseUnaryTests;
import org.kie.workbench.common.dmn.backend.definition.v1_1.InputClauseUnaryTestsPropertyConverter;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class InputClauseUnaryTestsPropertyConverterTest {
    private static final String ID = "thisId";
    private static final String TEXT = "1,2,3";
    private static final QName key = new QName(DMNModelInstrumentedBase.Namespace.KIE.getUri(), "constraintType", DMNModelInstrumentedBase.Namespace.KIE.getPrefix());
    @Mock
    private UnaryTests dmnUnary;
    @Mock
    private Map<QName, String> additionalAttributes;

    @Before
    public void setup() {
        Mockito.when((Object)this.dmnUnary.getId()).thenReturn((Object)ID);
        Mockito.when((Object)this.dmnUnary.getAdditionalAttributes()).thenReturn(this.additionalAttributes);
        Mockito.when((Object)this.dmnUnary.getText()).thenReturn((Object)TEXT);
    }

    @Test
    public void testWbFromDMNEnumeration() {
        this.testWbFromDMN(ConstraintType.ENUMERATION);
    }

    @Test
    public void testWbFromDMNExpression() {
        this.testWbFromDMN(ConstraintType.EXPRESSION);
    }

    @Test
    public void testWbFromDMNRange() {
        this.testWbFromDMN(ConstraintType.RANGE);
    }

    private void testWbFromDMN(ConstraintType constraintType) {
        Mockito.when((Object)this.additionalAttributes.getOrDefault(key, "")).thenReturn((Object)constraintType.value());
        InputClauseUnaryTests inputClause = InputClauseUnaryTestsPropertyConverter.wbFromDMN((UnaryTests)this.dmnUnary);
        Assert.assertEquals((Object)inputClause.getConstraintType(), (Object)constraintType);
        Assert.assertEquals((Object)inputClause.getId().getValue(), (Object)ID);
        Assert.assertEquals((Object)inputClause.getText().getValue(), (Object)TEXT);
    }
}

