/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.common;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.editors.included.PMMLIncludedModel;
import org.kie.workbench.common.dmn.api.marshalling.DMNPathsHelper;
import org.kie.workbench.common.dmn.backend.editors.common.PMMLIncludedDocumentFactory;
import org.uberfire.backend.vfs.Path;

@Dependent
public class PMMLIncludedDocumentsFilter {
    private final DMNPathsHelper pathsHelper;
    private final PMMLIncludedDocumentFactory pmmlDocumentFactory;

    @Inject
    public PMMLIncludedDocumentsFilter(DMNPathsHelper pathsHelper, PMMLIncludedDocumentFactory pmmlDocumentFactory) {
        this.pathsHelper = pathsHelper;
        this.pmmlDocumentFactory = pmmlDocumentFactory;
    }

    public PMMLDocumentMetadata getDocumentFromImports(Path dmnModelPath, Path includedModelPath, List<PMMLIncludedModel> includedModels) {
        Optional<PMMLIncludedModel> documentImport = this.getDocumentImport(dmnModelPath, includedModelPath, includedModels);
        return documentImport.map(pmml -> this.pmmlDocumentFactory.getDocumentByPath(includedModelPath, (PMMLIncludedModel)pmml)).orElse(null);
    }

    private Optional<PMMLIncludedModel> getDocumentImport(Path dmnModelPath, Path includedModelPath, List<PMMLIncludedModel> includedModels) {
        return includedModels.stream().filter(i -> Objects.equals(i.getPath(), this.pathsHelper.getRelativeURI(dmnModelPath, includedModelPath))).findAny();
    }
}

