/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.dmn.api.DMNContentResource;
import org.kie.workbench.common.dmn.api.DMNContentService;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.marshalling.DMNPathsHelper;
import org.kie.workbench.common.dmn.backend.common.DMNIOHelper;
import org.kie.workbench.common.dmn.backend.editors.common.PMMLIncludedDocumentFactory;
import org.kie.workbench.common.services.backend.service.KieService;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.project.diagram.ProjectMetadata;
import org.kie.workbench.common.stunner.project.diagram.impl.ProjectMetadataImpl;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@Service
@ApplicationScoped
public class DMNContentServiceImpl
extends KieService<String>
implements DMNContentService {
    private final CommentedOptionFactory commentedOptionFactory;
    private final DMNIOHelper dmnIOHelper;
    private final DMNPathsHelper pathsHelper;
    private final PMMLIncludedDocumentFactory pmmlIncludedDocumentFactory;

    @Inject
    public DMNContentServiceImpl(CommentedOptionFactory commentedOptionFactory, DMNIOHelper dmnIOHelper, DMNPathsHelper pathsHelper, PMMLIncludedDocumentFactory pmmlIncludedDocumentFactory) {
        this.commentedOptionFactory = commentedOptionFactory;
        this.dmnIOHelper = dmnIOHelper;
        this.pathsHelper = pathsHelper;
        this.pmmlIncludedDocumentFactory = pmmlIncludedDocumentFactory;
    }

    public String getContent(org.uberfire.backend.vfs.Path path) {
        return this.getSource(path);
    }

    public DMNContentResource getProjectContent(org.uberfire.backend.vfs.Path path, String defSetId) {
        String content = this.getSource(path);
        String title = path.getFileName();
        ProjectMetadata metadata = this.buildMetadataInstance(path, defSetId, title);
        return new DMNContentResource(content, (Metadata)metadata);
    }

    public void saveContent(org.uberfire.backend.vfs.Path path, String content, org.guvnor.common.services.shared.metadata.model.Metadata metadata, String comment) {
        try {
            this.ioService.write(this.convertPath(path), content, this.getAttrs(path, metadata), new OpenOption[]{this.getCommentedOption(comment)});
        }
        catch (Exception e) {
            logger.error("Error while saving diagram.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<org.uberfire.backend.vfs.Path> getModelsPaths(WorkspaceProject workspaceProject) {
        return this.pathsHelper.getModelsPaths(workspaceProject);
    }

    public List<org.uberfire.backend.vfs.Path> getDMNModelsPaths(WorkspaceProject workspaceProject) {
        return this.pathsHelper.getDMNModelsPaths(workspaceProject);
    }

    public List<org.uberfire.backend.vfs.Path> getPMMLModelsPaths(WorkspaceProject workspaceProject) {
        return this.pathsHelper.getPMMLModelsPaths(workspaceProject);
    }

    public PMMLDocumentMetadata loadPMMLDocumentMetadata(org.uberfire.backend.vfs.Path path) {
        return this.pmmlIncludedDocumentFactory.getDocumentByPath(path);
    }

    protected String constructContent(org.uberfire.backend.vfs.Path path, Overview _overview) {
        return this.getSource(path);
    }

    public String getSource(org.uberfire.backend.vfs.Path path) {
        return this.loadPath(path).map(this.dmnIOHelper::isAsString).orElse("");
    }

    private CommentedOption getCommentedOption(String comment) {
        return this.commentedOptionFactory.makeCommentedOption(comment);
    }

    private Map<String, Object> getAttrs(org.uberfire.backend.vfs.Path path, org.guvnor.common.services.shared.metadata.model.Metadata metadata) {
        return Optional.ofNullable(metadata).map(m -> this.metadataService.setUpAttributes(path, m)).orElse(new HashMap());
    }

    private ProjectMetadata buildMetadataInstance(org.uberfire.backend.vfs.Path path, String defSetId, String title) {
        Package modulePackage = this.moduleService.resolvePackage(path);
        KieModule kieModule = (KieModule)this.moduleService.resolveModule(path);
        Overview overview = this.overviewLoader.loadOverview(path);
        return new ProjectMetadataImpl.ProjectMetadataBuilder().forDefinitionSetId(defSetId).forModuleName(kieModule.getModuleName()).forProjectPackage(modulePackage).forOverview(overview).forTitle(title).forPath(path).build();
    }

    private Optional<InputStream> loadPath(org.uberfire.backend.vfs.Path path) {
        try {
            return Optional.ofNullable(this.ioService.newInputStream(this.convertPath(path), new OpenOption[0]));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    Path convertPath(org.uberfire.backend.vfs.Path path) {
        return Paths.convert((org.uberfire.backend.vfs.Path)path);
    }
}

