/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.FunctionInvocationNode;
import org.kie.dmn.feel.lang.ast.ListNode;
import org.kie.dmn.feel.lang.ast.RangeNode;
import org.kie.dmn.feel.lang.types.DefaultBuiltinFEELTypeRegistry;
import org.kie.dmn.feel.lang.types.FEELTypeRegistry;
import org.kie.dmn.feel.parser.feel11.ASTBuilderVisitor;
import org.kie.dmn.feel.parser.feel11.FEELParser;
import org.kie.dmn.feel.parser.feel11.FEEL_1_1Parser;
import org.kie.workbench.common.dmn.api.editors.types.DMNParseService;
import org.kie.workbench.common.dmn.api.editors.types.RangeValue;

@Service
public class DMNParseServiceImpl
implements DMNParseService {
    public List<String> parseFEELList(String source) {
        return this.parse(source).map(this::getTextElements).orElseGet(ArrayList::new);
    }

    public RangeValue parseRangeValue(String source) {
        FEEL_1_1Parser parser = this.makeParser(source);
        BaseNode baseNode = (BaseNode)this.makeVisitor().visit((ParseTree)parser.expression());
        RangeValue rangeValue = new RangeValue();
        if (baseNode instanceof RangeNode) {
            RangeNode rangeNode = (RangeNode)baseNode;
            rangeValue.setStartValue(this.parseRangeValue(rangeNode.getStart()));
            rangeValue.setIncludeStartValue(rangeNode.getLowerBound() == RangeNode.IntervalBoundary.CLOSED);
            rangeValue.setEndValue(this.parseRangeValue(rangeNode.getEnd()));
            rangeValue.setIncludeEndValue(rangeNode.getUpperBound() == RangeNode.IntervalBoundary.CLOSED);
        }
        return rangeValue;
    }

    private String parseRangeValue(BaseNode baseNode) {
        if (baseNode instanceof FunctionInvocationNode) {
            FunctionInvocationNode functionInvocation = (FunctionInvocationNode)baseNode;
            String functionName = functionInvocation.getName().getText();
            String functionParams = functionInvocation.getParams().getText();
            return functionName + "(" + functionParams + ")";
        }
        return baseNode.getText();
    }

    private List<String> getTextElements(ListNode list) {
        return list.getElements().stream().map(BaseNode::getText).collect(Collectors.toList());
    }

    private Optional<ListNode> parse(String source) {
        FEEL_1_1Parser parser = this.makeParser(this.asListSource(source));
        BaseNode baseNode = (BaseNode)this.makeVisitor().visit((ParseTree)parser.expression());
        return Optional.ofNullable((ListNode)baseNode);
    }

    private FEEL_1_1Parser makeParser(String source) {
        return FEELParser.parse(null, (String)source, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), (FEELTypeRegistry)DefaultBuiltinFEELTypeRegistry.INSTANCE);
    }

    private ASTBuilderVisitor makeVisitor() {
        return new ASTBuilderVisitor(Collections.emptyMap(), (FEELTypeRegistry)DefaultBuiltinFEELTypeRegistry.INSTANCE);
    }

    private String asListSource(String source) {
        return "[" + source + "]";
    }
}

