/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.validation;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.api.builder.Message;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.model.api.DMNElement;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.DMNValidatorFactory;
import org.kie.workbench.common.dmn.api.DMNDefinitionSet;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.graph.DMNDiagramUtils;
import org.kie.workbench.common.dmn.api.validation.DMNDomainValidator;
import org.kie.workbench.common.dmn.backend.DMNMarshallerStandalone;
import org.kie.workbench.common.dmn.backend.common.DMNIOHelper;
import org.kie.workbench.common.dmn.backend.common.DMNMarshallerImportsHelperStandalone;
import org.kie.workbench.common.dmn.backend.definition.v1_1.ImportConverter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingMessage;
import org.kie.workbench.common.stunner.core.validation.DomainViolation;
import org.kie.workbench.common.stunner.core.validation.Violation;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;

@Service
@ApplicationScoped
public class DMNDomainValidatorImpl
implements DMNDomainValidator {
    static final String DEFAULT_UUID = "uuid";
    private DMNValidator dmnValidator;
    private DMNMarshallerStandalone dmnMarshaller;
    private DMNDiagramUtils dmnDiagramUtils;
    private DMNMarshallerImportsHelperStandalone importsHelper;
    private final DMNIOHelper dmnIOHelper;

    @Inject
    public DMNDomainValidatorImpl(DMNMarshallerStandalone dmnMarshaller, DMNDiagramUtils dmnDiagramUtils, DMNMarshallerImportsHelperStandalone importsHelper, DMNIOHelper dmnIOHelper) {
        this.dmnMarshaller = dmnMarshaller;
        this.dmnDiagramUtils = dmnDiagramUtils;
        this.importsHelper = importsHelper;
        this.dmnIOHelper = dmnIOHelper;
    }

    @PostConstruct
    public void setupValidator() {
        this.dmnValidator = this.getDMNValidator();
    }

    DMNValidator getDMNValidator() {
        return DMNValidatorFactory.newValidator();
    }

    public String getDefinitionSetId() {
        return BindableAdapterUtils.getDefinitionSetId(DMNDefinitionSet.class);
    }

    public void validate(Diagram diagram, Consumer<Collection<DomainViolation>> resultConsumer) {
        String diagramXml = this.dmnMarshaller.marshall((Diagram<Graph, Metadata>)diagram);
        Collection<DomainViolation> messages = this.validate(diagram, diagramXml);
        resultConsumer.accept(messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DomainViolation> validate(Diagram diagram, String diagramXml) {
        ArrayList<StringReader> dmnXMLReaders = new ArrayList<StringReader>();
        try {
            dmnXMLReaders.add(this.getStringReader(diagramXml));
            Definitions uiDefinitions = this.dmnDiagramUtils.getDefinitions(diagram);
            List uiImports = uiDefinitions.getImport();
            List dmnImports = uiImports.stream().map(ImportConverter::dmnFromWb).collect(Collectors.toList());
            Metadata metadata = diagram.getMetadata();
            Map importedDiagramsXML = this.importsHelper.getImportXML(metadata, dmnImports);
            importedDiagramsXML.values().forEach(importedDiagramXML -> dmnXMLReaders.add(this.getStringReader((String)importedDiagramXML)));
            Reader[] aDMNXMLReaders = new Reader[]{};
            List messages = this.dmnValidator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE}).usingImports(this.getValidatorImportReaderResolver(metadata)).theseModels(dmnXMLReaders.toArray(aDMNXMLReaders));
            Collection<DomainViolation> collection = this.convert(messages);
            return collection;
        }
        finally {
            dmnXMLReaders.forEach(reader -> {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }

    DMNValidator.ValidatorBuilder.ValidatorImportReaderResolver getValidatorImportReaderResolver(Metadata metadata) {
        return (modelNamespace, modelName, locationURI) -> {
            org.uberfire.backend.vfs.Path modelPath = this.importsHelper.getDMNModelPath(metadata, modelNamespace, modelName);
            URI pmmlURI = this.getPMMLURI(modelPath, locationURI);
            String pmmlXML = this.importsHelper.loadPath(this.getPath(pmmlURI)).map(this.dmnIOHelper::isAsString).orElse("");
            return this.getStringReader(pmmlXML);
        };
    }

    URI getPMMLURI(org.uberfire.backend.vfs.Path modelPath, String pmmlRelativeURI) {
        return URI.create(modelPath.toURI()).resolve(pmmlRelativeURI);
    }

    StringReader getStringReader(String xml) {
        return new StringReader(xml);
    }

    private Collection<DomainViolation> convert(List<DMNMessage> messages) {
        return messages.stream().map(this::convert).collect(Collectors.toList());
    }

    private DomainViolation convert(DMNMessage message) {
        return new MarshallingMessage.MarshallingMessageBuilder().elementUUID(this.getDMNElementUUID(message.getSourceReference())).type(this.convert(message.getLevel())).message(message.getMessage()).build();
    }

    private String getDMNElementUUID(Object source) {
        if (source instanceof DMNElement) {
            DMNElement element = (DMNElement)source;
            if (Objects.isNull(element.getId())) {
                return this.getDMNElementUUID(element.getParent());
            }
            return element.getId();
        }
        return DEFAULT_UUID;
    }

    private Violation.Type convert(Message.Level level) {
        switch (level) {
            case ERROR: {
                return Violation.Type.ERROR;
            }
            case WARNING: {
                return Violation.Type.WARNING;
            }
        }
        return Violation.Type.INFO;
    }

    org.uberfire.backend.vfs.Path getPath(URI uri) {
        return this.convertPath(Paths.get((URI)uri));
    }

    org.uberfire.backend.vfs.Path convertPath(Path path) {
        return org.uberfire.backend.server.util.Paths.convert((Path)path);
    }
}

