/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.model.v1_2.TContext;
import org.kie.dmn.model.v1_2.TDecisionTable;
import org.kie.dmn.model.v1_2.TFunctionDefinition;
import org.kie.dmn.model.v1_2.TInvocation;
import org.kie.dmn.model.v1_2.TList;
import org.kie.dmn.model.v1_2.TLiteralExpression;
import org.kie.dmn.model.v1_2.TRelation;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.model.Context;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.model.Invocation;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.Relation;
import org.kie.workbench.common.dmn.backend.definition.v1_1.ExpressionPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.ComponentWidths;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ExpressionPropertyConverterTest {
    private static final String EXPRESSION_UUID = "uuid";
    @Mock
    private BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer;
    @Mock
    private Consumer<ComponentWidths> componentWidthsConsumer;
    @Captor
    private ArgumentCaptor<HasComponentWidths> hasComponentWidthsCaptor;
    @Captor
    private ArgumentCaptor<ComponentWidths> componentWidthsCaptor;

    @Test
    public void testWBFromDMN_LiteralExpressionConversion() {
        TLiteralExpression dmn = new TLiteralExpression();
        dmn.setId(EXPRESSION_UUID);
        this.assertWBFromDMNConversion((org.kie.dmn.model.api.Expression)dmn, LiteralExpression.class);
    }

    private void assertWBFromDMNConversion(org.kie.dmn.model.api.Expression dmn, Class wbClass) {
        Expression wb = ExpressionPropertyConverter.wbFromDMN((org.kie.dmn.model.api.Expression)dmn, this.hasComponentWidthsConsumer);
        Assertions.assertThat((Object)wb).isInstanceOf(wbClass);
        ((BiConsumer)Mockito.verify(this.hasComponentWidthsConsumer)).accept(ArgumentMatchers.eq((Object)EXPRESSION_UUID), this.hasComponentWidthsCaptor.capture());
        HasComponentWidths hasComponentWidths = (HasComponentWidths)this.hasComponentWidthsCaptor.getValue();
        Assertions.assertThat((Object)hasComponentWidths).isNotNull();
        Assertions.assertThat((Object)hasComponentWidths).isEqualTo((Object)wb);
    }

    @Test
    public void testDMNFromWB_LiteralExpressionConversion() {
        LiteralExpression wb = new LiteralExpression();
        List wbComponentWidths = wb.getComponentWidths();
        wbComponentWidths.set(0, 200.0);
        wb.getId().setValue(EXPRESSION_UUID);
        this.assertDMNFromWBConversion((Expression)wb, TLiteralExpression.class, 200.0);
    }

    private void assertDMNFromWBConversion(Expression wb, Class dmnClass, double ... expectedComponentWidths) {
        org.kie.dmn.model.api.Expression dmn = ExpressionPropertyConverter.dmnFromWB((Expression)wb, this.componentWidthsConsumer);
        Assertions.assertThat((Object)dmn).isInstanceOf(dmnClass);
        ((Consumer)Mockito.verify(this.componentWidthsConsumer)).accept(this.componentWidthsCaptor.capture());
        ComponentWidths componentWidths = (ComponentWidths)this.componentWidthsCaptor.getValue();
        Assertions.assertThat((Object)componentWidths).isNotNull();
        Assertions.assertThat((String)componentWidths.getDmnElementRef().getLocalPart()).isEqualTo(EXPRESSION_UUID);
        List widths = componentWidths.getWidths();
        Assertions.assertThat((int)widths.size()).isEqualTo(wb.getRequiredComponentWidthCount());
        Assertions.assertThat((int)widths.size()).isEqualTo(expectedComponentWidths.length);
        IntStream.range(0, expectedComponentWidths.length).forEach(i -> Assertions.assertThat((Double)((Double)widths.get(i))).isEqualTo(expectedComponentWidths[i]));
    }

    @Test
    public void testWBFromDMN_ContextConversion() {
        TContext dmn = new TContext();
        dmn.setId(EXPRESSION_UUID);
        this.assertWBFromDMNConversion((org.kie.dmn.model.api.Expression)dmn, Context.class);
    }

    @Test
    public void testDMNFromWB_ContextConversion() {
        Context wb = new Context();
        List wbComponentWidths = wb.getComponentWidths();
        wbComponentWidths.set(0, 100.0);
        wbComponentWidths.set(1, 200.0);
        wbComponentWidths.set(2, 300.0);
        wb.getId().setValue(EXPRESSION_UUID);
        this.assertDMNFromWBConversion((Expression)wb, TContext.class, 100.0, 200.0, 300.0);
    }

    @Test
    public void testWBFromDMN_RelationConversion() {
        TRelation dmn = new TRelation();
        dmn.setId(EXPRESSION_UUID);
        this.assertWBFromDMNConversion((org.kie.dmn.model.api.Expression)dmn, Relation.class);
    }

    @Test
    public void testDMNFromWB_RelationConversion() {
        Relation wb = new Relation();
        List wbComponentWidths = wb.getComponentWidths();
        wbComponentWidths.set(0, 200.0);
        wb.getId().setValue(EXPRESSION_UUID);
        this.assertDMNFromWBConversion((Expression)wb, TRelation.class, 200.0);
    }

    @Test
    public void testWBFromDMN_ListConversion() {
        TList dmn = new TList();
        dmn.setId(EXPRESSION_UUID);
        this.assertWBFromDMNConversion((org.kie.dmn.model.api.Expression)dmn, org.kie.workbench.common.dmn.api.definition.model.List.class);
    }

    @Test
    public void testDMNFromWB_ListConversion() {
        org.kie.workbench.common.dmn.api.definition.model.List wb = new org.kie.workbench.common.dmn.api.definition.model.List();
        List wbComponentWidths = wb.getComponentWidths();
        wbComponentWidths.set(0, 50.0);
        wbComponentWidths.set(1, 200.0);
        wb.getId().setValue(EXPRESSION_UUID);
        this.assertDMNFromWBConversion((Expression)wb, TList.class, 50.0, 200.0);
    }

    @Test
    public void testWBFromDMN_InvocationConversion() {
        TInvocation dmn = new TInvocation();
        dmn.setId(EXPRESSION_UUID);
        this.assertWBFromDMNConversion((org.kie.dmn.model.api.Expression)dmn, Invocation.class);
    }

    @Test
    public void testDMNFromWB_InvocationConversion() {
        Invocation wb = new Invocation();
        List wbComponentWidths = wb.getComponentWidths();
        wbComponentWidths.set(0, 100.0);
        wbComponentWidths.set(1, 200.0);
        wbComponentWidths.set(2, 300.0);
        wb.getId().setValue(EXPRESSION_UUID);
        this.assertDMNFromWBConversion((Expression)wb, TInvocation.class, 100.0, 200.0, 300.0);
    }

    @Test
    public void testWBFromDMN_FunctionDefinitionConversion() {
        TFunctionDefinition dmn = new TFunctionDefinition();
        dmn.setId(EXPRESSION_UUID);
        this.assertWBFromDMNConversion((org.kie.dmn.model.api.Expression)dmn, FunctionDefinition.class);
    }

    @Test
    public void testDMNFromWB_FunctionDefinitionConversion() {
        FunctionDefinition wb = new FunctionDefinition();
        List wbComponentWidths = wb.getComponentWidths();
        wbComponentWidths.set(0, 100.0);
        wbComponentWidths.set(1, 200.0);
        wb.getId().setValue(EXPRESSION_UUID);
        this.assertDMNFromWBConversion((Expression)wb, TFunctionDefinition.class, 100.0, 200.0);
    }

    @Test
    public void testWBFromDMN_DecisionTableConversion() {
        TDecisionTable dmn = new TDecisionTable();
        dmn.setId(EXPRESSION_UUID);
        this.assertWBFromDMNConversion((org.kie.dmn.model.api.Expression)dmn, DecisionTable.class);
    }

    @Test
    public void testDMNFromWB_DecisionTableConversion() {
        DecisionTable wb = new DecisionTable();
        List wbComponentWidths = wb.getComponentWidths();
        wbComponentWidths.set(0, 100.0);
        wb.getId().setValue(EXPRESSION_UUID);
        this.assertDMNFromWBConversion((Expression)wb, TDecisionTable.class, 100.0);
    }

    @Test
    public void testWBFromDMN_NullConversion() {
        Assertions.assertThat((Object)ExpressionPropertyConverter.wbFromDMN(null, this.hasComponentWidthsConsumer)).isNull();
    }

    @Test
    public void testDMNFromWB_NullConversion() {
        Assertions.assertThat((Object)ExpressionPropertyConverter.dmnFromWB(null, this.componentWidthsConsumer)).isNull();
    }
}

