/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.marshalling.server.ServerMarshalling;
import org.kie.dmn.backend.marshalling.v1_1.DMNMarshallerFactory;
import org.kie.dmn.model.v1_1.DMNElement;
import org.kie.dmn.model.v1_1.DMNElementReference;
import org.kie.dmn.model.v1_1.Decision;
import org.kie.dmn.model.v1_1.Definitions;
import org.kie.dmn.model.v1_1.InformationRequirement;
import org.kie.dmn.model.v1_1.InputData;
import org.kie.dmn.model.v1_1.TextAnnotation;
import org.kie.workbench.common.dmn.api.DMNDefinitionSet;
import org.kie.workbench.common.dmn.api.definition.v1_1.Association;
import org.kie.workbench.common.dmn.api.definition.v1_1.AuthorityRequirement;
import org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.v1_1.DRGElement;
import org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeRequirement;
import org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource;
import org.kie.workbench.common.dmn.api.property.background.BackgroundSet;
import org.kie.workbench.common.dmn.api.property.background.BgColour;
import org.kie.workbench.common.dmn.api.property.background.BorderColour;
import org.kie.workbench.common.dmn.api.property.dimensions.Height;
import org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet;
import org.kie.workbench.common.dmn.api.property.dimensions.Width;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.font.FontSet;
import org.kie.workbench.common.dmn.backend.definition.v1_1.AssociationConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.BusinessKnowledgeModelConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.DecisionConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.DefinitionsConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.FontSetPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.InputDataConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.KnowledgeSourceConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.TextAnnotationConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.BorderSize;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.ColorUtils;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.DDExtensionsRegister;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.DMNDiagram;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.DMNShape;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.org.omg.spec.CMMN_20151109_DC.Bounds;
import org.kie.workbench.common.stunner.backend.service.XMLEncoderDiagramMetadataMarshaller;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMetadataMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.BoundImpl;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;
import org.kie.workbench.common.stunner.core.util.UUID;

@ApplicationScoped
public class DMNMarshaller
implements DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>> {
    private XMLEncoderDiagramMetadataMarshaller diagramMetadataMarshaller;
    private FactoryManager factoryManager;
    private InputDataConverter inputDataConverter;
    private DecisionConverter decisionConverter;
    private BusinessKnowledgeModelConverter bkmConverter;
    private KnowledgeSourceConverter knowledgeSourceConverter;
    private TextAnnotationConverter textAnnotationConverter;
    private org.kie.dmn.api.marshalling.v1_1.DMNMarshaller marshaller;

    protected DMNMarshaller() {
        this(null, null);
    }

    @Inject
    public DMNMarshaller(XMLEncoderDiagramMetadataMarshaller diagramMetadataMarshaller, FactoryManager factoryManager) {
        this.diagramMetadataMarshaller = diagramMetadataMarshaller;
        this.factoryManager = factoryManager;
        this.inputDataConverter = new InputDataConverter(factoryManager);
        this.decisionConverter = new DecisionConverter(factoryManager);
        this.bkmConverter = new BusinessKnowledgeModelConverter(factoryManager);
        this.knowledgeSourceConverter = new KnowledgeSourceConverter(factoryManager);
        this.textAnnotationConverter = new TextAnnotationConverter(factoryManager);
        this.marshaller = DMNMarshallerFactory.newMarshallerWithExtensions(Arrays.asList(new DDExtensionsRegister()));
    }

    @Deprecated
    public Graph unmarshallFromStunnerJSON(Metadata metadata, InputStream input) throws IOException {
        Graph result = (Graph)ServerMarshalling.fromJSON((InputStream)input);
        return result;
    }

    @Deprecated
    public String marshallFromStunnerToJSON(Diagram<Graph, Metadata> diagram) throws IOException {
        String result = ServerMarshalling.toJSON((Object)diagram.getGraph());
        return result;
    }

    private static Optional<DMNDiagram> findDMNDiagram(Definitions dmnXml) {
        if (dmnXml.getExtensionElements() == null) {
            return Optional.empty();
        }
        List elems = dmnXml.getExtensionElements().getAny().stream().filter(DMNDiagram.class::isInstance).map(DMNDiagram.class::cast).collect(Collectors.toList());
        if (elems.size() != 1) {
            return Optional.empty();
        }
        return Optional.of(elems.get(0));
    }

    public Graph unmarshall(Metadata metadata, InputStream input) throws IOException {
        Definitions dmnXml = this.marshaller.unmarshal((Reader)new InputStreamReader(input));
        Map<String, Map.Entry> elems = dmnXml.getDrgElement().stream().collect(Collectors.toMap(DMNElement::getId, dmn -> new AbstractMap.SimpleEntry<org.kie.dmn.model.v1_1.DRGElement, Node>((org.kie.dmn.model.v1_1.DRGElement)dmn, this.dmnToStunner((org.kie.dmn.model.v1_1.DRGElement)dmn))));
        Optional<DMNDiagram> dmnDDDiagram = DMNMarshaller.findDMNDiagram(dmnXml);
        for (Map.Entry kv2 : elems.values()) {
            Edge myEdge;
            Node requiredNode;
            String reqInputID;
            org.kie.dmn.model.v1_1.DRGElement elem = (org.kie.dmn.model.v1_1.DRGElement)kv2.getKey();
            Node currentNode = (Node)kv2.getValue();
            this.ddExtAugmentStunner(dmnDDDiagram, currentNode);
            if (elem instanceof Decision) {
                Decision decision = (Decision)elem;
                for (InformationRequirement ir : decision.getInformationRequirement()) {
                    if (ir.getRequiredInput() != null) {
                        reqInputID = this.getId(ir.getRequiredInput());
                        requiredNode = (Node)elems.get(reqInputID).getValue();
                        myEdge = this.factoryManager.newElement(UUID.uuid(), org.kie.workbench.common.dmn.api.definition.v1_1.InformationRequirement.class).asEdge();
                        this.connectEdge(myEdge, requiredNode, currentNode);
                        this.setConnectionMagnets(myEdge);
                    }
                    if (ir.getRequiredDecision() == null) continue;
                    reqInputID = this.getId(ir.getRequiredDecision());
                    requiredNode = (Node)elems.get(reqInputID).getValue();
                    myEdge = this.factoryManager.newElement(UUID.uuid(), org.kie.workbench.common.dmn.api.definition.v1_1.InformationRequirement.class).asEdge();
                    this.connectEdge(myEdge, requiredNode, currentNode);
                    this.setConnectionMagnets(myEdge);
                }
                for (org.kie.dmn.model.v1_1.KnowledgeRequirement kr : decision.getKnowledgeRequirement()) {
                    reqInputID = this.getId(kr.getRequiredKnowledge());
                    requiredNode = (Node)elems.get(reqInputID).getValue();
                    myEdge = this.factoryManager.newElement(UUID.uuid(), KnowledgeRequirement.class).asEdge();
                    this.connectEdge(myEdge, requiredNode, currentNode);
                    this.setConnectionMagnets(myEdge);
                }
                for (org.kie.dmn.model.v1_1.KnowledgeRequirement kr : decision.getAuthorityRequirement()) {
                    reqInputID = this.getId(kr.getRequiredAuthority());
                    requiredNode = (Node)elems.get(reqInputID).getValue();
                    myEdge = this.factoryManager.newElement(UUID.uuid(), AuthorityRequirement.class).asEdge();
                    this.connectEdge(myEdge, requiredNode, currentNode);
                    this.setConnectionMagnets(myEdge);
                }
                continue;
            }
            if (elem instanceof org.kie.dmn.model.v1_1.BusinessKnowledgeModel) {
                org.kie.dmn.model.v1_1.BusinessKnowledgeModel bkm = (org.kie.dmn.model.v1_1.BusinessKnowledgeModel)elem;
                for (org.kie.dmn.model.v1_1.KnowledgeRequirement kr : bkm.getKnowledgeRequirement()) {
                    reqInputID = this.getId(kr.getRequiredKnowledge());
                    requiredNode = (Node)elems.get(reqInputID).getValue();
                    myEdge = this.factoryManager.newElement(UUID.uuid(), KnowledgeRequirement.class).asEdge();
                    this.connectEdge(myEdge, requiredNode, currentNode);
                    this.setConnectionMagnets(myEdge);
                }
                for (org.kie.dmn.model.v1_1.KnowledgeRequirement kr : bkm.getAuthorityRequirement()) {
                    reqInputID = this.getId(kr.getRequiredAuthority());
                    requiredNode = (Node)elems.get(reqInputID).getValue();
                    myEdge = this.factoryManager.newElement(UUID.uuid(), AuthorityRequirement.class).asEdge();
                    this.connectEdge(myEdge, requiredNode, currentNode);
                    this.setConnectionMagnets(myEdge);
                }
                continue;
            }
            if (!(elem instanceof org.kie.dmn.model.v1_1.KnowledgeSource)) continue;
            org.kie.dmn.model.v1_1.KnowledgeSource ks = (org.kie.dmn.model.v1_1.KnowledgeSource)elem;
            for (InformationRequirement ir : ks.getAuthorityRequirement()) {
                if (ir.getRequiredInput() != null) {
                    reqInputID = this.getId(ir.getRequiredInput());
                    requiredNode = (Node)elems.get(reqInputID).getValue();
                    myEdge = this.factoryManager.newElement(UUID.uuid(), AuthorityRequirement.class).asEdge();
                    this.connectEdge(myEdge, requiredNode, currentNode);
                    this.setConnectionMagnets(myEdge);
                }
                if (ir.getRequiredDecision() != null) {
                    reqInputID = this.getId(ir.getRequiredDecision());
                    requiredNode = (Node)elems.get(reqInputID).getValue();
                    myEdge = this.factoryManager.newElement(UUID.uuid(), AuthorityRequirement.class).asEdge();
                    this.connectEdge(myEdge, requiredNode, currentNode);
                    this.setConnectionMagnets(myEdge);
                }
                if (ir.getRequiredAuthority() == null) continue;
                reqInputID = this.getId(ir.getRequiredAuthority());
                requiredNode = (Node)elems.get(reqInputID).getValue();
                myEdge = this.factoryManager.newElement(UUID.uuid(), AuthorityRequirement.class).asEdge();
                this.connectEdge(myEdge, requiredNode, currentNode);
                this.setConnectionMagnets(myEdge);
            }
        }
        Map<String, Node> textAnnotations = dmnXml.getArtifact().stream().filter(TextAnnotation.class::isInstance).map(TextAnnotation.class::cast).collect(Collectors.toMap(DMNElement::getId, this.textAnnotationConverter::nodeFromDMN));
        textAnnotations.values().forEach(n -> this.ddExtAugmentStunner(dmnDDDiagram, (Node)n));
        List associations = dmnXml.getArtifact().stream().filter(org.kie.dmn.model.v1_1.Association.class::isInstance).map(org.kie.dmn.model.v1_1.Association.class::cast).collect(Collectors.toList());
        for (org.kie.dmn.model.v1_1.Association a : associations) {
            String sourceId = this.getId(a.getSourceRef());
            Node sourceNode = Optional.ofNullable(elems.get(sourceId)).map(Map.Entry::getValue).orElse(textAnnotations.get(sourceId));
            String targetId = this.getId(a.getTargetRef());
            Node targetNode = Optional.ofNullable(elems.get(targetId)).map(Map.Entry::getValue).orElse(textAnnotations.get(targetId));
            Edge myEdge = this.factoryManager.newElement(UUID.uuid(), Association.class).asEdge();
            Id id = new Id(a.getId());
            Description description = new Description(a.getDescription());
            Association definition = new Association(id, description);
            ((View)myEdge.getContent()).setDefinition((Object)definition);
            this.connectEdge(myEdge, sourceNode, targetNode);
            this.setConnectionMagnets(myEdge);
        }
        Graph graph = this.factoryManager.newDiagram("prova", BindableAdapterUtils.getDefinitionSetId(DMNDefinitionSet.class), metadata).getGraph();
        elems.values().stream().map(kv -> (Node)kv.getValue()).forEach(arg_0 -> ((Graph)graph).addNode(arg_0));
        textAnnotations.values().forEach(arg_0 -> ((Graph)graph).addNode(arg_0));
        Node<?, ?> dmnDiagramRoot = DMNMarshaller.findDMNDiagramRoot(graph);
        org.kie.workbench.common.dmn.api.definition.v1_1.Definitions definitionsStunnerPojo = DefinitionsConverter.wbFromDMN(dmnXml);
        ((org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram)((View)dmnDiagramRoot.getContent()).getDefinition()).setDefinitions(definitionsStunnerPojo);
        elems.values().stream().map(kv -> (Node)kv.getValue()).forEach(node -> this.connectRootWithChild((Node)dmnDiagramRoot, (Node)node));
        textAnnotations.values().stream().forEach(node -> this.connectRootWithChild((Node)dmnDiagramRoot, (Node)node));
        return graph;
    }

    public static Node<?, ?> findDMNDiagramRoot(Graph<?, Node<View, ?>> graph) {
        return StreamSupport.stream(graph.nodes().spliterator(), false).filter(n -> ((View)n.getContent()).getDefinition() instanceof org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram).findFirst().orElseThrow(() -> new UnsupportedOperationException("TODO"));
    }

    private String getId(DMNElementReference er) {
        String href = er.getHref();
        return href.contains("#") ? href.substring(href.indexOf(35) + 1) : href;
    }

    private Node dmnToStunner(org.kie.dmn.model.v1_1.DRGElement dmn) {
        if (dmn instanceof InputData) {
            return this.inputDataConverter.nodeFromDMN((InputData)dmn);
        }
        if (dmn instanceof Decision) {
            return this.decisionConverter.nodeFromDMN((Decision)dmn);
        }
        if (dmn instanceof org.kie.dmn.model.v1_1.BusinessKnowledgeModel) {
            return this.bkmConverter.nodeFromDMN((org.kie.dmn.model.v1_1.BusinessKnowledgeModel)dmn);
        }
        if (dmn instanceof org.kie.dmn.model.v1_1.KnowledgeSource) {
            return this.knowledgeSourceConverter.nodeFromDMN((org.kie.dmn.model.v1_1.KnowledgeSource)dmn);
        }
        throw new UnsupportedOperationException("TODO");
    }

    private void connectRootWithChild(Node dmnDiagramRoot, Node child) {
        String uuid = UUID.uuid();
        EdgeImpl edge = new EdgeImpl(uuid);
        edge.setContent((Object)new Child());
        this.connectEdge((Edge)edge, dmnDiagramRoot, child);
    }

    private void connectEdge(Edge edge, Node source, Node target) {
        edge.setSourceNode(source);
        edge.setTargetNode(target);
        source.getOutEdges().add(edge);
        target.getInEdges().add(edge);
    }

    private void setConnectionMagnets(Edge edge) {
        Node targetNode;
        ViewConnector connectionContent = (ViewConnector)edge.getContent();
        Node sourceNode = edge.getSourceNode();
        if (null != sourceNode) {
            connectionContent.setSourceConnection((Connection)MagnetConnection.Builder.forElement((Element)sourceNode));
        }
        if (null != (targetNode = edge.getTargetNode())) {
            connectionContent.setTargetConnection((Connection)MagnetConnection.Builder.forElement((Element)targetNode));
        }
    }

    public String marshall(Diagram<Graph, Metadata> diagram) throws IOException {
        Graph g = diagram.getGraph();
        HashMap<String, org.kie.dmn.model.v1_1.DRGElement> nodes = new HashMap<String, org.kie.dmn.model.v1_1.DRGElement>();
        HashMap<String, TextAnnotation> textAnnotations = new HashMap<String, TextAnnotation>();
        Node<?, ?> dmnDiagramRoot = DMNMarshaller.findDMNDiagramRoot(g);
        org.kie.workbench.common.dmn.api.definition.v1_1.Definitions definitionsStunnerPojo = ((org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram)((View)dmnDiagramRoot.getContent()).getDefinition()).getDefinitions();
        Definitions definitions = DefinitionsConverter.dmnFromWB(definitionsStunnerPojo);
        if (definitions.getExtensionElements() == null) {
            definitions.setExtensionElements(new DMNElement.ExtensionElements());
        }
        DMNDiagram dmnDDDMNDiagram = new DMNDiagram();
        definitions.getExtensionElements().getAny().add(dmnDDDMNDiagram);
        for (Node node : g.nodes()) {
            if (!(node.getContent() instanceof View)) continue;
            View view = (View)node.getContent();
            if (view.getDefinition() instanceof DRGElement) {
                DRGElement n = (DRGElement)view.getDefinition();
                nodes.put(n.getId().getValue(), this.stunnerToDMN(node));
                dmnDDDMNDiagram.getAny().add(DMNMarshaller.stunnerToDDExt((View<? extends org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement>)view));
                continue;
            }
            if (!(view.getDefinition() instanceof org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation)) continue;
            org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation textAnnotation = (org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation)view.getDefinition();
            textAnnotations.put(textAnnotation.getId().getValue(), this.textAnnotationConverter.dmnFromNode((Node<View<org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation>, ?>)node));
            dmnDDDMNDiagram.getAny().add(DMNMarshaller.stunnerToDDExt((View<? extends org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement>)view));
            List<org.kie.dmn.model.v1_1.Association> associations = AssociationConverter.dmnFromWB(node);
            definitions.getArtifact().addAll(associations);
        }
        nodes.values().forEach(definitions.getDrgElement()::add);
        textAnnotations.values().forEach(definitions.getArtifact()::add);
        String marshalled = this.marshaller.marshal((Object)definitions);
        return marshalled;
    }

    private void ddExtAugmentStunner(Optional<DMNDiagram> dmnDDDiagram, Node currentNode) {
        if (!dmnDDDiagram.isPresent()) {
            return;
        }
        Stream<DMNShape> drgShapeStream = dmnDDDiagram.get().getAny().stream().filter(DMNShape.class::isInstance).map(DMNShape.class::cast);
        View content = (View)currentNode.getContent();
        if (content.getDefinition() instanceof org.kie.workbench.common.dmn.api.definition.v1_1.Decision) {
            org.kie.workbench.common.dmn.api.definition.v1_1.Decision d = (org.kie.workbench.common.dmn.api.definition.v1_1.Decision)content.getDefinition();
            this.internalAugment(drgShapeStream, d.getId(), content.getBounds().getUpperLeft(), d.getDimensionsSet(), content.getBounds().getLowerRight(), d.getBackgroundSet(), arg_0 -> ((org.kie.workbench.common.dmn.api.definition.v1_1.Decision)d).setFontSet(arg_0));
        } else if (content.getDefinition() instanceof org.kie.workbench.common.dmn.api.definition.v1_1.InputData) {
            org.kie.workbench.common.dmn.api.definition.v1_1.InputData d = (org.kie.workbench.common.dmn.api.definition.v1_1.InputData)content.getDefinition();
            this.internalAugment(drgShapeStream, d.getId(), content.getBounds().getUpperLeft(), d.getDimensionsSet(), content.getBounds().getLowerRight(), d.getBackgroundSet(), arg_0 -> ((org.kie.workbench.common.dmn.api.definition.v1_1.InputData)d).setFontSet(arg_0));
        } else if (content.getDefinition() instanceof BusinessKnowledgeModel) {
            BusinessKnowledgeModel d = (BusinessKnowledgeModel)content.getDefinition();
            this.internalAugment(drgShapeStream, d.getId(), content.getBounds().getUpperLeft(), d.getDimensionsSet(), content.getBounds().getLowerRight(), d.getBackgroundSet(), arg_0 -> ((BusinessKnowledgeModel)d).setFontSet(arg_0));
        } else if (content.getDefinition() instanceof KnowledgeSource) {
            KnowledgeSource d = (KnowledgeSource)content.getDefinition();
            this.internalAugment(drgShapeStream, d.getId(), content.getBounds().getUpperLeft(), d.getDimensionsSet(), content.getBounds().getLowerRight(), d.getBackgroundSet(), arg_0 -> ((KnowledgeSource)d).setFontSet(arg_0));
        } else if (content.getDefinition() instanceof org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation) {
            org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation d = (org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation)content.getDefinition();
            this.internalAugment(drgShapeStream, d.getId(), content.getBounds().getUpperLeft(), d.getDimensionsSet(), content.getBounds().getLowerRight(), d.getBackgroundSet(), arg_0 -> ((org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation)d).setFontSet(arg_0));
        }
    }

    private void internalAugment(Stream<DMNShape> drgShapeStream, Id id, Bounds.Bound ul, RectangleDimensionsSet dimensionsSet, Bounds.Bound lr, BackgroundSet bgset, Consumer<FontSet> fontSetSetter) {
        Optional<DMNShape> drgShapeOpt = drgShapeStream.filter(shape -> shape.getDmnElementRef().equals(id.getValue())).findFirst();
        if (!drgShapeOpt.isPresent()) {
            return;
        }
        DMNShape drgShape = drgShapeOpt.get();
        ((BoundImpl)ul).setX(Double.valueOf(drgShape.getBounds().getX()));
        ((BoundImpl)ul).setY(Double.valueOf(drgShape.getBounds().getY()));
        dimensionsSet.setWidth(new Width(Double.valueOf(drgShape.getBounds().getWidth())));
        dimensionsSet.setHeight(new Height(Double.valueOf(drgShape.getBounds().getHeight())));
        ((BoundImpl)lr).setX(Double.valueOf(drgShape.getBounds().getX() + drgShape.getBounds().getWidth()));
        ((BoundImpl)lr).setY(Double.valueOf(drgShape.getBounds().getY() + drgShape.getBounds().getHeight()));
        if (null != drgShape.getBgColor()) {
            bgset.setBgColour(new BgColour(ColorUtils.wbFromDMN(drgShape.getBgColor())));
        }
        if (null != drgShape.getBorderColor()) {
            bgset.setBorderColour(new BorderColour(ColorUtils.wbFromDMN(drgShape.getBorderColor())));
        }
        if (null != drgShape.getBorderSize()) {
            bgset.setBorderSize(new org.kie.workbench.common.dmn.api.property.background.BorderSize(drgShape.getBorderSize().getValue()));
        }
        if (null != drgShape.getFontStyle()) {
            fontSetSetter.accept(FontSetPropertyConverter.wbFromDMN(drgShape.getFontStyle()));
        }
    }

    private static DMNShape stunnerToDDExt(View<? extends org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement> v) {
        DMNShape result = new DMNShape();
        result.setId("dmnshape-" + ((org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement)v.getDefinition()).getId().getValue());
        result.setDmnElementRef(((org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement)v.getDefinition()).getId().getValue());
        Bounds bounds = new Bounds();
        result.setBounds(bounds);
        bounds.setX(v.getBounds().getUpperLeft().getX());
        bounds.setY(v.getBounds().getUpperLeft().getY());
        if (v.getDefinition() instanceof org.kie.workbench.common.dmn.api.definition.v1_1.Decision) {
            org.kie.workbench.common.dmn.api.definition.v1_1.Decision d = (org.kie.workbench.common.dmn.api.definition.v1_1.Decision)v.getDefinition();
            DMNMarshaller.applyBounds(d.getDimensionsSet(), bounds);
            DMNMarshaller.applyBackgroundStyles(d.getBackgroundSet(), result);
            result.setFontStyle(FontSetPropertyConverter.dmnFromWB(d.getFontSet()));
        } else if (v.getDefinition() instanceof org.kie.workbench.common.dmn.api.definition.v1_1.InputData) {
            org.kie.workbench.common.dmn.api.definition.v1_1.InputData d = (org.kie.workbench.common.dmn.api.definition.v1_1.InputData)v.getDefinition();
            DMNMarshaller.applyBounds(d.getDimensionsSet(), bounds);
            DMNMarshaller.applyBackgroundStyles(d.getBackgroundSet(), result);
            result.setFontStyle(FontSetPropertyConverter.dmnFromWB(d.getFontSet()));
        } else if (v.getDefinition() instanceof BusinessKnowledgeModel) {
            BusinessKnowledgeModel d = (BusinessKnowledgeModel)v.getDefinition();
            DMNMarshaller.applyBounds(d.getDimensionsSet(), bounds);
            DMNMarshaller.applyBackgroundStyles(d.getBackgroundSet(), result);
            result.setFontStyle(FontSetPropertyConverter.dmnFromWB(d.getFontSet()));
        } else if (v.getDefinition() instanceof KnowledgeSource) {
            KnowledgeSource d = (KnowledgeSource)v.getDefinition();
            DMNMarshaller.applyBounds(d.getDimensionsSet(), bounds);
            DMNMarshaller.applyBackgroundStyles(d.getBackgroundSet(), result);
            result.setFontStyle(FontSetPropertyConverter.dmnFromWB(d.getFontSet()));
        } else if (v.getDefinition() instanceof org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation) {
            org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation d = (org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation)v.getDefinition();
            DMNMarshaller.applyBounds(d.getDimensionsSet(), bounds);
            DMNMarshaller.applyBackgroundStyles(d.getBackgroundSet(), result);
            result.setFontStyle(FontSetPropertyConverter.dmnFromWB(d.getFontSet()));
        }
        return result;
    }

    private static void applyBounds(RectangleDimensionsSet dimensionsSet, Bounds bounds) {
        if (null != dimensionsSet.getWidth().getValue() && null != dimensionsSet.getHeight().getValue()) {
            bounds.setWidth(dimensionsSet.getWidth().getValue());
            bounds.setHeight(dimensionsSet.getHeight().getValue());
        }
    }

    private static void applyBackgroundStyles(BackgroundSet bgset, DMNShape result) {
        if (null != bgset.getBgColour().getValue()) {
            result.setBgColor(ColorUtils.dmnFromWB(bgset.getBgColour().getValue()));
        }
        if (null != bgset.getBorderColour().getValue()) {
            result.setBorderColor(ColorUtils.dmnFromWB(bgset.getBorderColour().getValue()));
        }
        if (null != bgset.getBorderSize().getValue()) {
            result.setBorderSize(new BorderSize(bgset.getBorderSize().getValue()));
        }
    }

    private org.kie.dmn.model.v1_1.DRGElement stunnerToDMN(Node<?, ?> node) {
        if (node.getContent() instanceof View) {
            View view = (View)node.getContent();
            if (view.getDefinition() instanceof org.kie.workbench.common.dmn.api.definition.v1_1.InputData) {
                return this.inputDataConverter.dmnFromNode((Node<View<org.kie.workbench.common.dmn.api.definition.v1_1.InputData>, ?>)node);
            }
            if (view.getDefinition() instanceof org.kie.workbench.common.dmn.api.definition.v1_1.Decision) {
                return this.decisionConverter.dmnFromNode((Node<View<org.kie.workbench.common.dmn.api.definition.v1_1.Decision>, ?>)node);
            }
            if (view.getDefinition() instanceof BusinessKnowledgeModel) {
                return this.bkmConverter.dmnFromNode((Node<View<BusinessKnowledgeModel>, ?>)node);
            }
            if (view.getDefinition() instanceof KnowledgeSource) {
                return this.knowledgeSourceConverter.dmnFromNode((Node<View<KnowledgeSource>, ?>)node);
            }
            throw new UnsupportedOperationException("TODO");
        }
        throw new RuntimeException("wrong diagram structure to marshall");
    }

    public DiagramMetadataMarshaller<Metadata> getMetadataMarshaller() {
        return this.diagramMetadataMarshaller;
    }
}

