/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.common;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.marshalling.DMNImportTypesHelper;
import org.kie.workbench.common.dmn.backend.common.DMNImportTypesHelperImpl;
import org.kie.workbench.common.dmn.backend.common.DMNPathsHelperImpl;
import org.kie.workbench.common.services.refactoring.backend.server.query.RefactoringQueryServiceImpl;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRequest;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.service.RefactoringQueryService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Path;
import org.uberfire.paging.PageResponse;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class DMNPathsHelperImplTest {
    @Mock
    private RefactoringQueryServiceImpl refactoringQueryService;
    @Mock
    private IOService ioService;
    @Mock
    private PageResponse<RefactoringPageRow> pageResponse;
    @Mock
    private WorkspaceProject workspaceProject;
    private DMNImportTypesHelper importTypesHelper;
    private DMNPathsHelperImpl pathsHelper;

    @Before
    public void setup() {
        this.importTypesHelper = new DMNImportTypesHelperImpl();
        this.pathsHelper = (DMNPathsHelperImpl)Mockito.spy((Object)new DMNPathsHelperImpl((RefactoringQueryService)this.refactoringQueryService, this.importTypesHelper, this.ioService));
    }

    @Test
    public void testGetModelsPathsWhenWorkspaceProjectIsNull() {
        this.doTestGetPathsWhenWorkspaceProjectIsNull(workspaceProject1 -> this.pathsHelper.getModelsPaths(null));
    }

    @Test
    public void testGetDMNModelsPathsWhenWorkspaceProjectIsNull() {
        this.doTestGetPathsWhenWorkspaceProjectIsNull(workspaceProject1 -> this.pathsHelper.getDMNModelsPaths(null));
    }

    @Test
    public void testGetPMMLDocumentsPathsWhenWorkspaceProjectIsNull() {
        this.doTestGetPathsWhenWorkspaceProjectIsNull(workspaceProject1 -> this.pathsHelper.getPMMLModelsPaths(null));
    }

    private void doTestGetPathsWhenWorkspaceProjectIsNull(Function<WorkspaceProject, List<org.uberfire.backend.vfs.Path>> paths) {
        Path nioPath1 = (Path)Mockito.mock(Path.class);
        Path nioPath2 = (Path)Mockito.mock(Path.class);
        org.uberfire.backend.vfs.Path path1 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path path2 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        DirectoryStreamFake fakeStream = new DirectoryStreamFake(nioPath1, nioPath2);
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)fakeStream).when((Object)this.pathsHelper)).getStandaloneModelPaths((DirectoryStream.Filter)ArgumentMatchers.any(DirectoryStream.Filter.class));
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)path1).when((Object)this.pathsHelper)).convertPath(nioPath1);
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)path2).when((Object)this.pathsHelper)).convertPath(nioPath2);
        List<org.uberfire.backend.vfs.Path> expectedPaths = Arrays.asList(path1, path2);
        List<org.uberfire.backend.vfs.Path> actualPaths = paths.apply(null);
        Assert.assertEquals(expectedPaths, actualPaths);
    }

    @Test
    public void testGetModelsPathsWhenWorkspaceProjectIsNotNull() {
        this.doTestGetPathsWhenWorkspaceProjectIsNotNull(workspaceProject -> this.pathsHelper.getModelsPaths(workspaceProject));
    }

    @Test
    public void testGetDMNModelsPathsWhenWorkspaceProjectIsNotNull() {
        this.doTestGetPathsWhenWorkspaceProjectIsNotNull(workspaceProject -> this.pathsHelper.getDMNModelsPaths(workspaceProject));
    }

    @Test
    public void testGetPMMLDocumentsPathsWhenWorkspaceProjectIsNotNull() {
        this.doTestGetPathsWhenWorkspaceProjectIsNotNull(workspaceProject -> this.pathsHelper.getPMMLModelsPaths(workspaceProject));
    }

    private void doTestGetPathsWhenWorkspaceProjectIsNotNull(Function<WorkspaceProject, List<org.uberfire.backend.vfs.Path>> paths) {
        org.uberfire.backend.vfs.Path rootPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        String uri = "/src/path//project/root";
        RefactoringPageRow row1 = (RefactoringPageRow)Mockito.mock(RefactoringPageRow.class);
        RefactoringPageRow row2 = (RefactoringPageRow)Mockito.mock(RefactoringPageRow.class);
        RefactoringPageRow row3 = (RefactoringPageRow)Mockito.mock(RefactoringPageRow.class);
        List<RefactoringPageRow> rows = Arrays.asList(row1, row2, row3);
        org.uberfire.backend.vfs.Path path1 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path path2 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path path3 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)this.workspaceProject.getRootPath()).thenReturn((Object)rootPath);
        Mockito.when((Object)rootPath.toURI()).thenReturn((Object)"/src/path//project/root");
        Mockito.when((Object)this.refactoringQueryService.query((RefactoringPageRequest)ArgumentMatchers.any(RefactoringPageRequest.class))).thenReturn(this.pageResponse);
        Mockito.when((Object)this.pageResponse.getPageRowList()).thenReturn(rows);
        Mockito.when((Object)row1.getValue()).thenReturn((Object)path1);
        Mockito.when((Object)row2.getValue()).thenReturn((Object)path2);
        Mockito.when((Object)row3.getValue()).thenReturn((Object)path3);
        List<org.uberfire.backend.vfs.Path> result = paths.apply(this.workspaceProject);
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((Object)path1, (Object)result.get(0));
        Assert.assertEquals((Object)path2, (Object)result.get(1));
        Assert.assertEquals((Object)path3, (Object)result.get(2));
    }

    @Test
    public void testGetStandaloneModelPaths() {
        Path root = (Path)Mockito.mock(Path.class);
        DirectoryStream.Filter filter = path -> true;
        DirectoryStreamFake expectedStream = new DirectoryStreamFake(new Path[0]);
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)root).when((Object)this.pathsHelper)).getStandaloneRootPath();
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)filter).when((Object)this.pathsHelper)).allModelsFilter();
        Mockito.when((Object)this.ioService.newDirectoryStream(root, filter)).thenReturn((Object)expectedStream);
        DirectoryStream actualStream = this.pathsHelper.getStandaloneModelPaths(filter);
        Assert.assertEquals((Object)expectedStream, (Object)actualStream);
    }

    @Test
    public void testAllModelsFilter() {
        DirectoryStream.Filter filter = this.pathsHelper.allModelsFilter();
        Path nioPath1 = (Path)Mockito.mock(Path.class);
        Path nioPath2 = (Path)Mockito.mock(Path.class);
        Path nioPath3 = (Path)Mockito.mock(Path.class);
        org.uberfire.backend.vfs.Path path1 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path path2 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path path3 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)path1.getFileName()).thenReturn((Object)"/Users/karreiro/projects/dmn-project/model.dmn");
        Mockito.when((Object)path2.getFileName()).thenReturn((Object)"/Users/karreiro/projects/dmn-project/document.pmml");
        Mockito.when((Object)path3.getFileName()).thenReturn((Object)"/Users/karreiro/projects/dmn-project/Readme.md");
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)path1).when((Object)this.pathsHelper)).convertPath(nioPath1);
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)path2).when((Object)this.pathsHelper)).convertPath(nioPath2);
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)path3).when((Object)this.pathsHelper)).convertPath(nioPath3);
        Assert.assertTrue((boolean)filter.accept((Object)nioPath1));
        Assert.assertTrue((boolean)filter.accept((Object)nioPath2));
        Assert.assertFalse((boolean)filter.accept((Object)nioPath3));
    }

    @Test
    public void testDMNModelFilter() {
        DirectoryStream.Filter filter = this.pathsHelper.dmnModelFilter();
        Path nioPath1 = (Path)Mockito.mock(Path.class);
        Path nioPath2 = (Path)Mockito.mock(Path.class);
        org.uberfire.backend.vfs.Path path1 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path path2 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)path1.getFileName()).thenReturn((Object)"/Users/karreiro/projects/dmn-project/file.dmn");
        Mockito.when((Object)path2.getFileName()).thenReturn((Object)"/Users/karreiro/projects/dmn-project/Readme.md");
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)path1).when((Object)this.pathsHelper)).convertPath(nioPath1);
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)path2).when((Object)this.pathsHelper)).convertPath(nioPath2);
        Assert.assertTrue((boolean)filter.accept((Object)nioPath1));
        Assert.assertFalse((boolean)filter.accept((Object)nioPath2));
    }

    @Test
    public void testPMMLDocumentFilter() {
        DirectoryStream.Filter filter = this.pathsHelper.pmmlDocumentFilter();
        Path nioPath1 = (Path)Mockito.mock(Path.class);
        Path nioPath2 = (Path)Mockito.mock(Path.class);
        org.uberfire.backend.vfs.Path path1 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path path2 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)path1.getFileName()).thenReturn((Object)"/Users/karreiro/projects/dmn-project/file.pmml");
        Mockito.when((Object)path2.getFileName()).thenReturn((Object)"/Users/karreiro/projects/dmn-project/Readme.md");
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)path1).when((Object)this.pathsHelper)).convertPath(nioPath1);
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)path2).when((Object)this.pathsHelper)).convertPath(nioPath2);
        Assert.assertTrue((boolean)filter.accept((Object)nioPath1));
        Assert.assertFalse((boolean)filter.accept((Object)nioPath2));
    }

    @Test
    public void testGetStandaloneRootPath() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Path expectedPath = (Path)Mockito.mock(Path.class);
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)path).when((Object)this.pathsHelper)).newPath("diagrams", "default://master@system/stunner/diagrams");
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)expectedPath).when((Object)this.pathsHelper)).convertPath(path);
        Path actualPath = this.pathsHelper.getStandaloneRootPath();
        Assert.assertEquals((Object)expectedPath, (Object)actualPath);
    }

    @Test
    public void testGetRelativeURIWhenStandalone() {
        org.uberfire.backend.vfs.Path includedModelPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)includedModelPath.getFileName()).thenReturn((Object)"file1");
        Assert.assertEquals((Object)"file1", (Object)this.pathsHelper.getRelativeURI(null, includedModelPath));
    }

    @Test
    public void testGetRelativeURIWhenSameLevel() {
        this.doTestGetRelativeURI("dmnModel.dmn", "includedModel.dmn", "../includedModel.dmn", "includedModel.dmn");
    }

    @Test
    public void testGetRelativeURIWithForwardReference() {
        this.doTestGetRelativeURI("dmnModel.dmn", "folder/includedModel.dmn", "folder/includedModel.dmn", "folder/includedModel.dmn");
    }

    @Test
    public void testGetRelativeURIWithBackwardReference() {
        this.doTestGetRelativeURI("folder/dmnModel.dmn", "includedModel.dmn", "../../includedModel.dmn", "../includedModel.dmn");
    }

    private void doTestGetRelativeURI(String dmnModelURI, String includedModelURI, String relativizedURI, String relativeURI) {
        org.uberfire.backend.vfs.Path dmnModelPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path includedModelPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Path nioDMNModelPath = (Path)Mockito.mock(Path.class);
        Path nioIncludedModelPath = (Path)Mockito.mock(Path.class);
        Path nioRelativePath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)dmnModelPath.getFileName()).thenReturn((Object)dmnModelURI);
        Mockito.when((Object)includedModelPath.getFileName()).thenReturn((Object)includedModelURI);
        Mockito.when((Object)nioDMNModelPath.relativize(nioIncludedModelPath)).thenReturn((Object)nioRelativePath);
        Mockito.when((Object)nioRelativePath.toString()).thenReturn((Object)relativizedURI);
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)dmnModelPath).when((Object)this.pathsHelper)).normalizePath(dmnModelPath);
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)includedModelPath).when((Object)this.pathsHelper)).normalizePath(includedModelPath);
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)nioDMNModelPath).when((Object)this.pathsHelper)).convertPath(dmnModelPath);
        ((DMNPathsHelperImpl)Mockito.doReturn((Object)nioIncludedModelPath).when((Object)this.pathsHelper)).convertPath(includedModelPath);
        Assert.assertEquals((Object)relativeURI, (Object)this.pathsHelper.getRelativeURI(dmnModelPath, includedModelPath));
    }

    class DirectoryStreamFake
    implements DirectoryStream<Path> {
        private List<Path> paths;

        DirectoryStreamFake(Path ... paths) {
            this.paths = Arrays.asList(paths);
        }

        public Iterator<Path> iterator() {
            return this.paths.iterator();
        }

        public void close() throws IOException {
        }
    }
}

