/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.model.api.RuleAnnotation;
import org.kie.dmn.model.v1_2.TDecisionRule;
import org.kie.dmn.model.v1_2.TLiteralExpression;
import org.kie.dmn.model.v1_2.TRuleAnnotation;
import org.kie.dmn.model.v1_2.TUnaryTests;
import org.kie.workbench.common.dmn.api.definition.model.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.RuleAnnotationClauseText;
import org.kie.workbench.common.dmn.api.definition.model.UnaryTests;
import org.kie.workbench.common.dmn.backend.definition.v1_1.DecisionRulePropertyConverter;

public class DecisionRulePropertyConverterTest {
    private static final String ID = "uuid";
    private static final String DESCRIPTION = "description";

    @Test
    public void testWbFromDMN() {
        TUnaryTests inputEntry = new TUnaryTests();
        TLiteralExpression outputEntry = new TLiteralExpression();
        TDecisionRule dmn = new TDecisionRule();
        dmn.setId(ID);
        dmn.setDescription(DESCRIPTION);
        dmn.getInputEntry().add(inputEntry);
        dmn.getOutputEntry().add(outputEntry);
        DecisionRule wb = DecisionRulePropertyConverter.wbFromDMN((org.kie.dmn.model.api.DecisionRule)dmn);
        Assert.assertEquals((Object)ID, (Object)wb.getId().getValue());
        Assert.assertEquals((Object)"", (Object)wb.getDescription().getValue());
        Assert.assertEquals((Object)wb, (Object)((UnaryTests)wb.getInputEntry().get(0)).getParent());
        Assert.assertEquals((Object)wb, (Object)((LiteralExpression)wb.getOutputEntry().get(0)).getParent());
        Assert.assertEquals((long)1L, (long)wb.getAnnotationEntry().size());
        Assert.assertEquals((Object)DESCRIPTION, (Object)((RuleAnnotationClauseText)wb.getAnnotationEntry().get(0)).getText().getValue());
    }

    @Test
    public void testWbFromDMNWithAnnotationRules() {
        TDecisionRule dmn = new TDecisionRule();
        String annotation1 = "some annotation";
        String annotation2 = "some other annotation";
        RuleAnnotation ruleAnnotation1 = this.createRuleAnnotation("some annotation");
        RuleAnnotation ruleAnnotation2 = this.createRuleAnnotation("some other annotation");
        dmn.getAnnotationEntry().add(ruleAnnotation1);
        dmn.getAnnotationEntry().add(ruleAnnotation2);
        dmn.setId(ID);
        DecisionRule wb = DecisionRulePropertyConverter.wbFromDMN((org.kie.dmn.model.api.DecisionRule)dmn);
        Assert.assertEquals((Object)ID, (Object)wb.getId().getValue());
        Assert.assertEquals((long)2L, (long)wb.getAnnotationEntry().size());
        Assert.assertEquals((Object)"some annotation", (Object)((RuleAnnotationClauseText)wb.getAnnotationEntry().get(0)).getText().getValue());
        Assert.assertEquals((Object)"some other annotation", (Object)((RuleAnnotationClauseText)wb.getAnnotationEntry().get(1)).getText().getValue());
    }

    @Test
    public void testDmnFromWb() {
        UnaryTests inputEntry = new UnaryTests();
        LiteralExpression outputEntry = new LiteralExpression();
        DecisionRule wb = new DecisionRule();
        wb.getId().setValue(ID);
        wb.getDescription().setValue(DESCRIPTION);
        wb.getInputEntry().add(inputEntry);
        wb.getOutputEntry().add(outputEntry);
        org.kie.dmn.model.api.DecisionRule dmn = DecisionRulePropertyConverter.dmnFromWB((DecisionRule)wb);
        Assert.assertEquals((Object)ID, (Object)dmn.getId());
        Assert.assertEquals((Object)DESCRIPTION, (Object)dmn.getDescription());
        Assert.assertEquals((Object)dmn, (Object)((org.kie.dmn.model.api.UnaryTests)dmn.getInputEntry().get(0)).getParent());
        Assert.assertEquals((Object)dmn, (Object)((org.kie.dmn.model.api.LiteralExpression)dmn.getOutputEntry().get(0)).getParent());
    }

    @Test
    public void testDmnFromWbWithAnnotationRules() {
        DecisionRule wb = new DecisionRule();
        String annotation1 = "the text one";
        String annotation2 = "the text two";
        RuleAnnotationClauseText ruleAnnotation1 = this.createWbRuleAnnotation("the text one");
        RuleAnnotationClauseText ruleAnnotation2 = this.createWbRuleAnnotation("the text two");
        wb.getAnnotationEntry().add(ruleAnnotation1);
        wb.getAnnotationEntry().add(ruleAnnotation2);
        org.kie.dmn.model.api.DecisionRule dmn = DecisionRulePropertyConverter.dmnFromWB((DecisionRule)wb);
        Assert.assertEquals((long)2L, (long)dmn.getAnnotationEntry().size());
        Assert.assertEquals((Object)"the text one", (Object)((RuleAnnotation)dmn.getAnnotationEntry().get(0)).getText());
        Assert.assertEquals((Object)"the text two", (Object)((RuleAnnotation)dmn.getAnnotationEntry().get(1)).getText());
    }

    private RuleAnnotationClauseText createWbRuleAnnotation(String text) {
        RuleAnnotationClauseText annotation = new RuleAnnotationClauseText();
        annotation.getText().setValue(text);
        return annotation;
    }

    private RuleAnnotation createRuleAnnotation(String annotation) {
        TRuleAnnotation ruleAnnotation = new TRuleAnnotation();
        ruleAnnotation.setText(annotation);
        return ruleAnnotation;
    }
}

