/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.canvas.controls.builder;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.HasVariable;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.IsInformationItem;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.canvas.controls.builder.ObserverBuilderControl;
import org.kie.workbench.common.forms.adf.definitions.DynamicReadOnly;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ObserverBuilderControlTest {
    @Mock
    private ObserverBuilderControl observerBuilderControl;

    @Before
    public void setup() {
        ((ObserverBuilderControl)Mockito.doCallRealMethod().when((Object)this.observerBuilderControl)).updateElementFromDefinition((Element)Matchers.anyObject(), Matchers.anyObject());
    }

    @Test
    public void testUpdateNameFromDefinition() {
        String expectedName = "expectedName";
        Element element = (Element)Mockito.mock(Element.class);
        View elementContent = (View)Mockito.mock(View.class);
        HasName newDefinition = (HasName)Mockito.mock(HasName.class);
        Name newDefinitionName = (Name)Mockito.mock(Name.class);
        HasName definition = (HasName)Mockito.mock(HasName.class);
        Name definitionName = (Name)Mockito.mock(Name.class);
        Mockito.when((Object)element.getContent()).thenReturn((Object)elementContent);
        Mockito.when((Object)elementContent.getDefinition()).thenReturn((Object)newDefinition);
        Mockito.when((Object)newDefinition.getName()).thenReturn((Object)newDefinitionName);
        Mockito.when((Object)definition.getName()).thenReturn((Object)definitionName);
        Mockito.when((Object)definitionName.getValue()).thenReturn((Object)"expectedName");
        this.observerBuilderControl.updateElementFromDefinition(element, (Object)definition);
        ((Name)Mockito.verify((Object)newDefinitionName)).setValue("expectedName");
    }

    @Test
    public void testUpdateDynamicReadOnlyTrueFromDefinition() {
        this.testUpdateDynamicReadOnlyFromDefinition(true);
    }

    @Test
    public void testUpdateDynamicReadOnlyFalseFromDefinition() {
        this.testUpdateDynamicReadOnlyFromDefinition(false);
    }

    private void testUpdateDynamicReadOnlyFromDefinition(boolean expectedDynamicReadOnlyValue) {
        Element element = (Element)Mockito.mock(Element.class);
        View elementContent = (View)Mockito.mock(View.class);
        DynamicReadOnly newDefinition = (DynamicReadOnly)Mockito.mock(DynamicReadOnly.class);
        DynamicReadOnly definition = (DynamicReadOnly)Mockito.mock(DynamicReadOnly.class);
        Mockito.when((Object)element.getContent()).thenReturn((Object)elementContent);
        Mockito.when((Object)elementContent.getDefinition()).thenReturn((Object)newDefinition);
        Mockito.when((Object)definition.isAllowOnlyVisualChange()).thenReturn((Object)expectedDynamicReadOnlyValue);
        this.observerBuilderControl.updateElementFromDefinition(element, (Object)definition);
        ((DynamicReadOnly)Mockito.verify((Object)newDefinition)).setAllowOnlyVisualChange(expectedDynamicReadOnlyValue);
    }

    @Test
    public void testUpdateIdFromDefinition() {
        String expectedId = "happyId";
        Element element = (Element)Mockito.mock(Element.class);
        View elementContent = (View)Mockito.mock(View.class);
        DMNElement newDefinition = (DMNElement)Mockito.mock(DMNElement.class);
        Id newDefinitionId = (Id)Mockito.mock(Id.class);
        DMNElement definition = (DMNElement)Mockito.mock(DMNElement.class);
        Id definitionId = (Id)Mockito.mock(Id.class);
        Mockito.when((Object)element.getContent()).thenReturn((Object)elementContent);
        Mockito.when((Object)elementContent.getDefinition()).thenReturn((Object)newDefinition);
        Mockito.when((Object)newDefinition.getId()).thenReturn((Object)newDefinitionId);
        Mockito.when((Object)definition.getId()).thenReturn((Object)definitionId);
        Mockito.when((Object)definitionId.getValue()).thenReturn((Object)"happyId");
        this.observerBuilderControl.updateElementFromDefinition(element, (Object)definition);
        ((Id)Mockito.verify((Object)newDefinitionId)).setValue("happyId");
    }

    @Test
    public void testUpdateExpressionFromDefinition() {
        Element element = (Element)Mockito.mock(Element.class);
        View elementContent = (View)Mockito.mock(View.class);
        HasExpression newHasExpression = (HasExpression)Mockito.mock(HasExpression.class);
        HasExpression hasExpression = (HasExpression)Mockito.mock(HasExpression.class);
        Expression expression = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)element.getContent()).thenReturn((Object)elementContent);
        Mockito.when((Object)elementContent.getDefinition()).thenReturn((Object)newHasExpression);
        Mockito.when((Object)hasExpression.getExpression()).thenReturn((Object)expression);
        this.observerBuilderControl.updateElementFromDefinition(element, (Object)hasExpression);
        ((HasExpression)Mockito.verify((Object)newHasExpression)).setExpression(expression);
    }

    @Test
    public void testUpdateVariableFromDefinition() {
        Element element = (Element)Mockito.mock(Element.class);
        View elementContent = (View)Mockito.mock(View.class);
        HasVariable newHasVariable = (HasVariable)Mockito.mock(HasVariable.class);
        HasVariable hasVariable = (HasVariable)Mockito.mock(HasVariable.class);
        IsInformationItem isInformationItem = (IsInformationItem)Mockito.mock(IsInformationItem.class);
        Mockito.when((Object)element.getContent()).thenReturn((Object)elementContent);
        Mockito.when((Object)elementContent.getDefinition()).thenReturn((Object)newHasVariable);
        Mockito.when((Object)hasVariable.getVariable()).thenReturn((Object)isInformationItem);
        this.observerBuilderControl.updateElementFromDefinition(element, (Object)hasVariable);
        ((HasVariable)Mockito.verify((Object)newHasVariable)).setVariable(isInformationItem);
    }
}

