/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.canvas.controls.resize;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.Decision;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionService;
import org.kie.workbench.common.dmn.api.property.dmn.DecisionServiceDividerLineY;
import org.kie.workbench.common.dmn.client.canvas.controls.resize.DecisionServiceMoveDividerControl;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.shape.view.decisionservice.DecisionServiceSVGShapeView;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.command.UpdateElementPropertyCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.definition.adapter.AdapterManager;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.PropertyAdapter;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.registry.definition.AdapterRegistry;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DecisionServiceMoveDividerControlTest {
    private static final String ELEMENT_UUID = "uuid";
    private static final double DIVIDER_Y = 25.0;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Canvas canvas;
    @Mock
    private Shape shape;
    @Mock
    private DefaultCanvasCommandFactory canvasCommandFactory;
    @Mock
    private RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> commandManagerProvider;
    @Mock
    private CanvasCommandManager<AbstractCanvasHandler> commandManager;
    @Mock
    private Element element;
    @Mock
    private Definition definition;
    @Captor
    private ArgumentCaptor<DragHandler> dragHandlerCaptor;
    private DecisionServiceMoveDividerControl control;

    @Before
    public void setup() {
        Mockito.when((Object)this.commandManagerProvider.getCommandManager()).thenReturn(this.commandManager);
        Mockito.when((Object)this.element.getUUID()).thenReturn((Object)ELEMENT_UUID);
        Mockito.when((Object)this.element.getContent()).thenReturn((Object)this.definition);
        Mockito.when((Object)this.canvasHandler.getCanvas()).thenReturn((Object)this.canvas);
        Mockito.when((Object)this.canvas.getShape(ELEMENT_UUID)).thenReturn((Object)this.shape);
        this.control = (DecisionServiceMoveDividerControl)Mockito.spy((Object)new DecisionServiceMoveDividerControl(this.canvasCommandFactory));
        this.control.setCommandManagerProvider(this.commandManagerProvider);
        this.control.init(this.canvasHandler);
    }

    @Test
    public void testCommandManager() {
        Assertions.assertThat((Object)this.control.getCommandManager()).isEqualTo(this.commandManager);
    }

    @Test
    public void testRegisterDecisionServiceElement() {
        DecisionService decisionService = (DecisionService)Mockito.mock(DecisionService.class);
        DecisionServiceSVGShapeView decisionServiceShapeView = (DecisionServiceSVGShapeView)Mockito.mock(DecisionServiceSVGShapeView.class);
        Mockito.when((Object)this.definition.getDefinition()).thenReturn((Object)decisionService);
        Mockito.when((Object)this.shape.getShapeView()).thenReturn((Object)decisionServiceShapeView);
        this.control.register(this.element);
        ((DecisionServiceMoveDividerControl)Mockito.verify((Object)this.control)).registerHandler(Matchers.anyString(), (ViewHandler)Matchers.any(ViewHandler.class));
    }

    @Test
    public void testRegisterDecisionServiceElementDragEnd() {
        DefinitionManager definitionManager = (DefinitionManager)Mockito.mock(DefinitionManager.class);
        AdapterManager adapterManager = (AdapterManager)Mockito.mock(AdapterManager.class);
        AdapterRegistry adapterRegistry = (AdapterRegistry)Mockito.mock(AdapterRegistry.class);
        PropertyAdapter propertyAdapter = (PropertyAdapter)Mockito.mock(PropertyAdapter.class);
        DefinitionAdapter definitionAdapter = (DefinitionAdapter)Mockito.mock(DefinitionAdapter.class);
        DecisionServiceDividerLineY dividerLineY = new DecisionServiceDividerLineY();
        Optional<DecisionServiceDividerLineY> dividerYProperty = Optional.of(dividerLineY);
        UpdateElementPropertyCommand updateElementPropertyCommand = (UpdateElementPropertyCommand)Mockito.mock(UpdateElementPropertyCommand.class);
        DecisionService decisionService = (DecisionService)Mockito.mock(DecisionService.class);
        DecisionServiceSVGShapeView decisionServiceShapeView = (DecisionServiceSVGShapeView)Mockito.mock(DecisionServiceSVGShapeView.class);
        DragEvent dragEvent = (DragEvent)Mockito.mock(DragEvent.class);
        Mockito.when((Object)this.canvasHandler.getDefinitionManager()).thenReturn((Object)definitionManager);
        Mockito.when((Object)definitionManager.adapters()).thenReturn((Object)adapterManager);
        Mockito.when((Object)adapterManager.registry()).thenReturn((Object)adapterRegistry);
        Mockito.when((Object)adapterManager.forProperty()).thenReturn((Object)propertyAdapter);
        Mockito.when((Object)adapterRegistry.getDefinitionAdapter((Class)Matchers.any(Class.class))).thenReturn((Object)definitionAdapter);
        Mockito.when((Object)definitionAdapter.getProperty((Object)decisionService, "dividerLineY")).thenReturn(dividerYProperty);
        Mockito.when((Object)propertyAdapter.getId((Object)dividerLineY)).thenReturn((Object)"dividerLineY");
        Mockito.when((Object)this.canvasCommandFactory.updatePropertyValue((Element)Matchers.eq((Object)this.element), (String)Matchers.eq((Object)"dividerLineY"), Matchers.anyObject())).thenReturn((Object)updateElementPropertyCommand);
        Mockito.when((Object)this.definition.getDefinition()).thenReturn((Object)decisionService);
        Mockito.when((Object)this.shape.getShapeView()).thenReturn((Object)decisionServiceShapeView);
        this.control.register(this.element);
        ((DecisionServiceSVGShapeView)Mockito.verify((Object)decisionServiceShapeView)).addDividerDragHandler((DragHandler)this.dragHandlerCaptor.capture());
        Mockito.when((Object)decisionServiceShapeView.getDividerLineY()).thenReturn((Object)25.0);
        DragHandler dragHandler = (DragHandler)this.dragHandlerCaptor.getValue();
        dragHandler.end(dragEvent);
        ((DefaultCanvasCommandFactory)Mockito.verify((Object)this.canvasCommandFactory)).updatePropertyValue((Element)Matchers.eq((Object)this.element), (String)Matchers.eq((Object)"dividerLineY"), (Object)Matchers.eq((double)25.0));
        ((CanvasCommandManager)Mockito.verify(this.commandManager)).execute(Matchers.eq((Object)this.canvasHandler), (Command)Matchers.eq((Object)updateElementPropertyCommand));
    }

    @Test
    public void testRegisterNonDecisionServiceElement() {
        Decision decision = (Decision)Mockito.mock(Decision.class);
        Mockito.when((Object)this.definition.getDefinition()).thenReturn((Object)decision);
        this.control.register(this.element);
        ((DecisionServiceMoveDividerControl)Mockito.verify((Object)this.control, (VerificationMode)Mockito.never())).registerHandler(Matchers.anyString(), (ViewHandler)Matchers.any(ViewHandler.class));
    }
}

