/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.canvas.controls.selection;

import com.ait.lienzo.client.core.event.OnEventHandlers;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.shape.wires.WiresManager;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.canvas.controls.selection.DomainObjectAwareLienzoMultipleSelectionControl;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.processing.index.Index;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DomainObjectAwareLienzoMultipleSelectionControlTest {
    private static final String LAYER_UUID = "layer-uuid";
    private static final String DIAGRAM_UUID = "diagram-uuid";
    private static final String ELEMENT_UUID = "element-uuid";
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Diagram diagram;
    @Mock
    private Metadata diagramMetadata;
    @Mock
    private Index graphIndex;
    @Mock
    private WiresCanvas canvas;
    @Mock
    private Layer lienzoLayer;
    @Mock
    private Viewport lienzoViewport;
    @Mock
    private OnEventHandlers lienzoOnEventHandlers;
    @Mock
    private Object definition;
    @Mock
    private Element element;
    @Mock
    private DomainObject domainObject;
    @Mock
    private EventSourceMock<CanvasSelectionEvent> canvasSelectionEvent;
    @Mock
    private EventSourceMock<CanvasClearSelectionEvent> clearSelectionEvent;
    private DomainObjectAwareLienzoMultipleSelectionControl control;

    @Before
    public void setup() {
        Mockito.when((Object)this.lienzoLayer.uuid()).thenReturn((Object)LAYER_UUID);
        Mockito.when((Object)this.lienzoLayer.getViewport()).thenReturn((Object)this.lienzoViewport);
        Mockito.when((Object)this.lienzoViewport.getOnEventHandlers()).thenReturn((Object)this.lienzoOnEventHandlers);
        WiresManager wiresManager = WiresManager.get((Layer)this.lienzoLayer);
        this.control = new DomainObjectAwareLienzoMultipleSelectionControl(this.canvasSelectionEvent, this.clearSelectionEvent);
        Mockito.when((Object)this.canvasHandler.getCanvas()).thenReturn((Object)this.canvas);
        Mockito.when((Object)this.canvasHandler.getAbstractCanvas()).thenReturn((Object)this.canvas);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.canvasHandler.getGraphIndex()).thenReturn((Object)this.graphIndex);
        Mockito.when((Object)this.diagram.getMetadata()).thenReturn((Object)this.diagramMetadata);
        Mockito.when((Object)this.diagramMetadata.getCanvasRootUUID()).thenReturn((Object)DIAGRAM_UUID);
        Mockito.when((Object)this.graphIndex.get(ELEMENT_UUID)).thenReturn((Object)this.element);
        Mockito.when((Object)this.canvas.getWiresManager()).thenReturn((Object)wiresManager);
        Mockito.when((Object)this.element.getUUID()).thenReturn((Object)ELEMENT_UUID);
        Mockito.when((Object)this.element.getContent()).thenReturn((Object)new ViewImpl(this.definition, Bounds.create((double)0.0, (double)0.0, (double)10.0, (double)10.0)));
        this.control.init(this.canvasHandler);
        this.control.register(this.element);
    }

    @Test
    public void testSelectElement() {
        this.control.select(ELEMENT_UUID);
        this.assertElementSelected();
    }

    @Test
    public void testSelectElementWithEvent() {
        CanvasSelectionEvent event = new CanvasSelectionEvent((CanvasHandler)this.canvasHandler, ELEMENT_UUID);
        this.control.handleCanvasElementSelectedEvent(event);
        this.assertElementSelected();
    }

    @Test
    public void testSelectDomainObjectWithEvent() {
        DomainObjectSelectionEvent event = new DomainObjectSelectionEvent((CanvasHandler)this.canvasHandler, this.domainObject);
        this.control.handleDomainObjectSelectedEvent(event);
        this.assertDomainObjectSelected();
    }

    @Test
    public void testSelectNullDomainObjectWithEvent() {
        DomainObjectSelectionEvent event = new DomainObjectSelectionEvent((CanvasHandler)this.canvasHandler, null);
        this.control.handleDomainObjectSelectedEvent(event);
        Optional selectedItemDefinition = this.control.getSelectedItemDefinition();
        Assertions.assertThat((Optional)selectedItemDefinition).isNotPresent();
    }

    private void assertElementSelected() {
        Optional selectedItemDefinition = this.control.getSelectedItemDefinition();
        Assertions.assertThat((Optional)selectedItemDefinition).isPresent();
        Assertions.assertThat(selectedItemDefinition.get()).isEqualTo((Object)this.element);
    }

    private void assertDomainObjectSelected() {
        Optional selectedItemDefinition = this.control.getSelectedItemDefinition();
        Assertions.assertThat((Optional)selectedItemDefinition).isPresent();
        Assertions.assertThat(selectedItemDefinition.get()).isEqualTo((Object)this.domainObject);
    }

    @Test
    public void testSelectDomainObjectThenElement() {
        DomainObjectSelectionEvent domainObjectEvent = new DomainObjectSelectionEvent((CanvasHandler)this.canvasHandler, this.domainObject);
        this.control.handleDomainObjectSelectedEvent(domainObjectEvent);
        this.assertDomainObjectSelected();
        CanvasSelectionEvent elementEvent = new CanvasSelectionEvent((CanvasHandler)this.canvasHandler, ELEMENT_UUID);
        this.control.handleCanvasElementSelectedEvent(elementEvent);
        this.assertElementSelected();
    }

    @Test
    public void testSelectDomainObjectThenClear() {
        DomainObjectSelectionEvent domainObjectEvent = new DomainObjectSelectionEvent((CanvasHandler)this.canvasHandler, this.domainObject);
        this.control.handleDomainObjectSelectedEvent(domainObjectEvent);
        this.assertDomainObjectSelected();
        this.control.clear();
        Assertions.assertThat((Optional)this.control.getSelectedItemDefinition()).isNotPresent();
    }

    @Test
    public void testSelectDomainObjectThenClearWithEvent() {
        DomainObjectSelectionEvent domainObjectEvent = new DomainObjectSelectionEvent((CanvasHandler)this.canvasHandler, this.domainObject);
        this.control.handleDomainObjectSelectedEvent(domainObjectEvent);
        this.assertDomainObjectSelected();
        CanvasClearSelectionEvent event = new CanvasClearSelectionEvent((CanvasHandler)this.canvasHandler);
        this.control.handleCanvasClearSelectionEvent(event);
        Assertions.assertThat((Optional)this.control.getSelectedItemDefinition()).isNotPresent();
    }

    @Test
    public void testSelectDomainObjectThenDestroy() {
        DomainObjectSelectionEvent domainObjectEvent = new DomainObjectSelectionEvent((CanvasHandler)this.canvasHandler, this.domainObject);
        this.control.handleDomainObjectSelectedEvent(domainObjectEvent);
        this.assertDomainObjectSelected();
        this.control.destroy();
        Assertions.assertThat((Optional)this.control.getSelectedItemDefinition()).isNotPresent();
    }
}

