/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.dtable;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.v1_1.InputClause;
import org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests;
import org.kie.workbench.common.dmn.client.commands.expressions.types.dtable.AddInputClauseCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.InputClauseColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class AddInputClauseCommandTest {
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private InputClauseColumn uiInputClauseColumn;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private GraphCommandExecutionContext graphCommandExecutionContext;
    @Mock
    private Command executeCanvasOperation;
    @Mock
    private Command undoCanvasOperation;
    private DecisionTable dtable;
    private InputClause inputClause;
    private GridData uiModel;
    private DecisionTableUIModelMapper uiModelMapper;
    private AddInputClauseCommand command;

    @Before
    public void setUp() throws Exception {
        this.dtable = new DecisionTable();
        this.uiModel = new DMNGridData();
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.inputClause = new InputClause();
        this.uiModelMapper = new DecisionTableUIModelMapper(() -> this.uiModel, () -> Optional.of(this.dtable), this.listSelector);
        ((RowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((InputClauseColumn)Mockito.doReturn((Object)1).when((Object)this.uiInputClauseColumn)).getIndex();
    }

    private void makeCommand(int index) {
        this.command = (AddInputClauseCommand)Mockito.spy((Object)new AddInputClauseCommand(this.dtable, this.inputClause, this.uiModel, () -> this.uiInputClauseColumn, index, this.uiModelMapper, this.executeCanvasOperation, this.undoCanvasOperation));
    }

    @Test
    public void testGraphCommandAllow() throws Exception {
        this.makeCommand(1);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.allow((Object)this.graphCommandExecutionContext));
    }

    @Test
    public void testGraphCommandExecute() throws Exception {
        this.makeCommand(1);
        this.dtable.getRule().add(new DecisionRule());
        this.dtable.getRule().add(new DecisionRule());
        Assert.assertEquals((long)0L, (long)this.dtable.getInput().size());
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)1L, (long)this.dtable.getInput().size());
        Assert.assertEquals((Object)"input-1", (Object)((InputClause)this.dtable.getInput().get(0)).getInputExpression().getText().getValue());
        List inputEntriesRuleOne = ((DecisionRule)this.dtable.getRule().get(0)).getInputEntry();
        Assert.assertEquals((long)1L, (long)inputEntriesRuleOne.size());
        Assert.assertEquals((Object)"", (Object)((UnaryTests)inputEntriesRuleOne.get(0)).getText().getValue());
        Assert.assertEquals(this.dtable.getRule().get(0), (Object)((UnaryTests)inputEntriesRuleOne.get(0)).getParent());
        List inputEntriesRuleTwo = ((DecisionRule)this.dtable.getRule().get(1)).getInputEntry();
        Assert.assertEquals((long)1L, (long)inputEntriesRuleTwo.size());
        Assert.assertEquals((Object)"", (Object)((UnaryTests)inputEntriesRuleTwo.get(0)).getText().getValue());
        Assert.assertEquals(this.dtable.getRule().get(1), (Object)((UnaryTests)inputEntriesRuleTwo.get(0)).getParent());
        Assert.assertEquals((Object)this.dtable, (Object)this.inputClause.getParent());
    }

    @Test
    public void testGraphCommandExecuteExistingNotAffected() throws Exception {
        this.makeCommand(1);
        String ruleOneOldInput = "old rule 1";
        String ruleTwoOldInput = "old rule 2";
        this.dtable.getInput().add(new InputClause());
        this.addRuleWithInputClauseValues("old rule 1");
        this.addRuleWithInputClauseValues("old rule 2");
        Assert.assertEquals((long)1L, (long)this.dtable.getInput().size());
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)2L, (long)this.dtable.getInput().size());
        Assert.assertEquals((Object)"input-1", (Object)((InputClause)this.dtable.getInput().get(0)).getInputExpression().getText().getValue());
        Assert.assertNotNull((Object)((InputClause)this.dtable.getInput().get(1)).getInputExpression());
        List inputEntriesRuleOne = ((DecisionRule)this.dtable.getRule().get(0)).getInputEntry();
        Assert.assertEquals((long)2L, (long)inputEntriesRuleOne.size());
        Assert.assertEquals((Object)"old rule 1", (Object)((UnaryTests)inputEntriesRuleOne.get(1)).getText().getValue());
        Assert.assertEquals((Object)"", (Object)((UnaryTests)inputEntriesRuleOne.get(0)).getText().getValue());
        Assert.assertEquals(this.dtable.getRule().get(0), (Object)((UnaryTests)inputEntriesRuleOne.get(0)).getParent());
        List inputEntriesRuleTwo = ((DecisionRule)this.dtable.getRule().get(1)).getInputEntry();
        Assert.assertEquals((long)2L, (long)inputEntriesRuleTwo.size());
        Assert.assertEquals((Object)"old rule 2", (Object)((UnaryTests)inputEntriesRuleTwo.get(1)).getText().getValue());
        Assert.assertEquals((Object)"", (Object)((UnaryTests)inputEntriesRuleTwo.get(0)).getText().getValue());
        Assert.assertEquals(this.dtable.getRule().get(1), (Object)((UnaryTests)inputEntriesRuleTwo.get(0)).getParent());
        Assert.assertEquals((Object)this.dtable, (Object)this.inputClause.getParent());
    }

    @Test
    public void testGraphCommandExecuteInsertMiddle() throws Exception {
        this.makeCommand(2);
        String ruleInputOne = "rule in 1";
        String ruleInputTwo = "rule in 2";
        this.dtable.getInput().add(new InputClause());
        this.dtable.getInput().add(new InputClause());
        this.addRuleWithInputClauseValues("rule in 1", "rule in 2");
        Assert.assertEquals((long)2L, (long)this.dtable.getInput().size());
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)3L, (long)this.dtable.getInput().size());
        Assert.assertNotNull((Object)((InputClause)this.dtable.getInput().get(0)).getInputExpression());
        Assert.assertEquals((Object)"input-1", (Object)((InputClause)this.dtable.getInput().get(1)).getInputExpression().getText().getValue());
        Assert.assertNotNull((Object)((InputClause)this.dtable.getInput().get(2)).getInputExpression());
        List ruleInputs = ((DecisionRule)this.dtable.getRule().get(0)).getInputEntry();
        Assert.assertEquals((long)3L, (long)ruleInputs.size());
        Assert.assertEquals((Object)"rule in 1", (Object)((UnaryTests)ruleInputs.get(0)).getText().getValue());
        Assert.assertEquals((Object)"", (Object)((UnaryTests)ruleInputs.get(1)).getText().getValue());
        Assert.assertEquals(this.dtable.getRule().get(0), (Object)((UnaryTests)ruleInputs.get(1)).getParent());
        Assert.assertEquals((Object)"rule in 2", (Object)((UnaryTests)ruleInputs.get(2)).getText().getValue());
        Assert.assertEquals((Object)this.dtable, (Object)this.inputClause.getParent());
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testGraphCommandUndoNoInputClauseColumns() throws Exception {
        String javaVersion = "11";
        String javaVersionPropertyKey = "java.version";
        Assume.assumeFalse((boolean)System.getProperty("java.version").contains("11"));
        this.makeCommand(1);
        this.dtable.getRule().add(new DecisionRule());
        Assert.assertEquals((long)0L, (long)this.dtable.getInput().size());
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.undo((Object)this.graphCommandExecutionContext));
    }

    @Test
    public void testGraphCommandUndoJustLastInputClauseColumn() throws Exception {
        this.makeCommand(1);
        String ruleOneOldInput = "old rule 1";
        String ruleTwoOldInput = "old rule 2";
        this.dtable.getInput().add(new InputClause());
        this.addRuleWithInputClauseValues("old rule 1");
        this.addRuleWithInputClauseValues("old rule 2");
        Assert.assertEquals((long)1L, (long)this.dtable.getInput().size());
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.undo((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)1L, (long)this.dtable.getInput().size());
        Assert.assertEquals((long)1L, (long)((DecisionRule)this.dtable.getRule().get(0)).getInputEntry().size());
        Assert.assertEquals((Object)"old rule 1", (Object)((UnaryTests)((DecisionRule)this.dtable.getRule().get(0)).getInputEntry().get(0)).getText().getValue());
        Assert.assertEquals((long)1L, (long)((DecisionRule)this.dtable.getRule().get(1)).getInputEntry().size());
        Assert.assertEquals((Object)"old rule 2", (Object)((UnaryTests)((DecisionRule)this.dtable.getRule().get(1)).getInputEntry().get(0)).getText().getValue());
    }

    @Test
    public void testCanvasCommandAllow() throws Exception {
        this.makeCommand(1);
        org.kie.workbench.common.stunner.core.command.Command canvasCommand = this.command.newCanvasCommand(this.canvasHandler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasCommand.allow((Object)this.canvasHandler));
    }

    @Test
    public void testCanvasCommandAddRuleAndThenUndo() throws Exception {
        this.makeCommand(1);
        String ruleOneInputValue = "one";
        String ruleTwoInputValue = "two";
        this.dtable.getRule().add(new DecisionRule());
        this.dtable.getRule().add(new DecisionRule());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        graphCommand.execute((Object)this.graphCommandExecutionContext);
        ((UnaryTests)((DecisionRule)this.dtable.getRule().get(0)).getInputEntry().get(0)).getText().setValue("one");
        ((UnaryTests)((DecisionRule)this.dtable.getRule().get(1)).getInputEntry().get(0)).getText().setValue("two");
        org.kie.workbench.common.stunner.core.command.Command canvasAddInputClauseCommand = this.command.newCanvasCommand(this.canvasHandler);
        canvasAddInputClauseCommand.execute((Object)this.canvasHandler);
        Assert.assertEquals((Object)"one", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(1)).getValue().getValue());
        Assert.assertEquals((Object)"two", (Object)((GridCell)this.uiModel.getRow(1).getCells().get(1)).getValue().getValue());
        Assert.assertEquals((long)2L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasAddInputClauseCommand.undo((Object)this.canvasHandler));
        Assert.assertEquals((long)1L, (long)this.uiModel.getColumnCount());
        ((Command)Mockito.verify((Object)this.executeCanvasOperation)).execute();
        ((Command)Mockito.verify((Object)this.undoCanvasOperation)).execute();
        ((AddInputClauseCommand)Mockito.verify((Object)this.command, (VerificationMode)Mockito.times((int)2))).updateParentInformation();
    }

    @Test
    public void testCanvasCommandUndoWhenNothingBefore() throws Exception {
        this.makeCommand(1);
        org.kie.workbench.common.stunner.core.command.Command canvasAddInputClauseCommand = this.command.newCanvasCommand(this.canvasHandler);
        canvasAddInputClauseCommand.undo((Object)this.canvasHandler);
        Assert.assertEquals((long)1L, (long)this.uiModel.getColumnCount());
        ((Command)Mockito.verify((Object)this.undoCanvasOperation)).execute();
        ((AddInputClauseCommand)Mockito.verify((Object)this.command)).updateParentInformation();
    }

    @Test
    public void testComponentWidths() {
        this.makeCommand(1);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        org.kie.workbench.common.stunner.core.command.Command canvasCommand = this.command.newCanvasCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasCommand.execute((Object)this.canvasHandler));
        Assert.assertEquals((long)this.dtable.getRequiredComponentWidthCount(), (long)this.dtable.getComponentWidths().size());
        Assert.assertNull(this.dtable.getComponentWidths().get(1));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.undo((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasCommand.undo((Object)this.canvasHandler));
        Assert.assertEquals((long)this.dtable.getRequiredComponentWidthCount(), (long)this.dtable.getComponentWidths().size());
    }

    private void addRuleWithInputClauseValues(final String ... inputClauseValues) {
        this.dtable.getRule().add(new DecisionRule(){
            {
                Stream.of(inputClauseValues).forEach(iClause -> this.getInputEntry().add(new UnaryTests((String)iClause){
                    final /* synthetic */ String val$iClause;
                    {
                        this.val$iClause = string;
                        this.getText().setValue(this.val$iClause);
                    }
                }));
            }
        });
    }
}

