/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.dtable;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.v1_1.InputClause;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.OutputClause;
import org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests;
import org.kie.workbench.common.dmn.client.commands.expressions.types.dtable.AddOutputClauseCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.InputClauseColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.OutputClauseColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class AddOutputClauseCommandTest {
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private OutputClauseColumn uiOutputClauseColumn;
    @Mock
    private InputClauseColumn uiInputClauseColumn;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private GraphCommandExecutionContext graphCommandExecutionContext;
    @Mock
    private Command executeCanvasOperation;
    @Mock
    private Command undoCanvasOperation;
    private DecisionTable dtable;
    private OutputClause outputClause;
    private GridData uiModel;
    private DecisionTableUIModelMapper uiModelMapper;
    private AddOutputClauseCommand command;

    @Before
    public void doNotRunTestsOnJdkEleven() {
        String javaVersion = "11";
        String javaVersionPropertyKey = "java.version";
        Assume.assumeFalse((boolean)System.getProperty("java.version").contains("11"));
    }

    @Before
    public void setUp() throws Exception {
        this.dtable = new DecisionTable();
        this.uiModel = new DMNGridData();
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.outputClause = new OutputClause();
        this.uiModelMapper = new DecisionTableUIModelMapper(() -> this.uiModel, () -> Optional.of(this.dtable), this.listSelector);
        ((RowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((OutputClauseColumn)Mockito.doReturn((Object)1).when((Object)this.uiOutputClauseColumn)).getIndex();
    }

    private void makeCommand(int index) {
        this.command = (AddOutputClauseCommand)Mockito.spy((Object)new AddOutputClauseCommand(this.dtable, this.outputClause, this.uiModel, () -> this.uiOutputClauseColumn, index, this.uiModelMapper, this.executeCanvasOperation, this.undoCanvasOperation));
    }

    @Test
    public void testGraphCommandAllow() throws Exception {
        this.makeCommand(1);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.allow((Object)this.graphCommandExecutionContext));
    }

    @Test
    public void testGraphCommandCheck() throws Exception {
        this.makeCommand(1);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.allow((Object)this.graphCommandExecutionContext));
    }

    @Test
    public void testGraphCommandExecute() throws Exception {
        this.makeCommand(1);
        this.dtable.getRule().add(new DecisionRule());
        this.dtable.getRule().add(new DecisionRule());
        Assert.assertEquals((long)0L, (long)this.dtable.getOutput().size());
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)1L, (long)this.dtable.getOutput().size());
        Assert.assertEquals((Object)"output-1", (Object)((OutputClause)this.dtable.getOutput().get(0)).getName());
        List outputEntriesRuleOne = ((DecisionRule)this.dtable.getRule().get(0)).getOutputEntry();
        Assert.assertEquals((long)1L, (long)outputEntriesRuleOne.size());
        Assert.assertEquals((Object)"", (Object)((LiteralExpression)outputEntriesRuleOne.get(0)).getText().getValue());
        Assert.assertEquals(this.dtable.getRule().get(0), (Object)((LiteralExpression)outputEntriesRuleOne.get(0)).getParent());
        List outputEntriesRuleTwo = ((DecisionRule)this.dtable.getRule().get(1)).getOutputEntry();
        Assert.assertEquals((long)1L, (long)outputEntriesRuleTwo.size());
        Assert.assertEquals((Object)"", (Object)((LiteralExpression)outputEntriesRuleTwo.get(0)).getText().getValue());
        Assert.assertEquals(this.dtable.getRule().get(1), (Object)((LiteralExpression)outputEntriesRuleTwo.get(0)).getParent());
        Assert.assertEquals((Object)this.dtable, (Object)this.outputClause.getParent());
    }

    @Test
    public void testGraphCommandExecuteExistingNotAffected() throws Exception {
        this.makeCommand(1);
        String ruleOneOldOutput = "old rule 1";
        String ruleTwoOldOutput = "old rule 2";
        this.dtable.getOutput().add(new OutputClause());
        this.addRuleWithOutputClauseValues("old rule 1");
        this.addRuleWithOutputClauseValues("old rule 2");
        Assert.assertEquals((long)1L, (long)this.dtable.getOutput().size());
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)2L, (long)this.dtable.getOutput().size());
        Assert.assertEquals((Object)"output-1", (Object)((OutputClause)this.dtable.getOutput().get(0)).getName());
        Assert.assertNull((Object)((OutputClause)this.dtable.getOutput().get(1)).getName());
        List outputEntriesRuleOne = ((DecisionRule)this.dtable.getRule().get(0)).getOutputEntry();
        Assert.assertEquals((long)2L, (long)outputEntriesRuleOne.size());
        Assert.assertEquals((Object)"old rule 1", (Object)((LiteralExpression)outputEntriesRuleOne.get(1)).getText().getValue());
        Assert.assertEquals((Object)"", (Object)((LiteralExpression)outputEntriesRuleOne.get(0)).getText().getValue());
        Assert.assertEquals(this.dtable.getRule().get(0), (Object)((LiteralExpression)outputEntriesRuleOne.get(0)).getParent());
        List outputEntriesRuleTwo = ((DecisionRule)this.dtable.getRule().get(1)).getOutputEntry();
        Assert.assertEquals((long)2L, (long)outputEntriesRuleTwo.size());
        Assert.assertEquals((Object)"old rule 2", (Object)((LiteralExpression)outputEntriesRuleTwo.get(1)).getText().getValue());
        Assert.assertEquals((Object)"", (Object)((LiteralExpression)outputEntriesRuleTwo.get(0)).getText().getValue());
        Assert.assertEquals(this.dtable.getRule().get(1), (Object)((LiteralExpression)outputEntriesRuleTwo.get(0)).getParent());
        Assert.assertEquals((Object)this.dtable, (Object)this.outputClause.getParent());
    }

    @Test
    public void testGraphCommandExecuteInsertMiddle() throws Exception {
        this.makeCommand(2);
        String ruleOutputOne = "rule out 1";
        String ruleOutputTwo = "rule out 2";
        this.dtable.getOutput().add(new OutputClause());
        this.dtable.getOutput().add(new OutputClause());
        this.addRuleWithOutputClauseValues("rule out 1", "rule out 2");
        Assert.assertEquals((long)2L, (long)this.dtable.getOutput().size());
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)3L, (long)this.dtable.getOutput().size());
        Assert.assertNull((Object)((OutputClause)this.dtable.getOutput().get(0)).getName());
        Assert.assertEquals((Object)"output-1", (Object)((OutputClause)this.dtable.getOutput().get(1)).getName());
        Assert.assertNull((Object)((OutputClause)this.dtable.getOutput().get(2)).getName());
        List ruleOutputs = ((DecisionRule)this.dtable.getRule().get(0)).getOutputEntry();
        Assert.assertEquals((long)3L, (long)ruleOutputs.size());
        Assert.assertEquals((Object)"rule out 1", (Object)((LiteralExpression)ruleOutputs.get(0)).getText().getValue());
        Assert.assertEquals((Object)"", (Object)((LiteralExpression)ruleOutputs.get(1)).getText().getValue());
        Assert.assertEquals(this.dtable.getRule().get(0), (Object)((LiteralExpression)ruleOutputs.get(1)).getParent());
        Assert.assertEquals((Object)"rule out 2", (Object)((LiteralExpression)ruleOutputs.get(2)).getText().getValue());
        Assert.assertEquals((Object)this.dtable, (Object)this.outputClause.getParent());
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testGraphCommandUndoNoOutputClauseColumns() throws Exception {
        String javaVersion = "11";
        String javaVersionPropertyKey = "java.version";
        Assume.assumeFalse((boolean)System.getProperty("java.version").contains("11"));
        this.makeCommand(1);
        this.dtable.getRule().add(new DecisionRule());
        Assert.assertEquals((long)0L, (long)this.dtable.getOutput().size());
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.undo((Object)this.graphCommandExecutionContext));
    }

    @Test
    public void testGraphCommandUndoJustLastOutputClauseColumn() throws Exception {
        this.makeCommand(1);
        String ruleOneOldOutput = "old rule 1";
        String ruleTwoOldOutput = "old rule 2";
        this.dtable.getOutput().add(new OutputClause());
        this.addRuleWithOutputClauseValues("old rule 1");
        this.addRuleWithOutputClauseValues("old rule 2");
        Assert.assertEquals((long)1L, (long)this.dtable.getOutput().size());
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.undo((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)1L, (long)this.dtable.getOutput().size());
        Assert.assertEquals((long)1L, (long)((DecisionRule)this.dtable.getRule().get(0)).getOutputEntry().size());
        Assert.assertEquals((Object)"old rule 1", (Object)((LiteralExpression)((DecisionRule)this.dtable.getRule().get(0)).getOutputEntry().get(0)).getText().getValue());
        Assert.assertEquals((long)1L, (long)((DecisionRule)this.dtable.getRule().get(1)).getOutputEntry().size());
        Assert.assertEquals((Object)"old rule 2", (Object)((LiteralExpression)((DecisionRule)this.dtable.getRule().get(1)).getOutputEntry().get(0)).getText().getValue());
    }

    @Test
    public void testCanvasCommandAllow() throws Exception {
        this.makeCommand(1);
        org.kie.workbench.common.stunner.core.command.Command canvasCommand = this.command.newCanvasCommand(this.canvasHandler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasCommand.allow((Object)this.canvasHandler));
    }

    @Test
    public void testCanvasCommandAddOutputClauseToRuleWithInputs() throws Exception {
        this.makeCommand(2);
        String ruleInputValue = "in value";
        String ruleOutputValue = "out value";
        this.dtable.getInput().add(new InputClause());
        this.dtable.getRule().add(new DecisionRule(){
            {
                this.getInputEntry().add(new UnaryTests(){
                    {
                        this.getText().setValue("in value");
                    }
                });
                this.getOutputEntry().add(new LiteralExpression(){
                    {
                        this.getText().setValue("out value");
                    }
                });
            }
        });
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        graphCommand.execute((Object)this.graphCommandExecutionContext);
        ((LiteralExpression)((DecisionRule)this.dtable.getRule().get(0)).getOutputEntry().get(0)).getText().setValue("out value");
        ((InputClauseColumn)Mockito.doReturn((Object)1).when((Object)this.uiInputClauseColumn)).getIndex();
        ((OutputClauseColumn)Mockito.doReturn((Object)2).when((Object)this.uiOutputClauseColumn)).getIndex();
        this.uiModel.appendColumn((GridColumn)this.uiInputClauseColumn);
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModelMapper.fromDMNModel(0, 1);
        org.kie.workbench.common.stunner.core.command.Command canvasAddOutputClauseCommand = this.command.newCanvasCommand(this.canvasHandler);
        canvasAddOutputClauseCommand.execute((Object)this.canvasHandler);
        Assert.assertEquals((Object)"in value", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(1)).getValue().getValue());
        Assert.assertEquals((Object)"out value", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(2)).getValue().getValue());
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasAddOutputClauseCommand.undo((Object)this.canvasHandler));
        Assert.assertEquals((long)2L, (long)this.uiModel.getColumnCount());
        ((Command)Mockito.verify((Object)this.executeCanvasOperation)).execute();
        ((Command)Mockito.verify((Object)this.undoCanvasOperation)).execute();
        ((AddOutputClauseCommand)Mockito.verify((Object)this.command, (VerificationMode)Mockito.times((int)2))).updateParentInformation();
    }

    @Test
    public void testCanvasCommandAddOutputClauseToRuleWithoutInputsThenUndo() throws Exception {
        this.makeCommand(1);
        String ruleOneOutputValue = "one";
        String ruleTwoOutputValue = "two";
        this.dtable.getRule().add(new DecisionRule());
        this.dtable.getRule().add(new DecisionRule());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        graphCommand.execute((Object)this.graphCommandExecutionContext);
        ((LiteralExpression)((DecisionRule)this.dtable.getRule().get(0)).getOutputEntry().get(0)).getText().setValue("one");
        ((LiteralExpression)((DecisionRule)this.dtable.getRule().get(1)).getOutputEntry().get(0)).getText().setValue("two");
        org.kie.workbench.common.stunner.core.command.Command canvasAddOutputClauseCommand = this.command.newCanvasCommand(this.canvasHandler);
        canvasAddOutputClauseCommand.execute((Object)this.canvasHandler);
        Assert.assertEquals((Object)"one", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(1)).getValue().getValue());
        Assert.assertEquals((Object)"two", (Object)((GridCell)this.uiModel.getRow(1).getCells().get(1)).getValue().getValue());
        Assert.assertEquals((long)2L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasAddOutputClauseCommand.undo((Object)this.canvasHandler));
        Assert.assertEquals((long)1L, (long)this.uiModel.getColumnCount());
        ((Command)Mockito.verify((Object)this.executeCanvasOperation)).execute();
        ((Command)Mockito.verify((Object)this.undoCanvasOperation)).execute();
        ((AddOutputClauseCommand)Mockito.verify((Object)this.command, (VerificationMode)Mockito.times((int)2))).updateParentInformation();
    }

    @Test
    public void testCanvasCommandUndoWhenNothingBefore() throws Exception {
        this.makeCommand(1);
        org.kie.workbench.common.stunner.core.command.Command canvasAddOutputClauseCommand = this.command.newCanvasCommand(this.canvasHandler);
        canvasAddOutputClauseCommand.undo((Object)this.canvasHandler);
        Assert.assertEquals((long)1L, (long)this.uiModel.getColumnCount());
        ((Command)Mockito.verify((Object)this.undoCanvasOperation)).execute();
        ((AddOutputClauseCommand)Mockito.verify((Object)this.command)).updateParentInformation();
    }

    @Test
    public void testComponentWidths() {
        this.makeCommand(1);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        org.kie.workbench.common.stunner.core.command.Command canvasCommand = this.command.newCanvasCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasCommand.execute((Object)this.canvasHandler));
        Assert.assertEquals((long)this.dtable.getRequiredComponentWidthCount(), (long)this.dtable.getComponentWidths().size());
        Assert.assertNull(this.dtable.getComponentWidths().get(1));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.undo((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasCommand.undo((Object)this.canvasHandler));
        Assert.assertEquals((long)this.dtable.getRequiredComponentWidthCount(), (long)this.dtable.getComponentWidths().size());
    }

    private void addRuleWithOutputClauseValues(final String ... outputClauseValues) {
        this.dtable.getRule().add(new DecisionRule(){
            {
                Stream.of(outputClauseValues).forEach(oClause -> this.getOutputEntry().add(new LiteralExpression((String)oClause){
                    final /* synthetic */ String val$oClause;
                    {
                        this.val$oClause = string;
                        this.getText().setValue(this.val$oClause);
                    }
                }));
            }
        });
    }
}

