/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.dtable;

import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.OutputClause;
import org.kie.workbench.common.dmn.client.commands.expressions.types.dtable.DeleteOutputClauseCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DescriptionColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.OutputClauseColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class DeleteOutputClauseCommandTest {
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private OutputClauseColumn uiOutputClauseColumn;
    @Mock
    private DescriptionColumn uiDescriptionColumn;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private GraphCommandExecutionContext graphCommandExecutionContext;
    @Mock
    private Command executeCanvasOperation;
    @Mock
    private Command undoCanvasOperation;
    private DecisionTable dtable;
    private OutputClause outputClause;
    private GridData uiModel;
    private DecisionTableUIModelMapper uiModelMapper;
    private DeleteOutputClauseCommand command;

    @Before
    public void setup() {
        this.dtable = new DecisionTable();
        this.outputClause = new OutputClause();
        this.dtable.getOutput().add(this.outputClause);
        this.uiModel = new DMNGridData();
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.uiModel.appendColumn((GridColumn)this.uiOutputClauseColumn);
        this.uiModel.appendColumn((GridColumn)this.uiDescriptionColumn);
        this.uiModelMapper = new DecisionTableUIModelMapper(() -> this.uiModel, () -> Optional.of(this.dtable), this.listSelector);
        this.makeCommand(1 + this.dtable.getInput().size());
        ((RowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((OutputClauseColumn)Mockito.doReturn((Object)1).when((Object)this.uiOutputClauseColumn)).getIndex();
        ((DescriptionColumn)Mockito.doReturn((Object)2).when((Object)this.uiDescriptionColumn)).getIndex();
    }

    private void makeCommand(int uiColumnIndex) {
        this.command = (DeleteOutputClauseCommand)Mockito.spy((Object)new DeleteOutputClauseCommand(this.dtable, this.uiModel, uiColumnIndex, this.uiModelMapper, this.executeCanvasOperation, this.undoCanvasOperation));
    }

    @Test
    public void testGraphCommandAllow() throws Exception {
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.allow((Object)this.graphCommandExecutionContext));
    }

    @Test
    public void testGraphCommandCheck() throws Exception {
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.allow((Object)this.graphCommandExecutionContext));
    }

    @Test
    public void testGraphCommandExecute() {
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)0L, (long)this.dtable.getOutput().size());
    }

    @Test
    public void testGraphCommandExecuteRemoveMiddle() {
        OutputClause firstOutput = (OutputClause)Mockito.mock(OutputClause.class);
        OutputClause lastOutput = (OutputClause)Mockito.mock(OutputClause.class);
        this.dtable.getOutput().add(0, firstOutput);
        this.dtable.getOutput().add(lastOutput);
        LiteralExpression outputOneValue = (LiteralExpression)Mockito.mock(LiteralExpression.class);
        LiteralExpression outputTwoValue = (LiteralExpression)Mockito.mock(LiteralExpression.class);
        LiteralExpression outputThreeValue = (LiteralExpression)Mockito.mock(LiteralExpression.class);
        DecisionRule rule = new DecisionRule();
        rule.getOutputEntry().add(outputOneValue);
        rule.getOutputEntry().add(outputTwoValue);
        rule.getOutputEntry().add(outputThreeValue);
        this.dtable.getRule().add(rule);
        this.makeCommand(1 + this.dtable.getInput().size() + 1);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)2L, (long)this.dtable.getOutput().size());
        Assert.assertEquals((Object)firstOutput, this.dtable.getOutput().get(0));
        Assert.assertEquals((Object)lastOutput, this.dtable.getOutput().get(1));
        Assert.assertEquals((long)2L, (long)((DecisionRule)this.dtable.getRule().get(0)).getOutputEntry().size());
        Assert.assertEquals((Object)outputOneValue, ((DecisionRule)this.dtable.getRule().get(0)).getOutputEntry().get(0));
        Assert.assertEquals((Object)outputThreeValue, ((DecisionRule)this.dtable.getRule().get(0)).getOutputEntry().get(1));
    }

    @Test
    public void testGraphCommandExecuteAndThenUndo() {
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        graphCommand.execute((Object)this.graphCommandExecutionContext);
        Assert.assertEquals((long)0L, (long)this.dtable.getOutput().size());
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.undo((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)1L, (long)this.dtable.getOutput().size());
        Assert.assertEquals((Object)this.outputClause, this.dtable.getOutput().get(0));
    }

    @Test
    public void testCanvasCommandAllow() throws Exception {
        org.kie.workbench.common.stunner.core.command.Command canvasCommand = this.command.newCanvasCommand(this.canvasHandler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasCommand.allow((Object)this.canvasHandler));
    }

    @Test
    public void testCanvasCommandExecute() throws Exception {
        org.kie.workbench.common.stunner.core.command.Command canvasAddRuleCommand = this.command.newCanvasCommand(this.canvasHandler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasAddRuleCommand.execute((Object)this.canvasHandler));
        Assertions.assertThat((List)this.uiModel.getColumns()).containsOnly((Object[])new GridColumn[]{this.uiRowNumberColumn, this.uiDescriptionColumn});
        ((Command)Mockito.verify((Object)this.executeCanvasOperation)).execute();
        ((DeleteOutputClauseCommand)Mockito.verify((Object)this.command)).updateParentInformation();
    }

    @Test
    public void testCanvasCommandExecuteAndThenUndo() throws Exception {
        org.kie.workbench.common.stunner.core.command.Command canvasAddRuleCommand = this.command.newCanvasCommand(this.canvasHandler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasAddRuleCommand.execute((Object)this.canvasHandler));
        Assertions.assertThat((List)this.uiModel.getColumns()).containsOnly((Object[])new GridColumn[]{this.uiRowNumberColumn, this.uiDescriptionColumn});
        Mockito.reset((Object[])new DeleteOutputClauseCommand[]{this.command});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasAddRuleCommand.undo((Object)this.canvasHandler));
        Assertions.assertThat((List)this.uiModel.getColumns()).containsOnly((Object[])new GridColumn[]{this.uiRowNumberColumn, this.uiOutputClauseColumn, this.uiDescriptionColumn});
        ((Command)Mockito.verify((Object)this.undoCanvasOperation)).execute();
        ((DeleteOutputClauseCommand)Mockito.verify((Object)this.command)).updateParentInformation();
    }

    @Test
    public void testComponentWidths() {
        Mockito.when((Object)this.uiOutputClauseColumn.getWidth()).thenReturn((Object)100.0);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)this.dtable.getRequiredComponentWidthCount(), (long)this.dtable.getComponentWidths().size());
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.undo((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)this.dtable.getRequiredComponentWidthCount(), (long)this.dtable.getComponentWidths().size());
        Assert.assertEquals((double)100.0, (double)((Double)this.dtable.getComponentWidths().get(1)), (double)0.0);
    }
}

