/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.relation;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.definition.v1_1.List;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.Relation;
import org.kie.workbench.common.dmn.client.commands.expressions.types.relation.AddRelationRowCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class AddRelationRowCommandTest {
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private RelationColumn uiModelColumn;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private Command canvasOperation;
    @Mock
    private AbstractCanvasHandler handler;
    @Mock
    private GraphCommandExecutionContext gce;
    @Mock
    private RuleManager ruleManager;
    private Relation relation;
    private List row;
    private GridData uiModel;
    private GridRow uiModelRow;
    private RelationUIModelMapper uiModelMapper;
    private AddRelationRowCommand command;

    @Before
    public void setup() {
        this.relation = new Relation();
        this.row = new List();
        this.uiModelRow = new BaseGridRow();
        this.uiModel = new BaseGridData();
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.uiModelMapper = new RelationUIModelMapper(() -> this.uiModel, () -> Optional.of(this.relation), this.listSelector);
        this.makeCommand(0);
        ((AbstractCanvasHandler)Mockito.doReturn((Object)this.ruleManager).when((Object)this.handler)).getRuleManager();
        ((RowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((RelationColumn)Mockito.doReturn((Object)1).when((Object)this.uiModelColumn)).getIndex();
    }

    private void makeCommand(int uiRowIndex) {
        this.command = (AddRelationRowCommand)Mockito.spy((Object)new AddRelationRowCommand(this.relation, this.row, this.uiModel, this.uiModelRow, uiRowIndex, this.uiModelMapper, this.canvasOperation));
    }

    @Test
    public void testGraphCommandAllow() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.gce));
    }

    @Test
    public void testGraphCommandExecuteWithColumns() {
        this.relation.getColumn().add(new InformationItem());
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)1L, (long)this.relation.getRow().size());
        Assert.assertEquals((Object)this.row, this.relation.getRow().get(0));
        Assert.assertEquals((long)1L, (long)this.relation.getColumn().size());
        Assert.assertEquals((long)1L, (long)((List)this.relation.getRow().get(0)).getExpression().size());
        Assert.assertTrue((boolean)(((List)this.relation.getRow().get(0)).getExpression().get(0) instanceof LiteralExpression));
        Assert.assertEquals((Object)this.relation, (Object)this.row.getParent());
        Assert.assertEquals(this.relation.getRow().get(0), (Object)((Expression)((List)this.relation.getRow().get(0)).getExpression().get(0)).getParent());
    }

    @Test
    public void testGraphCommandExecuteInsertMiddleWithColumns() {
        this.relation.getRow().add(new List());
        this.relation.getRow().add(new List());
        this.relation.getColumn().add(new InformationItem());
        this.makeCommand(1);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)3L, (long)this.relation.getRow().size());
        Assert.assertEquals((Object)this.row, this.relation.getRow().get(1));
        Assert.assertEquals((long)1L, (long)this.relation.getColumn().size());
        Assert.assertEquals((long)1L, (long)((List)this.relation.getRow().get(1)).getExpression().size());
        Assert.assertTrue((boolean)(((List)this.relation.getRow().get(1)).getExpression().get(0) instanceof LiteralExpression));
        Assert.assertEquals((Object)this.relation, (Object)this.row.getParent());
        Assert.assertEquals(this.relation.getRow().get(1), (Object)((Expression)((List)this.relation.getRow().get(1)).getExpression().get(0)).getParent());
    }

    @Test
    public void testGraphCommandExecuteWithNoColumns() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)1L, (long)this.relation.getRow().size());
        Assert.assertEquals((Object)this.row, this.relation.getRow().get(0));
        Assert.assertEquals((Object)this.relation, (Object)this.row.getParent());
    }

    @Test
    public void testGraphCommandUndoWithColumns() {
        this.relation.getColumn().add(new InformationItem());
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assert.assertEquals((long)1L, (long)this.relation.getColumn().size());
        Assert.assertEquals((long)0L, (long)this.relation.getRow().size());
    }

    @Test
    public void testGraphCommandUndoWithNoColumns() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assert.assertEquals((long)0L, (long)this.relation.getColumn().size());
        Assert.assertEquals((long)0L, (long)this.relation.getRow().size());
    }

    @Test
    public void testCanvasCommandAllow() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.handler));
    }

    @Test
    public void testCanvasCommandExecuteWithColumns() {
        this.relation.getRow().add(new List());
        this.relation.getRow().add(new List());
        this.relation.getColumn().add(new InformationItem());
        this.uiModel.appendColumn((GridColumn)this.uiModelColumn);
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.makeCommand(1);
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((long)3L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((Object)this.uiModelRow, this.uiModel.getRows().get(1));
        Assert.assertEquals((long)2L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiModelColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((long)2L, (long)((GridRow)this.uiModel.getRows().get(1)).getCells().size());
        Assert.assertEquals((Object)2, (Object)this.uiModel.getCell(1, 0).getValue().getValue());
        Assert.assertEquals((Object)"", (Object)this.uiModel.getCell(1, 1).getValue().getValue());
        ((AddRelationRowCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((AddRelationRowCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandExecuteWithNoColumns() {
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((long)1L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((Object)this.uiModelRow, this.uiModel.getRows().get(0));
        Assert.assertEquals((long)1L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((long)1L, (long)((GridRow)this.uiModel.getRows().get(0)).getCells().size());
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
        ((AddRelationRowCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((AddRelationRowCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandUndoWithColumns() {
        this.relation.getColumn().add(new InformationItem());
        this.relation.getRow().add(new List());
        this.uiModel.appendColumn((GridColumn)this.uiModelColumn);
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModelMapper.fromDMNModel(0, 0);
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new Object[]{this.command, this.canvasOperation});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        Assert.assertEquals((long)2L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiModelColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((long)1L, (long)this.uiModel.getRowCount());
        ((AddRelationRowCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((AddRelationRowCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandUndoWithNoColumns() {
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new Object[]{this.command, this.canvasOperation});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        Assert.assertEquals((long)1L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((long)0L, (long)this.uiModel.getRowCount());
        ((AddRelationRowCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((AddRelationRowCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }
}

