/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.relation;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.definition.v1_1.List;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.Relation;
import org.kie.workbench.common.dmn.client.commands.expressions.types.relation.DeleteRelationColumnCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class DeleteRelationColumnCommandTest {
    private static final String VALUE = "value";
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private RelationColumn uiModelColumn;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private Command executeCanvasOperation;
    @Mock
    private Command undoCanvasOperation;
    @Mock
    private AbstractCanvasHandler handler;
    @Mock
    private GraphCommandExecutionContext gce;
    @Mock
    private RuleManager ruleManager;
    private Relation relation;
    private InformationItem informationItem;
    private GridData uiModel;
    private RelationUIModelMapper uiModelMapper;
    private DeleteRelationColumnCommand command;

    @Before
    public void setup() {
        this.relation = new Relation();
        this.informationItem = new InformationItem();
        this.relation.getColumn().add(this.informationItem);
        this.uiModel = new BaseGridData();
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.uiModel.appendColumn((GridColumn)this.uiModelColumn);
        ((AbstractCanvasHandler)Mockito.doReturn((Object)this.ruleManager).when((Object)this.handler)).getRuleManager();
        ((RowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((RelationColumn)Mockito.doReturn((Object)1).when((Object)this.uiModelColumn)).getIndex();
        this.uiModelMapper = new RelationUIModelMapper(() -> this.uiModel, () -> Optional.of(this.relation), this.listSelector);
    }

    private void makeCommand(int uiColumnIndex) {
        this.command = (DeleteRelationColumnCommand)Mockito.spy((Object)new DeleteRelationColumnCommand(this.relation, this.uiModel, uiColumnIndex, this.uiModelMapper, this.executeCanvasOperation, this.undoCanvasOperation));
    }

    private void makeCommand() {
        this.makeCommand(1);
    }

    @Test
    public void testGraphCommandAllow() {
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.gce));
    }

    @Test
    public void testGraphCommandExecuteWithRows() {
        this.relation.getRow().add(new List());
        ((List)this.relation.getRow().get(0)).getExpression().add(new LiteralExpression());
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)0L, (long)this.relation.getColumn().size());
        Assert.assertEquals((long)1L, (long)this.relation.getRow().size());
        Assert.assertEquals((long)0L, (long)((List)this.relation.getRow().get(0)).getExpression().size());
    }

    @Test
    public void testGraphCommandExecuteDeleteMiddleWithRows() {
        this.uiModel.appendColumn((GridColumn)Mockito.mock(RelationColumn.class));
        this.uiModel.appendColumn((GridColumn)Mockito.mock(RelationColumn.class));
        this.relation.getColumn().add(new InformationItem());
        this.relation.getColumn().add(new InformationItem());
        this.relation.getRow().add(new List());
        LiteralExpression firstExpression = new LiteralExpression();
        LiteralExpression lastExpression = new LiteralExpression();
        ((List)this.relation.getRow().get(0)).getExpression().add(firstExpression);
        ((List)this.relation.getRow().get(0)).getExpression().add(new LiteralExpression());
        ((List)this.relation.getRow().get(0)).getExpression().add(lastExpression);
        this.makeCommand(2);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)2L, (long)this.relation.getColumn().size());
        Assert.assertEquals((long)1L, (long)this.relation.getRow().size());
        Assert.assertEquals((long)2L, (long)((List)this.relation.getRow().get(0)).getExpression().size());
        Assert.assertEquals((Object)firstExpression, ((List)this.relation.getRow().get(0)).getExpression().get(0));
        Assert.assertEquals((Object)lastExpression, ((List)this.relation.getRow().get(0)).getExpression().get(1));
    }

    @Test
    public void testGraphCommandExecuteWithNoRows() {
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)0L, (long)this.relation.getColumn().size());
        Assert.assertEquals((long)0L, (long)this.relation.getRow().size());
    }

    @Test
    public void testGraphCommandUndoWithRows() {
        this.relation.getRow().add(new List());
        LiteralExpression literalExpression = new LiteralExpression();
        literalExpression.getText().setValue(VALUE);
        ((List)this.relation.getRow().get(0)).getExpression().add(literalExpression);
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assert.assertEquals((long)1L, (long)this.relation.getColumn().size());
        Assert.assertEquals((long)1L, (long)this.relation.getRow().size());
        Assert.assertEquals((long)1L, (long)((List)this.relation.getRow().get(0)).getExpression().size());
        Assert.assertEquals((Object)VALUE, (Object)((LiteralExpression)((List)this.relation.getRow().get(0)).getExpression().get(0)).getText().getValue());
    }

    @Test
    public void testGraphCommandUndoWithNoRows() {
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assert.assertEquals((long)1L, (long)this.relation.getColumn().size());
        Assert.assertEquals((long)0L, (long)this.relation.getRow().size());
    }

    @Test
    public void testCanvasCommandAllow() {
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.handler));
    }

    @Test
    public void testCanvasCommandExecuteWithRows() {
        this.relation.getRow().add(new List());
        ((List)this.relation.getRow().get(0)).getExpression().add(new LiteralExpression());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModelMapper.fromDMNModel(0, 0);
        this.uiModelMapper.fromDMNModel(0, 1);
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((long)1L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((long)1L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((long)1L, (long)((GridRow)this.uiModel.getRows().get(0)).getCells().size());
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
        ((DeleteRelationColumnCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.executeCanvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandExecuteWithNoRows() {
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((long)1L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((long)0L, (long)this.uiModel.getRowCount());
        ((DeleteRelationColumnCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.executeCanvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandUndoWithRows() {
        this.relation.getRow().add(new List());
        LiteralExpression literalExpression = new LiteralExpression();
        literalExpression.getText().setValue(VALUE);
        ((List)this.relation.getRow().get(0)).getExpression().add(literalExpression);
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModelMapper.fromDMNModel(0, 1);
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new DeleteRelationColumnCommand[]{this.command});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        Assert.assertEquals((long)2L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiModelColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((long)1L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((long)1L, (long)((GridRow)this.uiModel.getRows().get(0)).getCells().size());
        Assert.assertEquals((Object)VALUE, (Object)this.uiModel.getCell(0, 1).getValue().getValue());
        ((DeleteRelationColumnCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.undoCanvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandUndoWithNoRows() {
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new DeleteRelationColumnCommand[]{this.command});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        Assert.assertEquals((long)2L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiModelColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((long)0L, (long)this.uiModel.getRowCount());
        ((DeleteRelationColumnCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.undoCanvasOperation)).execute();
    }

    @Test
    public void testComponentWidths() {
        this.makeCommand();
        Mockito.when((Object)this.uiModelColumn.getWidth()).thenReturn((Object)100.0);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.gce));
        Assert.assertEquals((long)this.relation.getRequiredComponentWidthCount(), (long)this.relation.getComponentWidths().size());
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.undo((Object)this.gce));
        Assert.assertEquals((long)this.relation.getRequiredComponentWidthCount(), (long)this.relation.getComponentWidths().size());
        Assert.assertEquals((double)100.0, (double)((Double)this.relation.getComponentWidths().get(1)), (double)0.0);
    }
}

