/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.factory.graph;

import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.v1_1.Decision;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.client.commands.factory.graph.RegisterNodeCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.KindUtilities;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommandTest;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RegisterNodeCommandTest
extends AbstractGraphCommandTest {
    @Mock
    private Node candidate;
    @Mock
    private View candidateContent;
    @Mock
    private DMNDiagram parentDefinition;
    private Decision decision = (Decision)Mockito.spy((Object)new Decision());
    private BusinessKnowledgeModel businessKnowledgeModel = (BusinessKnowledgeModel)Mockito.spy((Object)new BusinessKnowledgeModel());
    private RegisterNodeCommand command;

    @Before
    public void setup() {
        this.init();
        Mockito.when((Object)this.candidate.getContent()).thenReturn((Object)this.candidateContent);
        this.command = new RegisterNodeCommand(this.candidate);
    }

    @Test
    public void testExecuteWithBusinessKnowledgeModelNode() {
        Mockito.when((Object)this.candidateContent.getDefinition()).thenReturn((Object)this.businessKnowledgeModel);
        Assertions.assertThat((Comparable)this.command.execute(this.graphCommandExecutionContext).getType()).isEqualTo((Object)CommandResult.Type.INFO);
        FunctionDefinition encapsulatedLogic = this.businessKnowledgeModel.getEncapsulatedLogic();
        Expression expression = encapsulatedLogic.getExpression();
        Assertions.assertThat((Object)expression).isInstanceOf(LiteralExpression.class);
        Assertions.assertThat((Object)expression.getParent()).isEqualTo((Object)encapsulatedLogic);
        Assertions.assertThat((Comparable)KindUtilities.getKind((FunctionDefinition)encapsulatedLogic)).isEqualTo((Object)FunctionDefinition.Kind.FEEL);
    }

    @Test
    public void testExecuteWithNonBusinessKnowledgeModelNode() {
        Mockito.when((Object)this.candidateContent.getDefinition()).thenReturn((Object)this.decision);
        Assertions.assertThat((Comparable)this.command.execute(this.graphCommandExecutionContext).getType()).isEqualTo((Object)CommandResult.Type.INFO);
    }
}

