/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.general;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.commands.general.BaseClearExpressionCommand;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.mvp.Command;

public abstract class BaseClearExpressionCommandTest<C extends BaseClearExpressionCommand, E extends Expression, M extends BaseUIModelMapper> {
    protected static final int ROW_INDEX = 0;
    protected static final int COLUMN_INDEX = 1;
    @Mock
    protected GridWidget gridWidget;
    @Mock
    protected GridData gridData;
    @Mock
    protected GridCell gridCell;
    @Mock
    protected GridCellValue gridCellValue;
    @Mock
    protected AbstractCanvasHandler canvasHandler;
    @Mock
    protected GraphCommandExecutionContext graphCommandExecutionContext;
    @Mock
    protected HasExpression hasExpression;
    @Mock
    protected Command executeCanvasOperation;
    @Mock
    protected Command undoCanvasOperation;
    protected E expression;
    protected M uiModelMapper;
    protected C command;

    @Before
    public void setup() {
        this.expression = this.makeTestExpression();
        this.uiModelMapper = this.makeTestUiModelMapper();
    }

    protected void makeCommand() {
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)this.gridData);
        Mockito.when((Object)this.gridData.getCell(Matchers.eq((int)0), Matchers.eq((int)1))).thenReturn((Object)this.gridCell);
        Mockito.when((Object)this.gridCell.getValue()).thenReturn((Object)this.gridCellValue);
        this.command = this.makeTestCommand();
    }

    protected abstract E makeTestExpression();

    protected abstract C makeTestCommand();

    protected abstract M makeTestUiModelMapper();

    @Test
    public void checkGraphCommand() {
        this.makeCommand();
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.getGraphCommand(this.canvasHandler).allow((Object)this.graphCommandExecutionContext));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.uiModelMapper});
    }

    @Test
    public void executeGraphCommand() {
        this.makeCommand();
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.getGraphCommand(this.canvasHandler).execute((Object)this.graphCommandExecutionContext));
        ((HasExpression)Mockito.verify((Object)this.hasExpression)).setExpression((Expression)Matchers.eq(null));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.uiModelMapper});
    }

    @Test
    public void undoGraphCommand() {
        Mockito.when((Object)this.hasExpression.getExpression()).thenReturn(this.expression);
        this.makeCommand();
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.getGraphCommand(this.canvasHandler).execute((Object)this.graphCommandExecutionContext));
        ((HasExpression)Mockito.verify((Object)this.hasExpression)).setExpression((Expression)Matchers.eq(null));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.getGraphCommand(this.canvasHandler).undo((Object)this.graphCommandExecutionContext));
        ((HasExpression)Mockito.verify((Object)this.hasExpression)).setExpression((Expression)Matchers.eq(this.expression));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.uiModelMapper});
    }

    @Test
    public void allowCanvasCommand() {
        this.makeCommand();
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).allow((Object)this.canvasHandler));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.uiModelMapper});
    }

    @Test
    public void executeCanvasCommand() {
        this.makeCommand();
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).execute((Object)this.canvasHandler));
        ((BaseUIModelMapper)Mockito.verify(this.uiModelMapper)).fromDMNModel(Matchers.eq((int)0), Matchers.eq((int)1));
        ((Command)Mockito.verify((Object)this.executeCanvasOperation)).execute();
    }

    @Test
    public void undoCanvasCommand() {
        this.makeCommand();
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).undo((Object)this.canvasHandler));
        ((GridData)Mockito.verify((Object)this.gridData)).setCellValue(Matchers.eq((int)0), Matchers.eq((int)1), (GridCellValue)Matchers.eq((Object)this.gridCellValue));
        ((Command)Mockito.verify((Object)this.undoCanvasOperation)).execute();
    }

    @Test
    public void checkCommandDefinition() {
        this.makeCommand();
        Assert.assertTrue((boolean)(this.command instanceof VetoExecutionCommand));
        Assert.assertTrue((boolean)(this.command instanceof VetoUndoCommand));
    }
}

