/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.common;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.v1_1.Decision;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.v1_1.InputData;
import org.kie.workbench.common.dmn.client.common.BoxedExpressionHelper;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class BoxedExpressionHelperTest {
    @Mock
    private Node<View, Edge> node;
    private BoxedExpressionHelper helper;

    @Before
    public void setup() {
        this.helper = new BoxedExpressionHelper();
    }

    @Test
    public void testGetOptionalHasExpressionWhenNodeIsBusinessKnowledgeModel() {
        View content = (View)Mockito.mock(View.class);
        BusinessKnowledgeModel businessKnowledgeModel = new BusinessKnowledgeModel();
        FunctionDefinition encapsulatedLogic = (FunctionDefinition)Mockito.mock(FunctionDefinition.class);
        businessKnowledgeModel.setEncapsulatedLogic(encapsulatedLogic);
        Mockito.when((Object)this.node.getContent()).thenReturn((Object)content);
        Mockito.when((Object)content.getDefinition()).thenReturn((Object)businessKnowledgeModel);
        Optional actualHasExpression = this.helper.getOptionalHasExpression(this.node);
        Assert.assertTrue((boolean)actualHasExpression.isPresent());
        Assert.assertEquals((Object)businessKnowledgeModel, (Object)((HasExpression)actualHasExpression.get()).asDMNModelInstrumentedBase());
        Assert.assertEquals((Object)encapsulatedLogic, (Object)((HasExpression)actualHasExpression.get()).getExpression());
    }

    @Test
    public void testGetOptionalHasExpressionWhenNodeIsDecision() {
        View content = (View)Mockito.mock(View.class);
        Decision expectedHasExpression = (Decision)Mockito.mock(Decision.class);
        Mockito.when((Object)this.node.getContent()).thenReturn((Object)content);
        Mockito.when((Object)content.getDefinition()).thenReturn((Object)expectedHasExpression);
        Optional actualHasExpression = this.helper.getOptionalHasExpression(this.node);
        Assert.assertTrue((boolean)actualHasExpression.isPresent());
        Assert.assertEquals((Object)expectedHasExpression, actualHasExpression.get());
    }

    @Test
    public void testGetOptionalHasExpressionWhenNodeIsOtherDRGElement() {
        View content = (View)Mockito.mock(View.class);
        InputData expectedHasExpression = (InputData)Mockito.mock(InputData.class);
        Mockito.when((Object)this.node.getContent()).thenReturn((Object)content);
        Mockito.when((Object)content.getDefinition()).thenReturn((Object)expectedHasExpression);
        Optional actualHasExpression = this.helper.getOptionalHasExpression(this.node);
        Assert.assertFalse((boolean)actualHasExpression.isPresent());
    }

    @Test
    public void testGetOptionalExpressionWhenIsNotPresent() {
        View content = (View)Mockito.mock(View.class);
        Decision decision = (Decision)Mockito.mock(Decision.class);
        Mockito.when((Object)this.node.getContent()).thenReturn((Object)content);
        Mockito.when((Object)content.getDefinition()).thenReturn((Object)decision);
        Mockito.when((Object)decision.getExpression()).thenReturn(null);
        Optional optionalExpression = this.helper.getOptionalExpression(this.node);
        Assert.assertFalse((boolean)optionalExpression.isPresent());
    }

    @Test
    public void testGetOptionalExpressionWhenIsPresent() {
        View content = (View)Mockito.mock(View.class);
        Decision decision = (Decision)Mockito.mock(Decision.class);
        Expression expectedExpression = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)this.node.getContent()).thenReturn((Object)content);
        Mockito.when((Object)content.getDefinition()).thenReturn((Object)decision);
        Mockito.when((Object)decision.getExpression()).thenReturn((Object)expectedExpression);
        Optional optionalExpression = this.helper.getOptionalExpression(this.node);
        Assert.assertTrue((boolean)optionalExpression.isPresent());
        Assert.assertEquals((Object)expectedExpression, optionalExpression.get());
    }

    @Test
    public void testGetExpression() {
        View content = (View)Mockito.mock(View.class);
        Decision decision = (Decision)Mockito.mock(Decision.class);
        Expression expectedExpression = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)this.node.getContent()).thenReturn((Object)content);
        Mockito.when((Object)content.getDefinition()).thenReturn((Object)decision);
        Mockito.when((Object)decision.getExpression()).thenReturn((Object)expectedExpression);
        Expression actualExpression = this.helper.getExpression(this.node);
        Assert.assertEquals((Object)expectedExpression, (Object)actualExpression);
    }

    @Test
    public void testGetHasExpression() {
        View content = (View)Mockito.mock(View.class);
        Decision expected = (Decision)Mockito.mock(Decision.class);
        Mockito.when((Object)this.node.getContent()).thenReturn((Object)content);
        Mockito.when((Object)content.getDefinition()).thenReturn((Object)expected);
        HasExpression actual = this.helper.getHasExpression(this.node);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetHasExpressionWhenNodeDoesNotHaveExpression() {
        View content = (View)Mockito.mock(View.class);
        Mockito.when((Object)this.node.getContent()).thenReturn((Object)content);
        Mockito.when((Object)content.getDefinition()).thenReturn((Object)new InputData());
        this.helper.getHasExpression(this.node);
    }

    @Test
    public void testGetDefinition() {
        View content = (View)Mockito.mock(View.class);
        Decision expected = (Decision)Mockito.mock(Decision.class);
        Mockito.when((Object)this.node.getContent()).thenReturn((Object)content);
        Mockito.when((Object)content.getDefinition()).thenReturn((Object)expected);
        Object actual = this.helper.getDefinition(this.node);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

